/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.multiblock.child;

import java.util.Arrays;
import java.util.EnumSet;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import nikita488.zycraft.multiblock.child.block.ConvertedMultiChildBlock;
import nikita488.zycraft.util.ZYConstants;

public enum MultiChildProperties {
    AIR((state, getter, pos) -> state.func_196958_f() || state.isAir(getter, pos)),
    FULL_BLOCK(AbstractBlock.AbstractBlockState::func_235785_r_),
    SOLID(AbstractBlock.AbstractBlockState::func_200015_d),
    REQUIRES_TOOL((state, getter, pos) -> state.func_235783_q_()),
    FLAMMABLE((state, getter, pos) -> Arrays.stream(ZYConstants.DIRECTIONS).anyMatch(side -> state.isFlammable(getter, pos, side))),
    GLASS((state, getter, pos) -> state.func_185904_a() == Material.field_151592_s || state.func_185904_a() == Material.field_151591_t);

    public static final MultiChildProperties[] VALUES;
    private final Matcher matcher;

    private MultiChildProperties(Matcher matcher) {
        this.matcher = matcher;
    }

    public static EnumSet<MultiChildProperties> get(IBlockReader getter, BlockPos pos) {
        return MultiChildProperties.get(getter.func_180495_p(pos), getter, pos);
    }

    public static EnumSet<MultiChildProperties> get(BlockState state, IBlockReader getter, BlockPos pos) {
        EnumSet<MultiChildProperties> properties = EnumSet.noneOf(MultiChildProperties.class);
        for (MultiChildProperties type : VALUES) {
            if (!type.matches(state, getter, pos)) continue;
            properties.add(type);
        }
        return properties;
    }

    public boolean matches(BlockState state, IBlockReader getter, BlockPos pos) {
        return (!state.hasTileEntity() || state.func_177230_c() instanceof ConvertedMultiChildBlock) && this.matcher.matches(state, getter, pos);
    }

    static {
        VALUES = MultiChildProperties.values();
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean matches(BlockState var1, IBlockReader var2, BlockPos var3);
    }
}

