/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.registries.ForgeRegistries;
import nikita488.zycraft.init.ZYGroups;
import nikita488.zycraft.init.ZYLang;

public class ZYFluidContainerItem
extends Item {
    protected final int capacity;
    protected final int filledStackSize;

    public ZYFluidContainerItem(Item.Properties properties, int capacity, int filledStackSize) {
        super(properties);
        this.capacity = capacity;
        this.filledStackSize = filledStackSize;
    }

    public int getItemStackLimit(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b("Fluid", 10)) {
            return this.filledStackSize;
        }
        return super.getItemStackLimit(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (level == null) {
            return;
        }
        FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack).orElse(FluidStack.EMPTY);
        if (!fluid.isEmpty()) {
            tooltip.add((ITextComponent)((IFormattableTextComponent)fluid.getDisplayName()).func_240699_a_(TextFormatting.GRAY));
        }
        if (this.capacity > 1000) {
            tooltip.add((ITextComponent)ZYLang.copy(ZYLang.FLUID_TANK_FILLED, fluid.getAmount(), this.capacity));
        }
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (group != ItemGroup.field_78027_g && group != ZYGroups.FLUIDS) {
            return;
        }
        for (Fluid fluid : ForgeRegistries.FLUIDS) {
            if (!fluid.func_207193_c(fluid.func_207188_f())) continue;
            ItemStack stack = new ItemStack((IItemProvider)this);
            FluidStack fluidStack = new FluidStack(fluid, this.capacity);
            IFluidHandlerItem handler = this.createFluidHandler(stack);
            if (handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE) != fluidStack.getAmount()) continue;
            items.add((Object)handler.getContainer());
        }
    }

    protected IFluidHandlerItem createFluidHandler(ItemStack stack) {
        return new FluidHandlerItemStackSimple(stack, this.capacity);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT tag) {
        return new FluidHandlerItemStackSimple(stack, this.capacity);
    }
}

