/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.enums;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.block.AbstractBlock;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import nikita488.zycraft.init.ZYBlocks;
import nikita488.zycraft.init.ZYItems;
import nikita488.zycraft.repack.registrate.util.DataIngredient;
import nikita488.zycraft.repack.registrate.util.nullness.NonNullBiFunction;
import nikita488.zycraft.repack.registrate.util.nullness.NonNullSupplier;
import nikita488.zycraft.repack.registrate.util.nullness.NonNullUnaryOperator;

public enum ViewerType {
    BASIC("glass", () -> DataIngredient.tag((ITag.INamedTag<Item>)Tags.Items.INGOTS_IRON), properties -> properties.func_200948_a(0.3f, 6.0f)),
    DIRE("dire", () -> DataIngredient.items(ZYBlocks.QUARTZ_CRYSTAL, new NonNullSupplier[0])),
    ALUMINIUM("aluminium", () -> DataIngredient.items(ZYItems.ALUMINIUM, new NonNullSupplier[0])),
    REINFORCED("reinforced", () -> DataIngredient.tag((ITag.INamedTag<Item>)Tags.Items.OBSIDIAN), properties -> properties.func_200948_a(0.3f, 1200.0f)),
    GLOWING("glowing", () -> DataIngredient.tag((ITag.INamedTag<Item>)Tags.Items.DUSTS_GLOWSTONE), properties -> properties.func_235838_a_(state -> 15)),
    DARK("dark", () -> DataIngredient.items((IItemProvider)Items.field_196136_br, (IItemProvider[])new Item[0]));

    private final String name;
    private final NonNullSupplier<DataIngredient> ingredient;
    private final NonNullUnaryOperator<AbstractBlock.Properties> properties;
    public static final ViewerType[] VALUES;
    public static final ViewerType[] IMMORTAL_VALUES;

    private ViewerType(String name, NonNullSupplier<DataIngredient> ingredient) {
        this(name, ingredient, NonNullUnaryOperator.identity());
    }

    private ViewerType(String name, NonNullSupplier<DataIngredient> ingredient, NonNullUnaryOperator<AbstractBlock.Properties> properties) {
        this.name = name;
        this.ingredient = ingredient;
        this.properties = properties;
    }

    public static <T> Map<ViewerType, T> buildMap(String pattern, boolean immortal, NonNullBiFunction<ViewerType, String, T> factory) {
        ViewerType[] values;
        ImmutableMap.Builder map = ImmutableMap.builder();
        for (ViewerType type : values = immortal ? IMMORTAL_VALUES : VALUES) {
            String target = immortal && type == BASIC ? "{type}_" : "{type}";
            String replacement = immortal && type == BASIC ? "" : type.toString();
            map.put((Object)type, factory.apply(type, pattern.replace(target, replacement)));
        }
        return map.build();
    }

    public DataIngredient ingredient() {
        return this.ingredient.get();
    }

    public NonNullUnaryOperator<AbstractBlock.Properties> properties() {
        return this.properties;
    }

    public String toString() {
        return this.name;
    }

    static {
        VALUES = new ViewerType[]{BASIC, DIRE, ALUMINIUM, REINFORCED, GLOWING, DARK};
        IMMORTAL_VALUES = new ViewerType[]{BASIC, GLOWING, DARK};
    }
}

