/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.client.particle;

import javax.annotation.Nullable;
import net.minecraft.client.particle.IAnimatedSprite;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.IParticleRenderType;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.SpriteTexturedParticle;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.world.ClientWorld;
import nikita488.zycraft.particle.SparkleParticleData;

public class SparkleParticle
extends SpriteTexturedParticle {
    private final IAnimatedSprite sprites;
    private final boolean hasFixedSize;

    public SparkleParticle(ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, IAnimatedSprite sprites, boolean hasFixedSize) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.sprites = sprites;
        this.hasFixedSize = hasFixedSize;
    }

    public void func_189213_a() {
        super.func_189213_a();
        this.func_217566_b(this.sprites);
    }

    public void func_217566_b(IAnimatedSprite sprites) {
        this.func_217567_a(sprites.func_217591_a(this.field_70546_d, this.field_70547_e));
    }

    public void selectSprite(int index) {
        this.func_217567_a(this.sprites.func_217591_a(index, 5));
    }

    public float func_217561_b(float partialTicks) {
        return this.hasFixedSize ? this.field_70544_f : this.field_70544_f * (float)(this.field_70547_e - this.field_70546_d) / (float)this.field_70547_e;
    }

    public IParticleRenderType func_217558_b() {
        return IParticleRenderType.field_217603_c;
    }

    protected int func_189214_a(float partialTick) {
        return LightTexture.func_228451_a_((int)15, (int)15);
    }

    public void setParticleSpeed(double x, double y, double z) {
        this.field_187129_i = x / (double)this.field_70547_e;
        this.field_187130_j = y / (double)this.field_70547_e;
        this.field_187131_k = z / (double)this.field_70547_e;
    }

    public void setGravity(float gravity) {
        this.field_70545_g = gravity;
    }

    public static class Provider
    implements IParticleFactory<SparkleParticleData> {
        private final IAnimatedSprite sprites;

        public Provider(IAnimatedSprite sprites) {
            this.sprites = sprites;
        }

        @Nullable
        public Particle createParticle(SparkleParticleData data, ClientWorld level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            SparkleParticle sparkle = new SparkleParticle(level, x, y, z, 0.0, 0.0, 0.0, this.sprites, data.hasFixedSize());
            sparkle.func_70538_b(data.r(), data.g(), data.b());
            sparkle.func_82338_g(data.a());
            sparkle.func_187114_a(5 * data.lifetimeFactor());
            sparkle.func_70541_f(data.sizeFactor());
            sparkle.setGravity(data.gravity());
            sparkle.field_190017_n = data.hasPhysics();
            if (!data.hasMotion()) {
                sparkle.setParticleSpeed(0.0, 0.0, 0.0);
            } else {
                sparkle.setParticleSpeed(xSpeed, ySpeed, zSpeed);
            }
            sparkle.func_217566_b(this.sprites);
            return sparkle;
        }
    }
}

