/*
 * Decompiled with CFR 0.152.
 */
package nikita488.zycraft.block;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.DrinkHelper;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import nikita488.zycraft.api.fluid.IFluidSource;
import nikita488.zycraft.util.FluidUtils;
import nikita488.zycraft.util.ZYConstants;

public class ZychoriumWaterBlock
extends Block
implements IFluidSource {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;

    public ZychoriumWaterBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)POWERED) == false ? Fluids.field_204546_a.func_207207_a(1, false) : Fluids.field_204541_a.func_207188_f();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(context.func_195991_k().func_175640_z(context.func_195995_a())));
    }

    public void func_220082_b(BlockState state, World level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            return;
        }
        for (Direction side : ZYConstants.DIRECTIONS) {
            BlockPos relativePos = pos.func_177972_a(side);
            FluidState fluidState = level.func_204610_c(relativePos);
            if (!fluidState.func_206884_a((ITag)FluidTags.field_206960_b)) continue;
            level.func_175656_a(relativePos, ForgeEventFactory.fireFluidPlaceBlockEvent((IWorld)level, (BlockPos)relativePos, (BlockPos)pos, (BlockState)(fluidState.func_206889_d() ? Blocks.field_150343_Z : Blocks.field_150347_e).func_176223_P()));
            level.func_217379_c(1501, relativePos, -1);
        }
    }

    public void func_220069_a(BlockState state, World level, BlockPos pos, Block block, BlockPos relativePos, boolean isMoving) {
        if (level.func_175640_z(pos) != ((Boolean)state.func_177229_b((Property)POWERED)).booleanValue()) {
            level.func_180501_a(pos, (BlockState)state.func_235896_a_((Property)POWERED), 2);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hitResult) {
        FluidStack water;
        ItemStack heldStack = player.func_184586_b(hand);
        Optional<IFluidHandlerItem> capability = FluidUtils.getItemFluidHandler(heldStack);
        if (!capability.isPresent()) {
            return ActionResultType.PASS;
        }
        IFluidHandlerItem handler = capability.get();
        if (handler.fill(water = new FluidStack((Fluid)Fluids.field_204546_a, 1000), IFluidHandler.FluidAction.SIMULATE) <= 0) {
            return ActionResultType.PASS;
        }
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)heldStack.func_77973_b()));
        player.func_184185_a(water.getFluid().getAttributes().getFillSound(), 1.0f, 1.0f);
        if (level.func_201670_d()) {
            return ActionResultType.SUCCESS;
        }
        handler.fill(water, IFluidHandler.FluidAction.EXECUTE);
        ItemStack filledContainer = DrinkHelper.func_241445_a_((ItemStack)heldStack, (PlayerEntity)player, (ItemStack)handler.getContainer(), (boolean)false);
        CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)player, filledContainer);
        if (heldStack != filledContainer) {
            player.func_184611_a(hand, filledContainer);
        }
        return ActionResultType.CONSUME;
    }

    @Override
    public FluidStack getFluid(BlockState state, World level, BlockPos pos, @Nullable Direction side) {
        return (Boolean)state.func_177229_b((Property)POWERED) == false ? new FluidStack((Fluid)Fluids.field_204546_a, 50) : FluidStack.EMPTY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWERED});
    }
}

