/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.attributeslib.api;

import dev.shadowsoffire.attributeslib.ALConfig;
import dev.shadowsoffire.attributeslib.api.ALObjects;
import java.math.BigDecimal;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public class ALCombatRules {
    public static float getDamageAfterProtection(class_1309 target, class_1282 src, float amount, float protPoints) {
        class_1297 class_12972 = src.method_5529();
        if (class_12972 instanceof class_1309) {
            float pierce;
            class_1309 attacker = (class_1309)class_12972;
            float shred = (float)attacker.method_26825(ALObjects.Attributes.PROT_SHRED);
            if (shred > 0.001f) {
                protPoints *= 1.0f - shred;
            }
            if ((pierce = (float)attacker.method_26825(ALObjects.Attributes.PROT_PIERCE)) > 0.001f) {
                protPoints -= pierce;
            }
        }
        if (protPoints <= 0.0f) {
            return amount;
        }
        return amount * ALCombatRules.getProtDamageReduction(protPoints);
    }

    public static float getProtDamageReduction(float protPoints) {
        if (ALConfig.getProtExpr().isPresent()) {
            return ALConfig.getProtExpr().get().setVariable("protPoints", new BigDecimal(protPoints)).eval().floatValue();
        }
        return 1.0f - Math.min(0.025f * protPoints, 0.85f);
    }

    public static float getDamageAfterArmor(class_1309 target, class_1282 src, float amount, float armor, float toughness) {
        class_1297 class_12972 = src.method_5529();
        if (class_12972 instanceof class_1309) {
            float pierce;
            class_1309 attacker = (class_1309)class_12972;
            float shred = (float)attacker.method_26825(ALObjects.Attributes.ARMOR_SHRED);
            float bypassResist = Math.min(toughness * 0.02f, 0.6f);
            if (shred > 0.001f) {
                armor *= 1.0f - (shred *= 1.0f - bypassResist);
            }
            if ((pierce = (float)attacker.method_26825(ALObjects.Attributes.ARMOR_PIERCE)) > 0.001f) {
                armor -= (pierce *= 1.0f - bypassResist);
            }
        }
        if (armor <= 0.0f) {
            return amount;
        }
        return amount * ALCombatRules.getArmorDamageReduction(amount, armor);
    }

    public static float getAValue(float damage) {
        if (ALConfig.getAValueExpr().isPresent()) {
            return ALConfig.getAValueExpr().get().setVariable("damage", new BigDecimal(damage)).eval().floatValue();
        }
        return damage < 20.0f ? 10.0f : 10.0f + (damage - 20.0f) / 2.0f;
    }

    public static float getArmorDamageReduction(float damage, float armor) {
        float a = ALCombatRules.getAValue(damage);
        if (ALConfig.getArmorExpr().isPresent()) {
            return ALConfig.getArmorExpr().get().setVariable("a", new BigDecimal(a)).setVariable("damage", new BigDecimal(damage)).setVariable("armor", new BigDecimal(armor)).eval().floatValue();
        }
        return a / (a + armor);
    }
}

