/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import com.google.common.base.Preconditions;
import dev.shadowsoffire.placebo.config.Configuration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1308;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1832;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class NameHelper {
    private static String[] names = new String[]{"Prim", "Tyrael", "Bajorno", "Michael Morbius", "Morbius", "Arun", "Panez", "Doomsday", "Vanamar", "WhatTheDrunk", "Bagel", "Lothrazar", "Chelly", "Chelicia", "Darsh", "Dariush", "Cheese E Piloza", "Bing", "Royal", "NoWayHere", "SwankyStella", "Isosahedron", "Chorb", "Asfalis", "Biz", "Icicle", "Darko", "Shadows", "Katarina", "Faellynna", "Diliviel", "Jank", "Albert", "Andrew", "Anderson", "Andy", "Allan", "Arthur", "Aaron", "Allison", "Arielle", "Amanda", "Anne", "Annie", "Amy", "Alana", "Brandon", "Brady", "Bernard", "Ben", "Benjamin", "Bob", "Bobette", "Brooke", "Brandy", "Beatrice", "Bea", "Bella", "Becky", "Carlton", "Carl", "Calvin", "Cameron", "Carson", "Chase", "Cassandra", "Cassie", "Cas", "Carol", "Carly", "Cherise", "Charlotte", "Cheryl", "Chasity", "Danny", "Drake", "Daniel", "Derrel", "David", "Dave", "Donovan", "Don", "Donald", "Drew", "Derrick", "Darla", "Donna", "Dora", "Danielle", "Edward", "Elliot", "Ed", "Edson", "Elton", "Eddison", "Earl", "Eric", "Ericson", "Eddie", "Ediovany", "Emma", "Elizabeth", "Eliza", "Esperanza", "Esper", "Esmeralda", "Emi", "Emily", "Elaine", "Fernando", "Ferdinand", "Fred", "Feddie", "Fredward", "Frank", "Franklin", "Felix", "Felicia", "Fran", "Greg", "Gregory", "George", "Gerald", "Gina", "Geraldine", "Gabby", "Hendrix", "Henry", "Hobbes", "Herbert", "Heath", "Henderson", "Helga", "Hera", "Helen", "Helena", "Hannah", "Ike", "Issac", "Israel", "Ismael", "Irlanda", "Isabelle", "Irene", "Irenia", "Jimmy", "Jim", "Justin", "Jacob", "Jake", "Jon", "Johnson", "Jonny", "Jonathan", "Josh", "Joshua", "Julian", "Jesus", "Jericho", "Jeb", "Jess", "Joan", "Jill", "Jillian", "Jessica", "Jennifer", "Jenny", "Jen", "Judy", "Kenneth", "Kenny", "Ken", "Keith", "Kevin", "Karen", "Kassandra", "Kassie", "Leonard", "Leo", "Leroy", "Lee", "Lenny", "Luke", "Lucas", "Liam", "Lorraine", "Latasha", "Lauren", "Laquisha", "Livia", "Lydia", "Lila", "Lilly", "Lillian", "Lilith", "Lana", "Mason", "Mike", "Mickey", "Mario", "Manny", "Mark", "Marcus", "Martin", "Marty", "Matthew", "Matt", "Max", "Maximillian", "Marth", "Mia", "Marriah", "Maddison", "Maddie", "Marissa", "Miranda", "Mary", "Martha", "Melonie", "Melody", "Mel", "Minnie", "Nathan", "Nathaniel", "Nate", "Ned", "Nick", "Norman", "Nicholas", "Natasha", "Nicki", "Nora", "Nelly", "Nina", "Orville", "Oliver", "Orlando", "Owen", "Olsen", "Odin", "Olaf", "Ortega", "Olivia", "Patrick", "Pat", "Paul", "Perry", "Pinnochio", "Patrice", "Patricia", "Pennie", "Petunia", "Patti", "Pernelle", "Quade", "Quincy", "Quentin", "Quinn", "Roberto", "Robbie", "Rob", "Robert", "Roy", "Roland", "Ronald", "Richard", "Rick", "Ricky", "Rose", "Rosa", "Rhonda", "Rebecca", "Roberta", "Sparky", "Shiloh", "Stephen", "Steve", "Saul", "Sheen", "Shane", "Sean", "Sampson", "Samuel", "Sammy", "Stefan", "Sasha", "Sam", "Susan", "Suzy", "Shelby", "Samantha", "Sheila", "Sharon", "Sally", "Stephanie", "Sandra", "Sandy", "Sage", "Tim", "Thomas", "Thompson", "Tyson", "Tyler", "Tom", "Tyrone", "Timmothy", "Tamara", "Tabby", "Tabitha", "Tessa", "Tiara", "Tyra", "Uriel", "Ursala", "Uma", "Victor", "Vincent", "Vince", "Vance", "Vinny", "Velma", "Victoria", "Veronica", "Wilson", "Wally", "Wallace", "Will", "Wilard", "William", "Wilhelm", "Xavier", "Xandra", "Young", "Yvonne", "Yolanda", "Zach", "Zachary"};
    private static String[] nameParts = new String[]{"Prim", "Morb", "Ius", "Kat", "Chel", "Bing", "Darsh", "Jank", "Dark", "Osto", "Grab", "Thar", "Ger", "Ald", "Mas", "On", "O", "Din", "Thor", "Jon", "Ath", "Burb", "En", "A", "E", "I", "U", "Hab", "Bloo", "Ena", "Dit", "Aph", "Ern", "Bor", "Dav", "Id", "Toast", "Son", "For", "Wen", "Lob", "Van", "Zap", "Ear", "Ben", "Don", "Bran", "Gro", "Jen", "Bob", "Ette", "Ere", "Man", "Qua", "Bro", "Cree", "Per", "Skel", "Ton", "Zom", "Bie", "Wolf", "End", "Er", "Pig", "Sil", "Ver", "Fish", "Cow", "Chic", "Ken", "Sheep", "Squid", "Hell"};
    private static String[] prefixes = new String[]{"Dr. Michael", "Sir", "Mister", "Madam", "Doctor", "Father", "Mother", "Poppa", "Lord", "Lady", "Overseer", "Professor", "Mr.", "Mr. President", "Duke", "Duchess", "Dame", "The Honorable", "Chancellor", "Vice-Chancellor", "His Holiness", "Reverend", "Count", "Viscount", "Earl", "Captain", "Major", "General", "Senpai"};
    private static String[] suffixes = new String[]{"Morbius", "Dragonborn", "Rejected", "Mighty", "Supreme", "Superior", "Ultimate", "Lame", "Wimpy", "Curious", "Sneaky", "Pathetic", "Crying", "Eagle", "Errant", "Unholy", "Questionable", "Mean", "Hungry", "Thirsty", "Feeble", "Wise", "Sage", "Magical", "Mythical", "Legendary", "Not Very Nice", "Jerk", "Doctor", "Misunderstood", "Angry", "Knight", "Bishop", "Godly", "Special", "Toasty", "Shiny", "Shimmering", "Light", "Dark", "Odd-Smelling", "Funky", "Rock Smasher", "Son of Herobrine", "Cracked", "Sticky", "\u00a7kAlien\u00a7r", "Baby", "Manly", "Rough", "Scary", "Undoubtable", "Honest", "Non-Suspicious", "Boring", "Odd", "Lazy", "Super", "Nifty", "Ogre Slayer", "Pig Thief", "Dirt Digger", "Really Cool", "Doominator", "... Something", "Extra-Fishy", "Gorilla Slaughterer", "Marbles Winner", "AC Rizzlord", "President", "Burger Chef", "Professional Animator", "Cheese Sprayer", "Happiness Advocate", "Ghost Hunter", "Head of Potatoes", "Ninja", "Warrior", "Pyromancer"};
    private static String[] helms = new String[]{"Helmet", "Cap", "Crown", "Great Helm", "Bassinet", "Sallet", "Close Helm", "Barbute"};
    private static String[] chestplates = new String[]{"Chestplate", "Tunic", "Brigandine", "Hauberk", "Cuirass"};
    private static String[] leggings = new String[]{"Leggings", "Pants", "Tassets", "Cuisses", "Schynbalds"};
    private static String[] boots = new String[]{"Boots", "Shoes", "Greaves", "Sabatons", "Sollerets"};
    private static String[] swords = new String[]{"Sword", "Cutter", "Slicer", "Dicer", "Knife", "Blade", "Machete", "Brand", "Claymore", "Cutlass", "Foil", "Dagger", "Glaive", "Rapier", "Saber", "Scimitar", "Shortsword", "Longsword", "Broadsword", "Calibur"};
    private static String[] axes = new String[]{"Axe", "Chopper", "Hatchet", "Tomahawk", "Cleaver", "Hacker", "Tree-Cutter", "Truncator"};
    private static String[] pickaxes = new String[]{"Pickaxe", "Pick", "Mattock", "Rock-Smasher", "Miner"};
    private static String[] shovels = new String[]{"Shovel", "Spade", "Digger", "Excavator", "Trowel", "Scoop"};
    private static String[] bows = new String[]{"Bow", "Shortbow", "Longbow", "Flatbow", "Recurve Bow", "Reflex Bow", "Self Bow", "Composite Bow", "Arrow-Flinger"};
    private static String[] shields = new String[]{"Shield", "Buckler", "Targe", "Greatshield", "Blockade", "Bulwark", "Tower Shield", "Protector", "Aegis"};
    private static Map<class_1832, String> tierKeys = new HashMap<class_1832, String>();
    private static Map<class_1741, String> materialKeys = new HashMap<class_1741, String>();
    private static Map<String, String[]> tierNames = new HashMap<String, String[]>();
    private static Map<String, String[]> materialNames;
    public static String suffixFormat;
    public static String ownershipFormat;
    public static String chainFormat;

    public static String nameFromParts(class_5819 random) {
        String name = nameParts[random.method_43048(nameParts.length)] + nameParts[random.method_43048(nameParts.length)].toLowerCase();
        if (random.method_43057() < 0.4f) {
            name = name + nameParts[random.method_43048(nameParts.length)].toLowerCase();
        }
        if (random.method_43057() < 0.15f) {
            name = name + nameParts[random.method_43048(nameParts.length)].toLowerCase();
        }
        return name;
    }

    public static String setEntityName(class_5819 rand, class_1308 entity) {
        String root = names.length > 0 && nameParts.length > 0 ? (rand.method_43057() < 0.8f ? names[rand.method_43048(names.length)] : NameHelper.nameFromParts(rand)) : (names.length > 0 ? names[rand.method_43048(names.length)] : NameHelper.nameFromParts(rand));
        Object name = root;
        if (rand.method_43057() < 0.3f && prefixes.length > 0) {
            name = prefixes[rand.method_43048(prefixes.length)] + " " + (String)name;
        }
        if (rand.method_43057() < 0.8f && suffixes.length > 0) {
            name = String.format(suffixFormat, name, suffixes[rand.method_43048(suffixes.length)]);
        }
        entity.method_5665((class_2561)class_2561.method_43470((String)name));
        entity.method_5880(true);
        return root;
    }

    public static class_2561 setItemName(class_5819 random, class_1799 stack) {
        class_5250 name = (class_5250)stack.method_7909().method_7864(stack);
        String baseName = name.getString();
        if (stack.method_7909() instanceof class_1831) {
            class_1832 tier = ((class_1831)stack.method_7909()).method_8022();
            String[] tierNames = NameHelper.getTierNames(tier);
            if (tierNames.length == 0) {
                String[] split = baseName.split(" ");
                Object rebuilt = "";
                for (int i = 0; i < split.length - 1; ++i) {
                    rebuilt = (String)rebuilt + split[i] + " ";
                }
                name = class_2561.method_43470((String)rebuilt);
            } else {
                name = class_2561.method_43470((String)(tierNames[random.method_43048(tierNames.length)] + " "));
            }
            String[] type = new String[]{"Tool"};
            if (stack.method_7909() instanceof class_1829) {
                type = swords;
            } else if (stack.method_7909() instanceof class_1743) {
                type = axes;
            } else if (stack.method_7909() instanceof class_1810) {
                type = pickaxes;
            } else if (stack.method_7909() instanceof class_1821) {
                type = shovels;
            } else if (stack.method_7909() instanceof class_1819) {
                type = shields;
            }
            name.method_27693(type[random.method_43048(type.length)]);
        } else if (stack.method_7909() instanceof class_1811) {
            String[] type = bows;
            name = class_2561.method_43470((String)type[random.method_43048(type.length)]);
        } else if (stack.method_7909() instanceof class_1738) {
            class_1741 armorMat = ((class_1738)stack.method_7909()).method_7686();
            String[] matNames = NameHelper.getMaterialNames(armorMat);
            if (matNames.length == 0) {
                String[] split = baseName.split(" ");
                Object rebuilt = "";
                for (int i = 0; i < split.length - 1; ++i) {
                    rebuilt = (String)rebuilt + split[i] + " ";
                }
                name = class_2561.method_43470((String)rebuilt);
            } else {
                name = class_2561.method_43470((String)(matNames[random.method_43048(matNames.length)] + " "));
            }
            String[] type = new String[]{"Armor"};
            switch (((class_1738)stack.method_7909()).method_7685()) {
                case field_6169: {
                    type = helms;
                    break;
                }
                case field_6174: {
                    type = chestplates;
                    break;
                }
                case field_6172: {
                    type = leggings;
                    break;
                }
                case field_6166: {
                    type = boots;
                    break;
                }
            }
            name.method_27693(type[random.method_43048(type.length)]);
        }
        stack.method_7977((class_2561)name);
        return name;
    }

    public static String[] getTierNames(class_1832 materialName) {
        return tierNames.computeIfAbsent(NameHelper.getKey(materialName), s -> new String[0]);
    }

    public static String[] getMaterialNames(class_1741 materialName) {
        return materialNames.computeIfAbsent(NameHelper.getKey(materialName), s -> new String[0]);
    }

    public static void load(Configuration c) {
        String[] read;
        String key;
        List items;
        class_1832 tier;
        names = c.getStringList("Names", "entity", names, "A list of full names, which are used in the generation of boss names. May be empty only if name parts is not empty.");
        nameParts = c.getStringList("Name Parts", "entity", nameParts, "A list of name pieces, which can be spliced together to create full names.  May be empty only if names is not empty.");
        Preconditions.checkArgument((names.length != 0 || nameParts.length != 0 ? 1 : 0) != 0, (Object)"Both names and name parts are empty in apotheosis/names.cfg, this is not allowed.");
        prefixes = c.getStringList("Prefixes", "entity", prefixes, "A list of prefixes, which are used in the generation of boss names. May be empty.");
        suffixes = c.getStringList("Suffixes", "entity", suffixes, "A list of suffixes, which are used in the generation of boss names. A suffix is always preceeded by \"The\". May be empty.");
        helms = c.getStringList("Helms", "items", helms, "A list of root names for helms, used in the generation of item names. May not be empty.");
        chestplates = c.getStringList("chestplates", "items", chestplates, "A list of root names for chestplates, used in the generation of item names. May not be empty.");
        leggings = c.getStringList("leggings", "items", leggings, "A list of root names for leggings, used in the generation of item names. May not be empty.");
        boots = c.getStringList("boots", "items", boots, "A list of root names for boots, used in the generation of item names. May not be empty.");
        Preconditions.checkArgument((helms.length > 0 && chestplates.length > 0 && leggings.length > 0 && boots.length > 0 ? 1 : 0) != 0, (Object)"Detected empty lists for armor root names in apotheosis/names.cfg, this is not allowed.");
        swords = c.getStringList("swords", "items", swords, "A list of root names for swords, used in the generation of item names. May not be empty.");
        axes = c.getStringList("axes", "items", axes, "A list of root names for axes, used in the generation of item names. May not be empty.");
        pickaxes = c.getStringList("pickaxes", "items", pickaxes, "A list of root names for pickaxes, used in the generation of item names. May not be empty.");
        shovels = c.getStringList("shovels", "items", shovels, "A list of root names for shovels, used in the generation of item names. May not be empty.");
        bows = c.getStringList("bows", "items", bows, "A list of root names for bows, used in the generation of item names. May not be empty.");
        shields = c.getStringList("shields", "items", shields, "A list of root names for shields, used in the generation of item names. May not be empty.");
        Preconditions.checkArgument((swords.length > 0 && axes.length > 0 && pickaxes.length > 0 && shovels.length > 0 && bows.length > 0 ? 1 : 0) != 0, (Object)"Detected empty lists for weapon root names in apotheosis/names.cfg, this is not allowed.");
        HashMap<class_1832, List> itemsByTier = new HashMap<class_1832, List>();
        HashMap<class_1741, List> armorsByTier = new HashMap<class_1741, List>();
        for (class_1792 i : class_7923.field_41178) {
            try {
                class_1832 mat;
                if (i instanceof class_1831) {
                    mat = ((class_1831)i).method_8022();
                    itemsByTier.computeIfAbsent(mat, m -> new ArrayList()).add(i);
                }
                if (!(i instanceof class_1738)) continue;
                mat = ((class_1738)i).method_7686();
                armorsByTier.computeIfAbsent((class_1741)mat, m -> new ArrayList()).add(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (Map.Entry e : itemsByTier.entrySet()) {
            tier = (class_1832)e.getKey();
            items = (List)e.getValue();
            key = NameHelper.getID(tier, items);
            tierKeys.put(tier, key);
            read = c.getStringList(key, "tools", tierNames.getOrDefault(tier, new String[0]), NameHelper.computeComment(items, () -> ((class_1832)tier).method_8023()));
            if (read.length <= 0) continue;
            tierNames.put(key, read);
        }
        for (Map.Entry e : armorsByTier.entrySet()) {
            tier = (class_1741)e.getKey();
            items = (List)e.getValue();
            key = NameHelper.getID(tier, items);
            read = c.getStringList(key, "armors", materialNames.getOrDefault(tier, new String[0]), NameHelper.computeComment(items, () -> ((class_1741)tier).method_7695()));
            if (read.length <= 0) continue;
            materialNames.put(key, read);
        }
        suffixFormat = c.getString("Suffix Format", "formatting", suffixFormat, "The format string that will be used when a suffix is applied.");
        ownershipFormat = c.getString("Ownership Format", "formatting", ownershipFormat, "The format string that will be used to indicate ownership.");
        if (c.hasChanged()) {
            c.save();
        }
    }

    private static String computeComment(List<class_1792> items, Supplier<class_1856> repair) {
        Object cmt = "A list of material-based prefix names for this material group. May be empty.\n";
        cmt = (String)cmt + "Items in this group: ";
        for (class_1792 i : items) {
            cmt = (String)cmt + class_7923.field_41178.method_10221((Object)i) + ", ";
        }
        cmt = ((String)cmt).substring(0, ((String)cmt).length() - 2);
        return (String)cmt + "\n";
    }

    private static String getID(Object o, List<class_1792> items) {
        if (o instanceof Enum) {
            return ((Enum)o).name();
        }
        class_2960 id = class_7923.field_41178.method_10221((Object)items.get(0));
        return id.method_12836() + "_" + id.method_12832();
    }

    private static String getKey(class_1832 tier) {
        return tierKeys.getOrDefault(tier, "");
    }

    private static String getKey(class_1741 mat) {
        return materialKeys.getOrDefault(mat, "");
    }

    static {
        tierNames.put(class_1834.field_8922.name(), new String[]{"Wooden", "Wood", "Hardwood", "Balsa Wood", "Mahogany", "Plywood"});
        tierNames.put(class_1834.field_8927.name(), new String[]{"Stone", "Rock", "Marble", "Cobblestone"});
        tierNames.put(class_1834.field_8923.name(), new String[]{"Iron", "Steel", "Ferrous", "Rusty", "Wrought Iron"});
        tierNames.put(class_1834.field_8929.name(), new String[]{"Golden", "Gold", "Gilt", "Auric", "Ornate"});
        tierNames.put(class_1834.field_8930.name(), new String[]{"Diamond", "Zircon", "Gemstone", "Jewel", "Crystal"});
        tierNames.put(class_1834.field_22033.name(), new String[]{"Burnt", "Embered", "Fiery", "Hellborn", "Flameforged"});
        tierNames.put("twilightforest_ironwood_sword", new String[]{"Ironwood", "Earthbound", "Oaken", "Ironcapped"});
        tierNames.put("twilightforest_knightmetal_sword", new String[]{"Knightmetal", "Knightly", "Phantom-Forged"});
        tierNames.put("twilightforest_steeleaf_sword", new String[]{"Steeleaf", "Organic", "Natural", "Cobaltstem", "Tungstenpetal"});
        tierNames.put("twilightforest_fiery_sword", new String[]{"Fiery", "Flaming", "Hydra-Infused", "Infernal"});
        materialNames = new HashMap<String, String[]>();
        materialNames.put(class_1740.field_7897.name(), new String[]{"Leather", "Rawhide", "Lamellar", "Cow Skin"});
        materialNames.put(class_1740.field_7887.name(), new String[]{"Chainmail", "Chain", "Chain Link", "Scale"});
        materialNames.put(class_1740.field_7892.name(), tierNames.get(class_1834.field_8923.name()));
        materialNames.put(class_1740.field_7895.name(), tierNames.get(class_1834.field_8929.name()));
        materialNames.put(class_1740.field_7889.name(), tierNames.get(class_1834.field_8930.name()));
        materialNames.put(class_1740.field_21977.name(), tierNames.get(class_1834.field_22033.name()));
        materialNames.put(class_1740.field_7890.name(), new String[]{"Tortollan", "Very Tragic", "Environmental", "Organic"});
        materialNames.put("ARMOR_IRONWOOD", tierNames.get("twilightforest_ironwood_sword"));
        materialNames.put("ARMOR_KNIGHTLY", tierNames.get("twilightforest_knightmetal_sword"));
        materialNames.put("ARMOR_STEELEAF", tierNames.get("twilightforest_steeleaf_sword"));
        materialNames.put("ARMOR_FIERY", tierNames.get("twilightforest_fiery_sword"));
        materialNames.put("ARMOR_ARCTIC", new String[]{"Arctic", "Frostforged", "Caribou Skin", "Gutskin", "Insulating"});
        materialNames.put("ARMOR_YETI", new String[]{"Yeti", "Abominable", "Snow-Demon", "Grinch"});
        suffixFormat = "%s the %s";
        ownershipFormat = "%s's";
        chainFormat = "%s %s";
    }
}

