/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.util;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.village.util.WandererTradeEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;

public class Events {
    public static void init() {
        ServerLifecycleEvents.SERVER_STARTING.register(listener -> {
            if (Apotheosis.enableVillage) {
                WandererTradeEvent.postWandererEvent();
            }
        });
    }

    public static interface OnEntityDeath {
        public static final Event<OnEntityDeath> LIVING_DEATH = EventFactory.createArrayBacked(OnEntityDeath.class, callbacks -> (entity, source) -> {
            for (OnEntityDeath callback : callbacks) {
                callback.onDeath(entity, source);
            }
        });

        public void onDeath(class_1309 var1, class_1282 var2);
    }

    public static class AnvilUpdate {
        public static final Event<UpdateAnvil> UPDATE_ANVIL = EventFactory.createArrayBacked(UpdateAnvil.class, callbacks -> event -> {
            for (UpdateAnvil callback : callbacks) {
                if (!callback.onUpdate(event)) continue;
                return true;
            }
            return false;
        });

        @FunctionalInterface
        public static interface UpdateAnvil {
            public boolean onUpdate(UpdateAnvilEvent var1);
        }

        public static class UpdateAnvilEvent {
            public final class_1799 left;
            public final class_1799 right;
            public final String name;
            public final class_1657 player;
            public class_1799 output;
            public int cost;
            public int materialCost;

            public UpdateAnvilEvent(class_1799 left, class_1799 right, String name, int cost, class_1657 player) {
                this.player = player;
                this.output = class_1799.field_8037;
                this.left = left;
                this.right = right;
                this.name = name;
                this.cost = cost;
                this.materialCost = 0;
            }
        }
    }

    public static class RepairEvent {
        public final class_1657 player;
        public final class_1799 output;
        public final class_1799 left;
        public final class_1799 right;
        public float breakChance;

        public RepairEvent(class_1657 player, class_1799 output, class_1799 left, class_1799 right) {
            this.player = player;
            this.output = output;
            this.left = left;
            this.right = right;
            this.breakChance = 0.12f;
        }
    }

    @FunctionalInterface
    public static interface AnvilRepair {
        public static final Event<AnvilRepair> ANVIL_REPAIR = EventFactory.createArrayBacked(AnvilRepair.class, callbacks -> event -> {
            for (AnvilRepair callback : callbacks) {
                callback.onRepair(event);
            }
        });

        public void onRepair(RepairEvent var1);
    }
}

