/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin.spawn;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.mixin.accessors.BaseSpawnerAccessor;
import dev.shadowsoffire.apotheosis.spawn.spawner.IBaseSpawner;
import dev.shadowsoffire.apotheosis.spawn.spawner.LyingLevel;
import dev.shadowsoffire.attributeslib.components.SyncedBooleanComponent;
import javax.annotation.Nullable;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1317;
import net.minecraft.class_1917;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1952;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2636;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6005;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_2636.class})
public abstract class SpawnerBlockEntityMixin
extends class_2586
implements IBaseSpawner {
    @Unique
    public boolean ignoresPlayers = false;
    @Unique
    public boolean ignoresConditions = false;
    @Unique
    public boolean redstoneControl = false;
    @Unique
    public boolean ignoresLight = false;
    @Unique
    public boolean hasNoAI = false;
    @Unique
    public boolean silent = false;
    @Unique
    public boolean baby = false;
    @Final
    @Shadow
    @Mutable
    private class_1917 field_12114;

    public SpawnerBlockEntityMixin(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    @Shadow
    public abstract void method_11014(class_2487 var1);

    @Override
    public boolean zenith$getIgnorePlayers() {
        return this.ignoresPlayers;
    }

    @Override
    public void zenith$setIgnoresPlayers(boolean bool) {
        this.ignoresPlayers = bool;
    }

    @Override
    public boolean zenith$getIgnoresConditions() {
        return this.ignoresConditions;
    }

    @Override
    public void zenith$setIgnoresConditions(boolean bool) {
        this.ignoresConditions = bool;
    }

    @Override
    public boolean zenith$getRedstoneControl() {
        return this.redstoneControl;
    }

    @Override
    public void zenith$setRedstoneControl(boolean bool) {
        this.redstoneControl = bool;
    }

    @Override
    public boolean zenith$getIgnoreLight() {
        return this.ignoresLight;
    }

    @Override
    public void zenith$setIgnoreLight(boolean bool) {
        this.ignoresLight = bool;
    }

    @Override
    public boolean zenith$getNoAi() {
        return this.hasNoAI;
    }

    @Override
    public void zenith$setNoAi(boolean bool) {
        this.hasNoAI = bool;
    }

    @Override
    public boolean zenith$getSilent() {
        return this.silent;
    }

    @Override
    public void zenith$setSilent(boolean bool) {
        this.silent = bool;
    }

    @Override
    public boolean zenith$getBaby() {
        return this.baby;
    }

    @Override
    public void zenith$setBaby(boolean bool) {
        this.baby = bool;
    }

    @Override
    public class_1917 zenith$getSpawner() {
        return this.field_12114;
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    private void zenith$loadSpawnData(class_2487 tag, CallbackInfo ci) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        this.ignoresPlayers = tag.method_10577("ignore_players");
        this.ignoresConditions = tag.method_10577("ignore_conditions");
        this.redstoneControl = tag.method_10577("redstone_control");
        this.ignoresLight = tag.method_10577("ignore_light");
        this.hasNoAI = tag.method_10577("no_ai");
        this.silent = tag.method_10577("silent");
        this.baby = tag.method_10577("baby");
    }

    @Inject(method={"saveAdditional"}, at={@At(value="TAIL")})
    private void zenith$saveSpawnData(class_2487 tag, CallbackInfo ci) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        tag.method_10556("ignore_players", this.ignoresPlayers);
        tag.method_10556("ignore_conditions", this.ignoresConditions);
        tag.method_10556("redstone_control", this.redstoneControl);
        tag.method_10556("ignore_light", this.ignoresLight);
        tag.method_10556("no_ai", this.hasNoAI);
        tag.method_10556("silent", this.silent);
        tag.method_10556("baby", this.baby);
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void zenith$overrideSpawnerLogic(class_2338 blockPos, class_2680 blockState, CallbackInfo ci) {
        if (!Apotheosis.enableSpawner) {
            return;
        }
        this.field_12114 = new class_1917(){

            public void method_8274(class_1299<?> type, @Nullable class_1937 level, class_5819 rand, class_2338 pos) {
                ((BaseSpawnerAccessor)((Object)this)).setNextSpawnData(new class_1952());
                super.method_8274(type, level, rand, pos);
                ((BaseSpawnerAccessor)((Object)this)).setSpawnPotentials((class_6005<class_1952>)class_6005.method_38061((Object)((BaseSpawnerAccessor)((Object)this)).getNextSpawnData()));
                if (level != null) {
                    this.delay(level, pos);
                }
            }

            public void method_8273(class_1937 level, class_2338 pos, int id) {
                level.method_8427(pos, class_2246.field_10260, id, 0);
            }

            public void method_8277(class_1937 level, class_2338 pos, class_1952 nextSpawnData) {
                super.method_8277(level, pos, nextSpawnData);
                if (level != null) {
                    class_2680 state = level.method_8320(pos);
                    level.method_8413(pos, state, state, 4);
                }
            }

            private boolean isActivated(class_1937 level, class_2338 pos) {
                boolean hasPlayer = SpawnerBlockEntityMixin.this.ignoresPlayers || ((BaseSpawnerAccessor)((Object)this)).callIsNearPlayer(level, pos);
                return hasPlayer && (!SpawnerBlockEntityMixin.this.redstoneControl || SpawnerBlockEntityMixin.this.field_11863.method_49803(pos));
            }

            private void delay(class_1937 pLevel, class_2338 pPos) {
                if (((BaseSpawnerAccessor)((Object)this)).getMaxSpawnDelay() <= ((BaseSpawnerAccessor)((Object)this)).getMinSpawnDelay()) {
                    ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(((BaseSpawnerAccessor)((Object)this)).getMinSpawnDelay());
                } else {
                    ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(((BaseSpawnerAccessor)((Object)this)).getMinSpawnDelay() + pLevel.field_9229.method_43048(((BaseSpawnerAccessor)((Object)this)).getMaxSpawnDelay() - ((BaseSpawnerAccessor)((Object)this)).getMinSpawnDelay()));
                }
                ((BaseSpawnerAccessor)((Object)this)).getSpawnPotentials().method_34992(pLevel.field_9229).ifPresent(potential -> this.method_8277(pLevel, pPos, (class_1952)potential.method_34983()));
                this.method_8273(pLevel, pPos, 1);
            }

            public void method_31589(@NotNull class_1937 pLevel, @NotNull class_2338 pPos) {
                if (!this.isActivated(pLevel, pPos)) {
                    ((BaseSpawnerAccessor)((Object)this)).setOSpin(((BaseSpawnerAccessor)((Object)this)).getSpin());
                } else {
                    double d0 = (double)pPos.method_10263() + pLevel.field_9229.method_43058();
                    double d1 = (double)pPos.method_10264() + pLevel.field_9229.method_43058();
                    double d2 = (double)pPos.method_10260() + pLevel.field_9229.method_43058();
                    pLevel.method_8406((class_2394)class_2398.field_11251, d0, d1, d2, 0.0, 0.0, 0.0);
                    pLevel.method_8406((class_2394)class_2398.field_11240, d0, d1, d2, 0.0, 0.0, 0.0);
                    if (((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() > 0) {
                        ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() - 1);
                    }
                    ((BaseSpawnerAccessor)((Object)this)).setOSpin(((BaseSpawnerAccessor)((Object)this)).getSpin());
                    ((BaseSpawnerAccessor)((Object)this)).setSpin((((BaseSpawnerAccessor)((Object)this)).getSpin() + (double)(1000.0f / ((float)((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() + 200.0f))) % 360.0);
                }
            }

            public void method_31588(@NotNull class_3218 level, @NotNull class_2338 pPos) {
                if (this.isActivated((class_1937)level, pPos)) {
                    if (((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() == -1) {
                        this.delay((class_1937)level, pPos);
                    }
                    if (((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() > 0) {
                        ((BaseSpawnerAccessor)((Object)this)).setSpawnDelay(((BaseSpawnerAccessor)((Object)this)).getSpawnDelay() - 1);
                    } else {
                        boolean flag = false;
                        class_5819 rand = level.method_8409();
                        class_1952 spawnData = ((BaseSpawnerAccessor)((Object)this)).callGetOrCreateNextSpawnData((class_1937)level, rand, pPos);
                        for (int i = 0; i < ((BaseSpawnerAccessor)((Object)this)).getSpawnCount(); ++i) {
                            int nearby;
                            class_1297 entity;
                            double z;
                            class_2487 tag = spawnData.method_38093();
                            class_1299 entityType = class_1299.method_17684((class_2487)tag).orElse(null);
                            if (entityType == null) {
                                this.delay((class_1937)level, pPos);
                                return;
                            }
                            class_2499 posList = tag.method_10554("Pos", 6);
                            int size = posList.size();
                            double x = size >= 1 ? posList.method_10611(0) : (double)pPos.method_10263() + (rand.method_43058() - rand.method_43058()) * (double)((BaseSpawnerAccessor)((Object)this)).getSpawnRange() + 0.5;
                            double y = size >= 2 ? posList.method_10611(1) : (double)(pPos.method_10264() + rand.method_43048(3) - 1);
                            double d = z = size >= 3 ? posList.method_10611(2) : (double)pPos.method_10260() + (rand.method_43058() - rand.method_43058()) * (double)((BaseSpawnerAccessor)((Object)this)).getSpawnRange() + 0.5;
                            if (!level.method_18026(entityType.method_17683(x, y, z))) continue;
                            class_2338 blockpos = class_2338.method_49637((double)x, (double)y, (double)z);
                            LyingLevel liar = new LyingLevel(level);
                            boolean useLiar = false;
                            if (!SpawnerBlockEntityMixin.this.ignoresConditions) {
                                if (SpawnerBlockEntityMixin.this.ignoresLight) {
                                    boolean pass = false;
                                    for (int light = 0; light < 16; ++light) {
                                        liar.setFakeLightLevel(light);
                                        if (!this.checkSpawnRules(spawnData, entityType, (class_5425)liar, blockpos)) continue;
                                        pass = true;
                                        break;
                                    }
                                    if (!pass) continue;
                                    useLiar = true;
                                } else if (!this.checkSpawnRules(spawnData, entityType, (class_5425)level, blockpos)) continue;
                            }
                            if ((entity = class_1299.method_17842((class_2487)tag, (class_1937)level, freshEntity -> {
                                freshEntity.method_5808(x, y, z, freshEntity.method_36454(), freshEntity.method_36455());
                                return freshEntity;
                            })) == null) {
                                this.delay((class_1937)level, pPos);
                                return;
                            }
                            if (SpawnerBlockEntityMixin.this.hasNoAI) {
                                entity.method_24204().filter(class_1308.class::isInstance).map(class_1308.class::cast).forEach(mob -> {
                                    mob.method_5977(true);
                                    ((SyncedBooleanComponent)ZenithComponents.MOVABLE.get(mob)).setValue(true);
                                });
                            }
                            if (SpawnerBlockEntityMixin.this.baby && entity instanceof class_1308) {
                                class_1308 mob2 = (class_1308)entity;
                                mob2.method_7217(true);
                            }
                            if (SpawnerBlockEntityMixin.this.silent) {
                                entity.method_5803(true);
                            }
                            if ((nearby = level.method_18467(entity.getClass(), new class_238((double)pPos.method_10263(), (double)pPos.method_10264(), (double)pPos.method_10260(), (double)(pPos.method_10263() + 1), (double)(pPos.method_10264() + 1), (double)(pPos.method_10260() + 1)).method_1014((double)((BaseSpawnerAccessor)((Object)this)).getSpawnRange())).size()) >= ((BaseSpawnerAccessor)((Object)this)).getMaxNearbyEntities()) {
                                this.delay((class_1937)level, pPos);
                                return;
                            }
                            entity.method_5808(entity.method_23317(), entity.method_23318(), entity.method_23321(), rand.method_43057() * 360.0f, 0.0f);
                            if (entity instanceof class_1308) {
                                class_1308 mob3 = (class_1308)entity;
                                if (spawnData.method_38097().isEmpty() && !mob3.method_5979((class_1936)(useLiar ? liar : level), class_3730.field_16469) || !mob3.method_5957((class_4538)level)) continue;
                                if (spawnData.method_38093().method_10546() == 1 && spawnData.method_38093().method_10573("id", 8)) {
                                    ((class_1308)entity).method_5943((class_5425)(useLiar ? liar : level), level.method_8404(entity.method_24515()), class_3730.field_16469, (class_1315)null, (class_2487)null);
                                }
                            }
                            if (!level.method_30736(entity)) {
                                this.delay((class_1937)level, pPos);
                                return;
                            }
                            level.method_20290(2004, pPos, 0);
                            if (entity instanceof class_1308) {
                                ((class_1308)entity).method_5990();
                            }
                            flag = true;
                        }
                        if (flag) {
                            this.delay((class_1937)level, pPos);
                        }
                    }
                }
            }

            private boolean checkSpawnRules(class_1952 spawnData, class_1299<?> entityType, class_5425 pServerLevel, class_2338 blockpos) {
                if (spawnData.method_38097().isPresent()) {
                    if (!entityType.method_5891().method_6136() && pServerLevel.method_8407() == class_1267.field_5801) {
                        return false;
                    }
                    class_1952.class_6542 customRules = (class_1952.class_6542)spawnData.method_38097().get();
                    if (SpawnerBlockEntityMixin.this.ignoresLight) {
                        return true;
                    }
                    if (!customRules.comp_66().method_37955((Comparable)Integer.valueOf(pServerLevel.method_8314(class_1944.field_9282, blockpos))) || !customRules.comp_67().method_37955((Comparable)Integer.valueOf(pServerLevel.method_8314(class_1944.field_9284, blockpos)))) {
                        return false;
                    }
                } else if (!class_1317.method_20638(entityType, (class_5425)pServerLevel, (class_3730)class_3730.field_16469, (class_2338)blockpos, (class_5819)pServerLevel.method_8409())) {
                    return false;
                }
                return true;
            }
        };
    }
}

