/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.mixin.adventure;

import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.Map;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1890.class}, priority=1100)
public class EnchantmentHelperMixinAdventure {
    @Inject(at={@At(value="RETURN")}, method={"getDamageProtection(Ljava/lang/Iterable;Lnet/minecraft/world/damagesource/DamageSource;)I"}, cancellable=true)
    private static void zenith_getDamageProtection(Iterable<class_1799> stacks, class_1282 source, CallbackInfoReturnable<Integer> cir) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        int prot = cir.getReturnValueI();
        for (class_1799 s : stacks) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                prot += inst.getDamageProtection(source);
            }
        }
        cir.setReturnValue((Object)prot);
    }

    @Inject(at={@At(value="RETURN")}, method={"getDamageBonus(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/MobType;)F"}, cancellable=true)
    private static void zenith_getDamageBonus(class_1799 stack, class_1310 type, CallbackInfoReturnable<Float> cir) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        float dmg = cir.getReturnValueF();
        Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(stack);
        for (AffixInstance inst : affixes.values()) {
            dmg += inst.getDamageBonus(type);
        }
        cir.setReturnValue((Object)Float.valueOf(dmg));
    }

    @Inject(at={@At(value="TAIL")}, method={"doPostDamageEffects(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/Entity;)V"})
    private static void zenith_doPostDamageEffects(class_1309 user, class_1297 target, CallbackInfo ci) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        if (user == null) {
            return;
        }
        for (class_1799 s : user.method_5743()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                int old = target.field_6008;
                target.field_6008 = 0;
                inst.doPostAttack(user, target);
                target.field_6008 = old;
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"doPostHurtEffects(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/Entity;)V"})
    private static void zenith_doPostHurtEffects(class_1309 user, class_1297 attacker, CallbackInfo ci) {
        if (!Apotheosis.enableAdventure) {
            return;
        }
        if (user == null) {
            return;
        }
        for (class_1799 s : user.method_5743()) {
            Map<DynamicHolder<? extends Affix>, AffixInstance> affixes = AffixHelper.getAffixes(s);
            for (AffixInstance inst : affixes.values()) {
                inst.doPostHurt(user, attacker);
            }
        }
    }
}

