/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.table;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.shadowsoffire.apotheosis.ench.Ench;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import io.github.fabricators_of_create.porting_lib.util.CraftingHelper;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5455;

public class EnchantingRecipe
implements class_1860<class_1263> {
    public static final Serializer SERIALIZER = new Serializer();
    public static final EnchantingStatRegistry.Stats NO_MAX = new EnchantingStatRegistry.Stats(-1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1);
    protected final class_2960 id;
    protected final class_1799 output;
    protected final class_1856 input;
    protected final EnchantingStatRegistry.Stats requirements;
    protected final EnchantingStatRegistry.Stats maxRequirements;

    public EnchantingRecipe(class_2960 id, class_1799 output, class_1856 input, EnchantingStatRegistry.Stats requirements, EnchantingStatRegistry.Stats maxRequirements) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.requirements = requirements;
        this.maxRequirements = maxRequirements;
    }

    public boolean matches(class_1799 input, float eterna, float quanta, float arcana) {
        if (this.maxRequirements.eterna() > -1.0f && eterna > this.maxRequirements.eterna() || this.maxRequirements.quanta() > -1.0f && quanta > this.maxRequirements.quanta() || this.maxRequirements.arcana() > -1.0f && arcana > this.maxRequirements.arcana()) {
            return false;
        }
        return this.input.method_8093(input) && eterna >= this.requirements.eterna() && quanta >= this.requirements.quanta() && arcana >= this.requirements.arcana();
    }

    public EnchantingStatRegistry.Stats getRequirements() {
        return this.requirements;
    }

    public EnchantingStatRegistry.Stats getMaxRequirements() {
        return this.maxRequirements;
    }

    public class_1856 getInput() {
        return this.input;
    }

    public class_1799 getOutput() {
        return this.output;
    }

    @Deprecated
    public boolean method_8115(class_1263 pContainer, class_1937 pLevel) {
        return false;
    }

    @Deprecated
    public class_1799 method_8116(class_1263 pContainer, class_5455 regs) {
        return class_1799.field_8037;
    }

    @Deprecated
    public boolean method_8113(int pWidth, int pHeight) {
        return false;
    }

    @Deprecated
    public class_1799 method_8110(class_5455 regs) {
        return this.output;
    }

    public class_1799 assemble(class_1799 input, float eterna, float quanta, float arcana) {
        return this.output.method_7972();
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return Ench.RecipeTypes.INFUSION;
    }

    protected static org.apache.commons.lang3.tuple.Pair<EnchantingStatRegistry.Stats, EnchantingStatRegistry.Stats> readStats(class_2960 id, JsonObject obj) {
        EnchantingStatRegistry.Stats maxStats;
        EnchantingStatRegistry.Stats stats = (EnchantingStatRegistry.Stats)((Pair)EnchantingStatRegistry.Stats.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("requirements")).get().left().get()).getFirst();
        EnchantingStatRegistry.Stats stats2 = maxStats = obj.has("max_requirements") ? (EnchantingStatRegistry.Stats)((Pair)EnchantingStatRegistry.Stats.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("max_requirements")).get().left().get()).getFirst() : NO_MAX;
        if (maxStats.eterna() != -1.0f && stats.eterna() > maxStats.eterna()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max eterna bounds (min > max).");
        }
        if (maxStats.quanta() != -1.0f && stats.quanta() > maxStats.quanta()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max quanta bounds (min > max).");
        }
        if (maxStats.arcana() != -1.0f && stats.arcana() > maxStats.arcana()) {
            throw new JsonParseException("An enchanting recipe (" + id + ") has invalid min/max arcana bounds (min > max).");
        }
        return org.apache.commons.lang3.tuple.Pair.of((Object)stats, (Object)maxStats);
    }

    @Nullable
    public static EnchantingRecipe findMatch(class_1937 level, class_1799 input, float eterna, float quanta, float arcana) {
        ArrayList recipes = new ArrayList(level.method_8433().method_30027(Ench.RecipeTypes.INFUSION));
        recipes.sort((r1, r2) -> -Float.compare(r1.requirements.eterna(), r2.requirements.eterna()));
        for (EnchantingRecipe r : recipes) {
            if (!r.matches(input, eterna, quanta, arcana)) continue;
            return r;
        }
        return null;
    }

    public static EnchantingRecipe findItemMatch(class_1937 level, class_1799 toEnchant) {
        return level.method_8433().method_30027(Ench.RecipeTypes.INFUSION).stream().filter(r -> r.getInput().method_8093(toEnchant)).findFirst().orElse(null);
    }

    public static class Serializer
    implements class_1865<EnchantingRecipe> {
        protected static final Gson GSON = new GsonBuilder().create();

        public EnchantingRecipe fromJson(class_2960 id, JsonObject obj) {
            class_1799 output = CraftingHelper.getItemStack((JsonObject)obj.get("result").getAsJsonObject(), (boolean)true, (boolean)true);
            class_1856 input = class_1856.method_52177((JsonElement)obj.get("input"));
            org.apache.commons.lang3.tuple.Pair<EnchantingStatRegistry.Stats, EnchantingStatRegistry.Stats> requirements = EnchantingRecipe.readStats(id, obj);
            return new EnchantingRecipe(id, output, input, (EnchantingStatRegistry.Stats)requirements.getLeft(), (EnchantingStatRegistry.Stats)requirements.getRight());
        }

        public EnchantingRecipe fromNetwork(class_2960 id, class_2540 buf) {
            class_1799 output = buf.method_10819();
            class_1856 input = class_1856.method_8086((class_2540)buf);
            EnchantingStatRegistry.Stats stats = EnchantingStatRegistry.Stats.read(buf);
            EnchantingStatRegistry.Stats maxStats = buf.readBoolean() ? EnchantingStatRegistry.Stats.read(buf) : NO_MAX;
            return new EnchantingRecipe(id, output, input, stats, maxStats);
        }

        public void toNetwork(class_2540 buf, EnchantingRecipe recipe) {
            buf.method_10793(recipe.output);
            recipe.input.method_8088(buf);
            recipe.requirements.write(buf);
            buf.writeBoolean(recipe.maxRequirements != NO_MAX);
            if (recipe.maxRequirements != NO_MAX) {
                recipe.maxRequirements.write(buf);
            }
        }
    }
}

