/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench.library;

import com.google.common.base.Strings;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryContainer;
import dev.shadowsoffire.apotheosis.ench.library.EnchLibraryTile;
import dev.shadowsoffire.attributeslib.AttributesLib;
import dev.shadowsoffire.placebo.packets.ButtonClickMessage;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nullable;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_7923;
import net.spell_power.api.enchantment.EnchantmentRestriction;

public class EnchLibraryScreen
extends class_465<EnchLibraryContainer> {
    public static final class_2960 TEXTURES = new class_2960("zenith", "textures/gui/library.png");
    protected float scrollOffs;
    protected boolean scrolling;
    protected int startIndex;
    protected List<LibrarySlot> data = new ArrayList<LibrarySlot>();
    protected class_342 filter = null;
    private static DecimalFormat f = new DecimalFormat("##.#");

    public EnchLibraryScreen(EnchLibraryContainer container, class_1661 inv, class_2561 title) {
        super((class_1703)container, inv, title);
        this.field_2792 = 176;
        this.field_22789 = 176;
        this.field_2779 = 241;
        this.field_22790 = 241;
        this.field_25269 = 7;
        this.field_25267 = 7;
        this.field_25268 = 4;
        this.field_25270 = 149;
        this.containerChanged();
        container.setNotifier(this::containerChanged);
    }

    protected void method_25426() {
        super.method_25426();
        Objects.requireNonNull(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        this.filter = (class_342)this.method_37063((class_364)new class_342(this.field_22793, this.field_2776 + 91, this.field_2800 + 20 + 9 + 2, 78, 9 + 4, this.filter, (class_2561)class_2561.method_43470((String)"")));
        this.filter.method_1863(t -> this.containerChanged());
    }

    public boolean method_25404(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 && this.method_25399() == this.filter) {
            this.method_25395(null);
            this.filter.method_25365(false);
            return true;
        }
        if (this.field_22787.field_1690.field_1822.method_1417(pKeyCode, pScanCode) && this.method_25399() == this.filter) {
            return true;
        }
        return super.method_25404(pKeyCode, pScanCode, pModifiers);
    }

    public void method_25394(class_332 gfx, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gfx);
        super.method_25394(gfx, mouseX, mouseY, partialTicks);
        this.method_2380(gfx, mouseX, mouseY);
    }

    protected void method_2380(class_332 gfx, int mouseX, int mouseY) {
        super.method_2380(gfx, mouseX, mouseY);
        LibrarySlot libSlot = this.getHoveredSlot(mouseX, mouseY);
        if (libSlot != null) {
            int targetLevel;
            ArrayList<class_5250> list = new ArrayList<class_5250>();
            class_5250 name = class_2561.method_43471((String)libSlot.ench.method_8184()).method_10862(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xFFFF80)).method_30938(Boolean.valueOf(true)));
            if (AttributesLib.getTooltipFlag().method_8035()) {
                name = name.method_10852((class_2561)class_2561.method_43470((String)(" [" + class_7923.field_41176.method_10221((Object)libSlot.ench) + "]")).method_27696(class_2583.field_24360.method_10977(class_124.field_1080).method_30938(Boolean.valueOf(false))));
            }
            list.add(name);
            if (class_1074.method_4663((String)(libSlot.ench.method_8184() + ".desc")) || AttributesLib.getTooltipFlag().method_8035()) {
                class_5250 txt = class_2561.method_43471((String)(libSlot.ench.method_8184() + ".desc")).method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true)));
                list.addAll(this.field_22793.method_27527().method_27495((class_5348)txt, this.field_2776 - 16, txt.method_10866()));
                list.add(class_2561.method_43470((String)""));
            }
            list.add(class_2561.method_43469((String)"tooltip.enchlib.max_lvl", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + libSlot.maxLvl))}).method_27692(class_124.field_1080));
            list.add(class_2561.method_43469((String)"tooltip.enchlib.points", (Object[])new Object[]{EnchLibraryScreen.format(libSlot.points), EnchLibraryScreen.format(((EnchLibraryContainer)this.field_2797).getPointCap())}).method_27692(class_124.field_1080));
            list.add(class_2561.method_43470((String)""));
            class_1799 outSlot = ((EnchLibraryContainer)this.field_2797).ioInv.method_5438(1);
            int current = class_1890.method_8222((class_1799)outSlot).getOrDefault(libSlot.ench, 0);
            boolean shift = class_437.method_25442();
            int n = targetLevel = shift ? Math.min(libSlot.maxLvl, 1 + (int)(Math.log(libSlot.points + EnchLibraryTile.levelToPoints(current)) / Math.log(2.0))) : current + 1;
            if (targetLevel == current) {
                ++targetLevel;
            }
            int cost = EnchLibraryTile.levelToPoints(targetLevel) - EnchLibraryTile.levelToPoints(current);
            if (targetLevel > libSlot.maxLvl) {
                list.add(class_2561.method_43471((String)"tooltip.enchlib.unavailable").method_10862(class_2583.field_24360.method_10977(class_124.field_1061)));
            } else {
                list.add(class_2561.method_43469((String)"tooltip.enchlib.extracting", (Object[])new Object[]{class_2561.method_43471((String)("enchantment.level." + targetLevel))}).method_27692(class_124.field_1078));
                list.add(class_2561.method_43469((String)"tooltip.enchlib.cost", (Object[])new Object[]{cost}).method_27692(cost > libSlot.points ? class_124.field_1061 : class_124.field_1065));
            }
            gfx.method_51434(this.field_22793, list.stream().map(formatted -> class_2561.method_43470((String)formatted.getString())).toList(), this.field_2776 - 16 - list.stream().map(arg_0 -> ((class_327)this.field_22793).method_27525(arg_0)).max(Integer::compare).get(), mouseY);
        }
    }

    protected void method_2389(class_332 gfx, float partial, int mouseX, int mouseY) {
        int left = this.field_2776;
        int top = this.field_2800;
        gfx.method_25302(TEXTURES, left, top, 0, 0, this.field_2792, this.field_2779);
        int scrollbarPos = (int)(118.0f * this.scrollOffs);
        gfx.method_25302(TEXTURES, left + 75, top + 14 + scrollbarPos, 244, this.isScrollBarActive() ? 0 : 15, 12, 15);
        for (int idx = this.startIndex; idx < this.startIndex + 7 && idx < this.data.size(); ++idx) {
            this.renderEntry(gfx, this.data.get(idx), this.field_2776 + 8, this.field_2800 + 14 + 19 * (idx - this.startIndex), mouseX, mouseY);
        }
        gfx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"tooltip.enchlib.nfilt"), this.field_2776 + 91, this.field_2800 + 20, 0x404040, false);
        gfx.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"tooltip.enchlib.ifilt"), this.field_2776 + 91, this.field_2800 + 50, 0x404040, false);
    }

    private void renderEntry(class_332 gfx, LibrarySlot data, int x, int y, int mouseX, int mouseY) {
        boolean hover = this.method_2378(x - this.field_2776, y - this.field_2800, 64, 17, mouseX, mouseY);
        gfx.method_25302(TEXTURES, x, y, 178, hover ? 19 : 0, 64, 19);
        int progress = (int)Math.round(62.0 * Math.sqrt(data.points) / (double)((float)Math.sqrt(((EnchLibraryContainer)this.field_2797).getPointCap())));
        gfx.method_25302(TEXTURES, x + 1, y + 12, 179, 38, progress, 5);
        class_4587 stack = gfx.method_51448();
        stack.method_22903();
        class_5250 txt = class_2561.method_43471((String)data.ench.method_8184());
        float scale = 1.0f;
        if (this.field_22793.method_27525((class_5348)txt) > 60) {
            scale = 60.0f / (float)this.field_22793.method_27525((class_5348)txt);
        }
        stack.method_22905(scale, scale, 1.0f);
        gfx.method_51439(this.field_22793, (class_2561)txt, (int)((float)(x + 2) / scale), (int)((float)(y + 2) / scale), 0xFFFF80, false);
        stack.method_22909();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int left = this.field_2776 + 52;
        int top = this.field_2800 + 14;
        LibrarySlot libSlot = this.getHoveredSlot((int)mouseX, (int)mouseY);
        if (libSlot != null) {
            int id = class_7923.field_41176.method_10206((Object)libSlot.ench);
            if (class_437.method_25442()) {
                id |= Integer.MIN_VALUE;
            }
            ((EnchLibraryContainer)this.field_2797).onButtonClick(id);
            ButtonClickMessage.sendToServer((int)id);
            this.field_22787.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17711, (float)1.0f));
        }
        left = this.field_2776 + 75;
        top = this.field_2800 + 9;
        if (mouseX >= (double)left && mouseX < (double)(left + 12) && mouseY >= (double)top && mouseY < (double)(top + 131)) {
            this.scrolling = true;
        }
        this.method_25395(null);
        this.filter.method_25365(false);
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.field_2800 + 14;
            int j = i + 131;
            this.scrollOffs = ((float)pMouseY - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5);
            return true;
        }
        return super.method_25403(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            this.scrollOffs = (float)((double)this.scrollOffs - pDelta / (double)i);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5);
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.data.size() > 7;
    }

    protected int getOffscreenRows() {
        return this.data.size() - 7;
    }

    private void containerChanged() {
        this.data.clear();
        List<Object2IntMap.Entry<class_1887>> entries = this.filter(((EnchLibraryContainer)this.field_2797).getPointsForDisplay());
        for (Object2IntMap.Entry<class_1887> e : entries) {
            this.data.add(new LibrarySlot((class_1887)e.getKey(), e.getIntValue(), ((EnchLibraryContainer)this.field_2797).getMaxLevel((class_1887)e.getKey())));
        }
        if (!this.isScrollBarActive()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        Collections.sort(this.data, (a, b) -> class_1074.method_4662((String)a.ench.method_8184(), (Object[])new Object[0]).compareTo(class_1074.method_4662((String)b.ench.method_8184(), (Object[])new Object[0])));
    }

    private List<Object2IntMap.Entry<class_1887>> filter(List<Object2IntMap.Entry<class_1887>> list) {
        return list.stream().filter(this::isAllowedByItem).filter(this::isAllowedBySearch).toList();
    }

    private boolean isAllowedByItem(Object2IntMap.Entry<class_1887> e) {
        class_1799 stack = ((EnchLibraryContainer)this.field_2797).ioInv.method_5438(2);
        if (!stack.method_7960() && FabricLoader.getInstance().isModLoaded("spell_power")) {
            if (EnchantmentRestriction.isPermitted((class_1887)((class_1887)e.getKey()), (class_1799)stack)) {
                return true;
            }
            if (EnchantmentRestriction.isProhibited((class_1887)((class_1887)e.getKey()), (class_1799)stack)) {
                return false;
            }
        }
        return stack.method_7960() || ((class_1887)e.getKey()).method_8192(stack);
    }

    private boolean isAllowedBySearch(Object2IntMap.Entry<class_1887> e) {
        String name = class_1074.method_4662((String)((class_1887)e.getKey()).method_8184(), (Object[])new Object[0]).toLowerCase(Locale.ROOT);
        String search = this.filter == null ? "" : this.filter.method_1882().trim().toLowerCase(Locale.ROOT);
        return Strings.isNullOrEmpty((String)search) || class_124.method_539((String)name).contains(search);
    }

    @Nullable
    public LibrarySlot getHoveredSlot(int mouseX, int mouseY) {
        for (int i = 0; i < 7; ++i) {
            if (this.startIndex + i >= this.data.size() || !this.method_2378(8, 14 + 19 * i, 64, 17, mouseX, mouseY)) continue;
            return this.data.get(this.startIndex + i);
        }
        return null;
    }

    public static String format(int n) {
        int log = (int)StrictMath.log10(n);
        if (log <= 4) {
            return String.valueOf(n);
        }
        if (log == 5) {
            return f.format((double)n / 1000.0) + "K";
        }
        if (log <= 8) {
            return f.format((double)n / 1000000.0) + "M";
        }
        return f.format((double)n / 1.0E9) + "B";
    }

    private record LibrarySlot(class_1887 ench, int points, int maxLvl) {
    }
}

