/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.ench;

import dev.s_com.udojava.evalex.Expression;
import dev.shadowsoffire.apotheosis.ench.EnchModule;
import dev.shadowsoffire.apotheosis.ench.table.EnchantingStatRegistry;
import dev.shadowsoffire.apotheosis.mixin.accessors.EnchantmentAccessor;
import dev.shadowsoffire.placebo.config.Configuration;
import java.math.BigDecimal;
import net.minecraft.class_1887;
import net.minecraft.class_3532;
import net.minecraft.class_7923;

public class EnchantmentInfo {
    protected final class_1887 ench;
    protected final int maxLevel;
    protected final int maxLootLevel;
    protected final boolean treasure;
    protected final boolean discoverable;
    protected final boolean lootable;
    protected final boolean tradeable;
    protected final PowerFunc maxPower;
    protected final PowerFunc minPower;

    public EnchantmentInfo(class_1887 ench, int maxLevel, int maxLootLevel, PowerFunc max, PowerFunc min, boolean treasure, boolean discoverable, boolean lootable, boolean tradeable, boolean scrappable) {
        this.ench = ench;
        this.maxLevel = maxLevel;
        this.maxLootLevel = maxLootLevel;
        this.maxPower = max;
        this.minPower = min;
        this.treasure = treasure;
        this.discoverable = discoverable;
        this.lootable = lootable;
        this.tradeable = tradeable;
    }

    @Deprecated
    public EnchantmentInfo(class_1887 ench) {
        this(ench, ench.method_8183(), ench.method_8183(), EnchantmentInfo.defaultMax(ench), EnchantmentInfo.defaultMin(ench), ench.method_8193(), ench.method_25950(), ench.method_25950(), ench.method_25949(), true);
    }

    public int getMaxLevel() {
        return Math.min(EnchModule.ENCH_HARD_CAPS.getOrDefault((Object)this.ench, 127), this.maxLevel);
    }

    public int getMaxLootLevel() {
        return Math.min(EnchModule.ENCH_HARD_CAPS.getOrDefault((Object)this.ench, 127), this.maxLootLevel);
    }

    public int getMinPower(int level) {
        return this.minPower.getPower(level);
    }

    public int getMaxPower(int level) {
        return this.maxPower.getPower(level);
    }

    public boolean isDiscoverable() {
        return this.discoverable;
    }

    public boolean isTreasure() {
        return this.treasure;
    }

    public boolean isLootable() {
        return this.lootable;
    }

    public boolean isTradeable() {
        return this.tradeable;
    }

    public boolean isScrappable() {
        return this.tradeable;
    }

    public static EnchantmentInfo load(class_1887 ench, Configuration cfg) {
        float maxEnchantmentLevel = EnchModule.getDefaultMax(ench);
        float absoluteMaxPower = EnchantingStatRegistry.getAbsoluteMaxEterna() * 2.0f;
        int powerScalar = class_3532.method_15375((float)(absoluteMaxPower / maxEnchantmentLevel));
        String defaultMaxF = String.format("%d * x", powerScalar);
        String defaultMinF = "1";
        String category = class_7923.field_41176.method_10221((Object)ench).toString();
        int max = cfg.getInt("Max Level", category, EnchModule.getDefaultMax(ench), 1, 127, "The max level of this enchantment - originally " + ench.method_8183() + ".");
        int maxLoot = cfg.getInt("Max Loot Level", category, ench.method_8183(), 1, 127, "The max level of this enchantment available from loot sources.");
        String maxF = cfg.getString("Max Power Function", category, defaultMaxF, "A function to determine the max enchanting power.  The variable \"x\" is level.  See: https://github.com/uklimaschewski/EvalEx#usage-examples");
        String minF = cfg.getString("Min Power Function", category, defaultMinF, "A function to determine the min enchanting power.");
        ExpressionPowerFunc maxPower = maxF.isEmpty() ? new ExpressionPowerFunc(defaultMaxF) : new ExpressionPowerFunc(maxF);
        ExpressionPowerFunc minPower = minF.isEmpty() ? new ExpressionPowerFunc(defaultMinF) : new ExpressionPowerFunc(minF);
        boolean treasure = cfg.getBoolean("Treasure", category, ench.method_8193(), "If this enchantment is only available by loot sources.");
        boolean discoverable = cfg.getBoolean("Discoverable", category, ench.method_25950(), "If this enchantment is obtainable via enchanting and enchanted loot items.");
        boolean lootable = cfg.getBoolean("Lootable", category, ench.method_25950(), "If enchanted books of this enchantment are available via loot sources.");
        boolean tradeable = cfg.getBoolean("Tradeable", category, ench.method_25949(), "If enchanted books of this enchantment are available via villager trades.");
        boolean scrappable = cfg.getBoolean("Scrappable", category, ench.method_25949(), "If enchanted books of this enchantment are available to be scrapped via the tome of scrapping.");
        EnchantmentInfo info = new EnchantmentInfo(ench, max, maxLoot, maxPower, minPower, treasure, discoverable, lootable, tradeable, scrappable);
        String rarity = cfg.getString("Rarity", category, ench.method_8186().name(), "The rarity of this enchantment.  Valid values are COMMON, UNCOMMON, RARE, and VERY_RARE.");
        try {
            class_1887.class_1888 r = class_1887.class_1888.valueOf((String)rarity);
            ((EnchantmentAccessor)ench).setRarity(r);
        }
        catch (Exception ex) {
            EnchModule.LOGGER.error("Failed to parse rarity for {}, as {} is not a valid rarity string.", (Object)category, (Object)rarity);
        }
        return info;
    }

    public static PowerFunc defaultMax(class_1887 ench) {
        return level -> (int)(EnchantingStatRegistry.getAbsoluteMaxEterna() * 4.0f);
    }

    public static PowerFunc defaultMin(class_1887 ench) {
        return level -> {
            if (level > ench.method_8183() && level > 1) {
                int diff = ench.method_8182(ench.method_8183()) - ench.method_8182(ench.method_8183() - 1);
                if (diff == 0) {
                    diff = 15;
                }
                return ench.method_8182(level) + diff * (int)Math.pow(level - ench.method_8183(), 1.6);
            }
            return ench.method_8182(level);
        };
    }

    public static interface PowerFunc {
        public int getPower(int var1);
    }

    public static class ExpressionPowerFunc
    implements PowerFunc {
        Expression ex;

        public ExpressionPowerFunc(String func) {
            this.ex = new Expression(func);
        }

        @Override
        public int getPower(int level) {
            return this.ex.setVariable("x", new BigDecimal(level)).eval().intValue();
        }
    }
}

