/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.SocketHelper;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import org.apache.commons.lang3.mutable.MutableInt;

public class LootController {
    static Random jRand = new Random();

    public static class_1799 createLootItem(class_1799 stack, LootRarity rarity, class_5819 rand) {
        LootCategory cat = LootCategory.forItem(stack);
        if (cat.isNone()) {
            return stack;
        }
        return LootController.createLootItem(stack, cat, rarity, rand);
    }

    public static class_1799 createLootItem(class_1799 stack, LootCategory cat, LootRarity rarity, class_5819 rand) {
        LinkedHashSet<DynamicHolder<Affix>> selected = new LinkedHashSet<DynamicHolder<Affix>>();
        MutableInt sockets = new MutableInt(0);
        float durability = 0.0f;
        for (LootRarity.LootRule rule : rarity.getRules()) {
            if (rule.type() == AffixType.DURABILITY) {
                durability = rule.chance();
                continue;
            }
            rule.execute(stack, rarity, selected, sockets, rand);
        }
        HashMap<DynamicHolder<? extends Affix>, AffixInstance> loaded = new HashMap<DynamicHolder<? extends Affix>, AffixInstance>();
        ArrayList<AffixInstance> nameList = new ArrayList<AffixInstance>(selected.size());
        for (DynamicHolder dynamicHolder : selected) {
            AffixInstance inst = new AffixInstance((DynamicHolder<? extends Affix>)dynamicHolder, stack, (DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(rarity), rand.method_43057());
            loaded.put(dynamicHolder, inst);
            nameList.add(inst);
        }
        if (nameList.size() == 0) {
            throw new RuntimeException(String.format("Failed to locate any affixes for %s{%s} with category %s and rarity %s.", stack.method_7909(), stack.method_7969(), cat, rarity));
        }
        if (sockets.intValue() > 0) {
            SocketHelper.setSockets(stack, sockets.intValue());
        }
        if (durability > 0.0f) {
            loaded.put(Adventure.Affixes.DURABLE, new AffixInstance(Adventure.Affixes.DURABLE, stack, (DynamicHolder<LootRarity>)RarityRegistry.INSTANCE.holder(rarity), durability + AffixHelper.step(-0.07f, 14, 0.01f).get(rand.method_43057())));
        }
        jRand.setSeed(rand.method_43055());
        Collections.shuffle(nameList, jRand);
        String key = nameList.size() > 1 ? "misc.zenith.affix_name.three" : "misc.zenith.affix_name.two";
        class_5250 class_52502 = class_2561.method_43469((String)key, (Object[])new Object[]{((AffixInstance)nameList.get(0)).getName(true), "", nameList.size() > 1 ? ((AffixInstance)nameList.get(1)).getName(false) : ""}).method_27696(class_2583.field_24360.method_27703(rarity.getColor()));
        AffixHelper.setRarity(stack, rarity);
        AffixHelper.setAffixes(stack, loaded);
        AffixHelper.setName(stack, (class_2561)class_52502);
        return stack;
    }

    public static class_1799 createRandomLootItem(class_5819 rand, @Nullable LootRarity rarity, class_1657 player, class_5425 level) {
        AffixLootEntry entry = (AffixLootEntry)AffixLootRegistry.INSTANCE.getRandomItem(rand, player.method_7292(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((class_1937)level.method_8410()), GameStagesCompat.IStaged.matches(player)});
        if (entry == null) {
            return class_1799.field_8037;
        }
        if (rarity == null) {
            rarity = LootRarity.random(rand, player.method_7292(), entry);
        }
        return LootController.createLootItem(entry.getStack(), entry.getType(), rarity, rand);
    }
}

