/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemRegistry;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_117;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_85;

public class GemLootPoolEntry
extends class_85 {
    public static final Serializer SERIALIZER = new Serializer();
    public static final class_5338 TYPE = new class_5338((class_5335)SERIALIZER);
    private final List<DynamicHolder<Gem>> gems;

    public GemLootPoolEntry(List<class_2960> gems, int weight, int quality, class_5341[] conditions, class_117[] functions) {
        super(weight, quality, conditions, functions);
        this.gems = gems.stream().map(arg_0 -> ((GemRegistry)GemRegistry.INSTANCE).holder(arg_0)).toList();
    }

    protected void method_433(Consumer<class_1799> list, class_47 ctx) {
        Gem gem;
        if (!this.gems.isEmpty()) {
            List<class_6008.class_6010> resolved = this.gems.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(ctx.method_302())).toList();
            gem = (Gem)((class_6008.class_6010)class_6011.method_34986((class_5819)ctx.method_294(), resolved).get()).method_34983();
        } else {
            class_1657 player = GemLootPoolEntry.findPlayer(ctx);
            if (player == null) {
                return;
            }
            gem = (Gem)GemRegistry.INSTANCE.getRandomItem(ctx.method_294(), ctx.method_302(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((class_1937)ctx.method_299()), GameStagesCompat.IStaged.matches(player)});
        }
        RarityClamp clamp = AdventureConfig.GEM_DIM_RARITIES.get(ctx.method_299().method_27983().method_29177());
        class_1799 stack = GemRegistry.createGemStack(gem, gem.clamp(LootRarity.random(ctx.method_294(), ctx.method_302(), clamp)));
        list.accept(stack);
    }

    public class_5338 method_29318() {
        return TYPE;
    }

    private Gem unwrap(DynamicHolder<Gem> holder) {
        if (!holder.isBound()) {
            AdventureModule.LOGGER.error("A GemLootPoolEntry failed to resolve the Gem {}!", (Object)holder.getId());
            return null;
        }
        return (Gem)holder.get();
    }

    @Nullable
    public static class_1657 findPlayer(class_47 ctx) {
        Object object = ctx.method_296(class_181.field_1226);
        if (object instanceof class_1657) {
            class_1657 p = (class_1657)object;
            return p;
        }
        object = ctx.method_296(class_181.field_1227);
        if (object instanceof class_1657) {
            class_1657 p = (class_1657)object;
            return p;
        }
        object = ctx.method_296(class_181.field_1230);
        if (object instanceof class_1657) {
            class_1657 p = (class_1657)object;
            return p;
        }
        if (ctx.method_296(class_181.field_1233) != null) {
            return (class_1657)ctx.method_296(class_181.field_1233);
        }
        return null;
    }

    public static class Serializer
    extends class_85.class_90<GemLootPoolEntry> {
        protected GemLootPoolEntry deserialize(JsonObject jsonObject, JsonDeserializationContext context, int weight, int quality, class_5341[] lootConditions, class_117[] lootFunctions) {
            List gems = (List)context.deserialize((JsonElement)class_3518.method_15292((JsonObject)jsonObject, (String)"gems", (JsonArray)new JsonArray()), new TypeToken<List<String>>(){}.getType());
            return new GemLootPoolEntry(gems.stream().map(class_2960::new).toList(), weight, quality, lootConditions, lootFunctions);
        }

        public void serializeCustom(JsonObject object, GemLootPoolEntry e, JsonSerializationContext ctx) {
            object.add("gems", ctx.serialize(e.gems));
            super.method_442(object, (class_85)e, ctx);
        }
    }
}

