/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.reflect.TypeToken;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.AffixLootRegistry;
import dev.shadowsoffire.apotheosis.adventure.loot.GemLootPoolEntry;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityClamp;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_117;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5338;
import net.minecraft.class_5341;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6008;
import net.minecraft.class_6011;
import net.minecraft.class_85;

public class AffixLootPoolEntry
extends class_85 {
    public static final Serializer SERIALIZER = new Serializer();
    public static final class_5338 TYPE = new class_5338((class_5335)SERIALIZER);
    @Nullable
    private final RarityClamp.Simple rarityLimit;
    private final List<DynamicHolder<AffixLootEntry>> entries;

    public AffixLootPoolEntry(@Nullable RarityClamp.Simple rarityLimit, List<class_2960> entries, int weight, int quality, class_5341[] conditions, class_117[] functions) {
        super(weight, quality, conditions, functions);
        this.rarityLimit = rarityLimit;
        this.entries = entries.stream().map(arg_0 -> ((AffixLootRegistry)AffixLootRegistry.INSTANCE).holder(arg_0)).toList();
    }

    protected void method_433(Consumer<class_1799> list, class_47 ctx) {
        class_1799 stack;
        if (this.entries.isEmpty()) {
            class_1657 player = GemLootPoolEntry.findPlayer(ctx);
            if (player == null) {
                return;
            }
            LootRarity selectedRarity = LootRarity.random(ctx.method_294(), ctx.method_302(), this.rarityLimit);
            stack = LootController.createRandomLootItem(ctx.method_294(), selectedRarity, player, (class_5425)ctx.method_299());
        } else {
            List<class_6008.class_6010> resolved = this.entries.stream().map(this::unwrap).filter(Objects::nonNull).map(e -> e.wrap(ctx.method_302())).toList();
            AffixLootEntry entry = (AffixLootEntry)((class_6008.class_6010)class_6011.method_34986((class_5819)ctx.method_294(), resolved).get()).method_34983();
            LootRarity selectedRarity = LootRarity.random(ctx.method_294(), ctx.method_302(), this.rarityLimit == null ? entry : this.rarityLimit);
            stack = LootController.createLootItem(entry.getStack().method_7972(), selectedRarity, ctx.method_294());
        }
        if (!stack.method_7960()) {
            list.accept(stack);
        }
    }

    public class_5338 method_29318() {
        return TYPE;
    }

    private AffixLootEntry unwrap(DynamicHolder<AffixLootEntry> holder) {
        if (!holder.isBound()) {
            AdventureModule.LOGGER.error("An AffixLootPoolEntry failed to resolve the Affix Loot Entry {}!", (Object)holder.getId());
            return null;
        }
        return (AffixLootEntry)holder.get();
    }

    public static class Serializer
    extends class_85.class_90<AffixLootPoolEntry> {
        protected AffixLootPoolEntry deserialize(JsonObject obj, JsonDeserializationContext context, int weight, int quality, class_5341[] lootConditions, class_117[] lootFunctions) {
            RarityClamp.Simple rarity;
            if (obj.has("min_rarity") || obj.has("max_rarity")) {
                DynamicHolder<LootRarity> minRarity = RarityRegistry.byLegacyId(class_3518.method_15265((JsonObject)obj, (String)"min_rarity"));
                DynamicHolder<LootRarity> maxRarity = RarityRegistry.byLegacyId(class_3518.method_15265((JsonObject)obj, (String)"max_rarity"));
                rarity = new RarityClamp.Simple(minRarity, maxRarity);
            } else {
                rarity = null;
            }
            List entries = (List)context.deserialize((JsonElement)class_3518.method_15292((JsonObject)obj, (String)"entries", (JsonArray)new JsonArray()), new TypeToken<List<String>>(){}.getType());
            return new AffixLootPoolEntry(rarity, entries.stream().map(class_2960::new).toList(), weight, quality, lootConditions, lootFunctions);
        }

        public void serializeCustom(JsonObject object, AffixLootPoolEntry e, JsonSerializationContext ctx) {
            if (e.rarityLimit != null) {
                object.addProperty("min_rarity", e.rarityLimit.min().getId().toString());
                object.addProperty("max_rarity", e.rarityLimit.max().getId().toString());
            }
            object.add("entries", ctx.serialize(e.entries));
            super.method_442(object, (class_85)e, ctx);
        }
    }
}

