/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.shadowsoffire.apotheosis.adventure.boss.ApothBoss;
import dev.shadowsoffire.apotheosis.adventure.boss.BossRegistry;
import dev.shadowsoffire.apotheosis.adventure.commands.LootifyCommand;
import dev.shadowsoffire.apotheosis.adventure.compat.GameStagesCompat;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import dev.shadowsoffire.placebo.reload.WeightedDynamicRegistry;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5425;

public class BossCommand {
    public static final SuggestionProvider<class_2168> SUGGEST_BOSS = (ctx, builder) -> class_2172.method_9264(BossRegistry.INSTANCE.getKeys().stream().map(class_2960::toString), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<class_2168> root) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"spawn_boss").requires(c -> c.method_9259(2));
        builder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"boss", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_BOSS).then(class_2170.method_9244((String)"rarity", (ArgumentType)class_2232.method_9441()).suggests(LootifyCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2277.method_9736((CommandContext)c, (String)"pos"), class_2232.method_9443((CommandContext)c, (String)"boss"), class_2232.method_9443((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2277.method_9736((CommandContext)c, (String)"pos"), class_2232.method_9443((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2277.method_9736((CommandContext)c, (String)"pos"), null, null)));
        builder.then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2186.method_9309()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"boss", (ArgumentType)class_2232.method_9441()).suggests(SUGGEST_BOSS).then(class_2170.method_9244((String)"rarity", (ArgumentType)class_2232.method_9441()).suggests(LootifyCommand.SUGGEST_RARITY).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2186.method_9313((CommandContext)c, (String)"entity").method_19538(), class_2232.method_9443((CommandContext)c, (String)"boss"), class_2232.method_9443((CommandContext)c, (String)"rarity"))))).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2186.method_9313((CommandContext)c, (String)"entity").method_19538(), class_2232.method_9443((CommandContext)c, (String)"boss"), null)))).executes(c -> BossCommand.spawnBoss((CommandContext<class_2168>)c, class_2186.method_9313((CommandContext)c, (String)"entity").method_19538(), null, null)));
        root.then((ArgumentBuilder)builder);
    }

    public static int spawnBoss(CommandContext<class_2168> c, class_243 pos, @Nullable class_2960 bossId, @Nullable class_2960 rarityId) {
        class_1308 bossEntity;
        ApothBoss boss;
        class_1657 summoner;
        class_1297 nullableSummoner = ((class_2168)c.getSource()).method_9228();
        class_1657 class_16572 = summoner = nullableSummoner instanceof class_1657 ? (class_1657)nullableSummoner : ((class_2168)c.getSource()).method_9225().method_18459(pos.method_10216(), pos.method_10214(), pos.method_10215(), 64.0, false);
        if (summoner == null) {
            ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No available player context!"));
            return -1;
        }
        ApothBoss apothBoss = boss = bossId == null ? (ApothBoss)BossRegistry.INSTANCE.getRandomItem(summoner.method_6051(), summoner.method_7292(), new Predicate[]{WeightedDynamicRegistry.IDimensional.matches((class_1937)summoner.method_37908()), GameStagesCompat.IStaged.matches(summoner)}) : (ApothBoss)BossRegistry.INSTANCE.getValue(bossId);
        if (boss == null) {
            if (bossId == null) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown boss: " + bossId)));
            } else {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)"No bosses available for the current context!"));
            }
            return -2;
        }
        if (rarityId != null) {
            DynamicHolder rarity = RarityRegistry.INSTANCE.holder(rarityId);
            if (!rarity.isBound()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Unknown rarity: " + rarityId)));
                return -3;
            }
            bossEntity = boss.createBoss((class_5425)summoner.method_37908(), class_2338.method_49638((class_2374)pos), summoner.method_6051(), summoner.method_7292(), (LootRarity)rarity.get());
        } else {
            bossEntity = boss.createBoss((class_5425)summoner.method_37908(), class_2338.method_49638((class_2374)pos), summoner.method_6051(), summoner.method_7292());
        }
        ((class_2168)c.getSource()).method_9225().method_30771((class_1297)bossEntity);
        return 0;
    }
}

