/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.boss;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.boss.BossEvents;
import dev.shadowsoffire.placebo.codec.CodecMap;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import dev.shadowsoffire.placebo.codec.PlaceboCodecs;
import dev.shadowsoffire.placebo.json.NBTAdapter;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1308;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_5425;

public interface Exclusion
extends CodecProvider<Exclusion> {
    public static final CodecMap<Exclusion> CODEC = new CodecMap("Miniboss Exclusion");

    public boolean isExcluded(class_1308 var1, class_5425 var2, class_3730 var3, @Nullable class_2487 var4);

    public boolean requiresNbtAccess();

    public static void initSerializers() {
        Exclusion.register("spawn_type", SpawnTypeExclusion.CODEC);
        Exclusion.register("nbt", NbtExclusion.CODEC);
        Exclusion.register("surface_type", SurfaceTypeExclusion.CODEC);
        Exclusion.register("and", AndExclusion.CODEC);
    }

    private static void register(String id, Codec<? extends Exclusion> codec) {
        CODEC.register(Apotheosis.loc(id), codec);
    }

    public record SpawnTypeExclusion(Set<class_3730> types) implements Exclusion
    {
        public static Codec<SpawnTypeExclusion> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)PlaceboCodecs.setOf((Codec)PlaceboCodecs.enumCodec(class_3730.class)).fieldOf("spawn_types").forGetter(SpawnTypeExclusion::types)).apply((Applicative)inst, SpawnTypeExclusion::new));

        public Codec<? extends Exclusion> getCodec() {
            return CODEC;
        }

        @Override
        public boolean isExcluded(class_1308 mob, class_5425 level, class_3730 spawnType, class_2487 entityNbt) {
            return this.types.contains(spawnType);
        }

        @Override
        public boolean requiresNbtAccess() {
            return false;
        }
    }

    public record NbtExclusion(class_2487 nbt) implements Exclusion
    {
        public static Codec<NbtExclusion> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)NBTAdapter.EITHER_CODEC.fieldOf("nbt").forGetter(NbtExclusion::nbt)).apply((Applicative)inst, NbtExclusion::new));

        public Codec<? extends Exclusion> getCodec() {
            return CODEC;
        }

        @Override
        public boolean isExcluded(class_1308 mob, class_5425 level, class_3730 spawnType, class_2487 entityNbt) {
            return class_2512.method_10687((class_2520)this.nbt, (class_2520)entityNbt, (boolean)true);
        }

        @Override
        public boolean requiresNbtAccess() {
            return true;
        }
    }

    public record SurfaceTypeExclusion(BossEvents.BossSpawnRules rule) implements Exclusion
    {
        public static Codec<SurfaceTypeExclusion> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)BossEvents.BossSpawnRules.CODEC.fieldOf("rule").forGetter(SurfaceTypeExclusion::rule)).apply((Applicative)inst, SurfaceTypeExclusion::new));

        public Codec<? extends Exclusion> getCodec() {
            return CODEC;
        }

        @Override
        public boolean isExcluded(class_1308 mob, class_5425 level, class_3730 spawnType, class_2487 entityNbt) {
            return !this.rule.test(level, mob.method_24515());
        }

        @Override
        public boolean requiresNbtAccess() {
            return false;
        }
    }

    public record AndExclusion(List<Exclusion> exclusions) implements Exclusion
    {
        public static Codec<AndExclusion> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)CODEC.listOf().fieldOf("exclusions").forGetter(AndExclusion::exclusions)).apply((Applicative)inst, AndExclusion::new));

        public Codec<? extends Exclusion> getCodec() {
            return CODEC;
        }

        @Override
        public boolean isExcluded(class_1308 mob, class_5425 level, class_3730 spawnType, class_2487 entityNbt) {
            return this.exclusions.stream().allMatch(e -> e.isExcluded(mob, level, spawnType, entityNbt));
        }

        @Override
        public boolean requiresNbtAccess() {
            return this.exclusions.stream().anyMatch(Exclusion::requiresNbtAccess);
        }
    }
}

