/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.cutting;

import dev.shadowsoffire.apotheosis.advancements.AdvancementTriggers;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3914;

public class GemCuttingMenu
extends PlaceboContainerMenu {
    public static final int NEXT_MAT_COST = 1;
    public static final int STD_MAT_COST = 3;
    public static final int PREV_MAT_COST = 9;
    public static final List<GemCuttingRecipe> RECIPES = new ArrayList<GemCuttingRecipe>();
    protected final class_1657 player;
    protected final class_3914 access;
    protected final class_1277 inventory = new class_1277(4);

    public GemCuttingMenu(int id, class_1661 playerInv) {
        this(id, playerInv, class_3914.field_17304);
    }

    public GemCuttingMenu(int id, class_1661 playerInv, class_3914 access) {
        super(Adventure.Menus.GEM_CUTTING, id, playerInv);
        this.player = playerInv.field_7546;
        this.access = access;
        this.method_7621(new class_1735((class_1263)this.inventory, 0, 53, 25){

            public boolean method_7680(class_1799 stack) {
                return GemItem.getGem(stack).isBound();
            }

            public void method_7668() {
                super.method_7668();
                GemCuttingMenu.this.method_7609(this.field_7871);
            }

            public int method_7675() {
                return 1;
            }
        });
        this.method_7621(this.addUpdatingSlot((class_1263)this.inventory, 1, 12, 25, stack -> stack.method_7909() == Adventure.Items.GEM_DUST));
        this.method_7621(this.addUpdatingSlot((class_1263)this.inventory, 2, 53, 68, this::matchesMainGem));
        this.method_7621(this.addUpdatingSlot((class_1263)this.inventory, 3, 94, 25, this::isValidMaterial));
        this.addPlayerSlots(playerInv, 8, 98);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.inventory.method_5438(0).method_7960() && GemCuttingMenu.isValidMainGem(stack), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.method_7909() == Adventure.Items.GEM_DUST, 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.matchesMainGem((class_1799)stack), 2, 3);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.isValidMaterial((class_1799)stack), 3, 4);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    protected class_1735 addUpdatingSlot(class_1263 container, int index, int x, int y, final Predicate<class_1799> filter) {
        return new class_1735(container, index, x, y){

            public boolean method_7680(class_1799 stack) {
                return filter.test(stack);
            }

            public void method_7668() {
                super.method_7668();
                GemCuttingMenu.this.method_7609(this.field_7871);
            }
        };
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            class_1799 gem = this.inventory.method_5438(0);
            class_1799 left = this.inventory.method_5438(1);
            class_1799 bot = this.inventory.method_5438(2);
            class_1799 right = this.inventory.method_5438(3);
            for (GemCuttingRecipe r : RECIPES) {
                if (!r.matches(gem, left, bot, right)) continue;
                class_1799 out = r.getResult(gem, left, bot, right);
                r.decrementInputs(gem, left, bot, right);
                this.inventory.method_5447(0, out);
                this.level.method_8396(player, player.method_24515(), class_3417.field_26979, class_3419.field_15245, 1.0f, 1.5f + 0.35f * (1.0f - 2.0f * this.level.field_9229.method_43057()));
                AdvancementTriggers.GEM_CUT.trigger((class_3222)player, out, AffixHelper.getRarity(out).getId());
                return true;
            }
        }
        return false;
    }

    public static boolean isValidMainGem(class_1799 stack) {
        GemInstance inst = GemInstance.unsocketed(stack);
        return inst.isValidUnsocketed() && !inst.isMaxRarity();
    }

    protected boolean isValidMaterial(class_1799 stack) {
        GemInstance mainGem = GemInstance.unsocketed(this.inventory.method_5438(0));
        if (!mainGem.isValidUnsocketed()) {
            return false;
        }
        DynamicHolder<LootRarity> rarity = RarityRegistry.getMaterialRarity(stack.method_7909());
        return rarity.isBound() && Math.abs(((LootRarity)rarity.get()).ordinal() - ((LootRarity)mainGem.rarity().get()).ordinal()) <= 1;
    }

    protected boolean matchesMainGem(class_1799 stack) {
        GemInstance gem = GemInstance.unsocketed(stack);
        GemInstance mainGem = GemInstance.unsocketed(this.inventory.method_5438(0));
        return gem.isValidUnsocketed() && mainGem.isValidUnsocketed() && gem.gem() == mainGem.gem() && gem.rarity() == mainGem.rarity();
    }

    public boolean method_7597(class_1657 pPlayer) {
        return (Boolean)this.access.method_17396((level, pos) -> level.method_8320(pos).method_26204() == Adventure.Blocks.GEM_CUTTING_TABLE, (Object)true);
    }

    public void method_7595(class_1657 pPlayer) {
        super.method_7595(pPlayer);
        this.access.method_17393((level, pos) -> this.method_7607(pPlayer, (class_1263)this.inventory));
    }

    public static int getDustCost(LootRarity gemRarity) {
        return 1 + gemRarity.ordinal() * 2;
    }

    static {
        RECIPES.add(new RarityUpgrade());
    }

    public static interface GemCuttingRecipe {
        public boolean matches(class_1799 var1, class_1799 var2, class_1799 var3, class_1799 var4);

        public class_1799 getResult(class_1799 var1, class_1799 var2, class_1799 var3, class_1799 var4);

        public void decrementInputs(class_1799 var1, class_1799 var2, class_1799 var3, class_1799 var4);
    }

    public static class RarityUpgrade
    implements GemCuttingRecipe {
        @Override
        public boolean matches(class_1799 gem, class_1799 left, class_1799 bot, class_1799 right) {
            DynamicHolder<LootRarity> gemRarity;
            GemInstance g = GemInstance.unsocketed(gem);
            GemInstance g2 = GemInstance.unsocketed(bot);
            if (!g.isValidUnsocketed() || !g2.isValidUnsocketed() || g.gem() != g2.gem() || g.rarity() != g2.rarity()) {
                return false;
            }
            if (g.isMaxRarity()) {
                return false;
            }
            if (left.method_7909() != Adventure.Items.GEM_DUST || left.method_7947() < GemCuttingMenu.getDustCost((LootRarity)g.rarity().get())) {
                return false;
            }
            if (!RarityRegistry.isMaterial(right.method_7909())) {
                return false;
            }
            DynamicHolder<LootRarity> matRarity = RarityRegistry.getMaterialRarity(right.method_7909());
            if (matRarity == (gemRarity = g.rarity())) {
                return right.method_7947() >= 3;
            }
            if (matRarity == RarityRegistry.next(gemRarity)) {
                return right.method_7947() >= 1;
            }
            return matRarity == RarityRegistry.prev(gemRarity) && right.method_7947() >= 9;
        }

        @Override
        public class_1799 getResult(class_1799 gem, class_1799 left, class_1799 bot, class_1799 right) {
            class_1799 out = gem.method_7972();
            AffixHelper.setRarity(out, (LootRarity)RarityRegistry.next(AffixHelper.getRarity(out)).get());
            return out;
        }

        @Override
        public void decrementInputs(class_1799 gem, class_1799 left, class_1799 bot, class_1799 right) {
            DynamicHolder<LootRarity> matRarity = RarityRegistry.getMaterialRarity(right.method_7909());
            DynamicHolder<LootRarity> gemRarity = GemInstance.unsocketed(gem).rarity();
            gem.method_7934(1);
            left.method_7934(GemCuttingMenu.getDustCost((LootRarity)gemRarity.get()));
            bot.method_7934(1);
            right.method_7934(matRarity == gemRarity ? 3 : (matRarity == RarityRegistry.next(gemRarity) ? 1 : 9));
        }
    }
}

