/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.special;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_8103;

public class MageSlayerBonus
extends GemBonus {
    public static Codec<MageSlayerBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, MageSlayerBonus::new));
    protected final Map<LootRarity, StepFunction> values;

    public MageSlayerBonus(Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("mageslayer"), new GemClass("helmet", (Set<LootCategory>)ImmutableSet.of((Object)LootCategory.HELMET)));
        this.values = values;
    }

    @Override
    public float onHurt(class_1799 gem, LootRarity rarity, class_1282 src, class_1309 user, float amount) {
        float value = this.values.get(rarity).min();
        if (src.method_48789(class_8103.field_42241)) {
            user.method_6025(amount * (1.0f - value));
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("Mage slayer triggered, healing for {}, value is {}, total taken is {}", (Object)Float.valueOf(amount * (1.0f - value)), (Object)Float.valueOf(amount), (Object)Float.valueOf(amount - amount * (1.0f - value)));
            }
            return amount;
        }
        return super.onHurt(gem, rarity, src, user, amount);
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        float value = this.values.get(rarity).min();
        return class_2561.method_43469((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(value * 100.0f)}).method_27692(class_124.field_1054);
    }

    @Override
    public MageSlayerBonus validate() {
        Preconditions.checkNotNull(this.values);
        this.values.forEach((k, v) -> {
            Preconditions.checkNotNull((Object)k);
            Preconditions.checkNotNull((Object)v);
        });
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }
}

