/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class DurabilityBonus
extends GemBonus {
    public static Codec<DurabilityBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DurabilityBonus.gemClass(), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, DurabilityBonus::new));
    protected final Map<LootRarity, StepFunction> values;

    public DurabilityBonus(GemClass gemClass, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("durability"), gemClass);
        this.values = values;
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        float level = this.values.get(rarity).get(0.0f);
        return class_2561.method_43469((String)("bonus." + this.getId() + ".desc"), (Object[])new Object[]{Affix.fmt(100.0f * level)}).method_27692(class_124.field_1054);
    }

    @Override
    public float getDurabilityBonusPercentage(class_1799 gem, LootRarity rarity, class_3222 user) {
        return this.values.get(rarity).min();
    }

    @Override
    public GemBonus validate() {
        Preconditions.checkNotNull(this.values, (Object)"Invalid AttributeBonus with null values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

