/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus;

import com.google.common.base.Preconditions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.effect.DamageReductionAffix;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemClass;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_8103;

public class DamageReductionBonus
extends GemBonus {
    protected final DamageReductionAffix.DamageType type;
    protected final Map<LootRarity, StepFunction> values;
    public static Codec<DamageReductionBonus> CODEC = RecordCodecBuilder.create(inst -> inst.group(DamageReductionBonus.gemClass(), (App)DamageReductionAffix.DamageType.CODEC.fieldOf("damage_type").forGetter(a -> a.type), (App)VALUES_CODEC.fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, DamageReductionBonus::new));

    public DamageReductionBonus(GemClass gemClass, DamageReductionAffix.DamageType type, Map<LootRarity, StepFunction> values) {
        super(Apotheosis.loc("damage_reduction"), gemClass);
        this.type = type;
        this.values = values;
    }

    @Override
    public float onHurt(class_1799 gem, LootRarity rarity, class_1282 src, class_1309 user, float amount) {
        if (src.method_48789(class_8103.field_42242) || src.method_48789(class_8103.field_42245)) {
            return amount;
        }
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Damage reduction percentage from gem: %{},", (Object)Affix.fmt(100.0f * this.values.get(rarity).get(0.0f)));
        }
        if (this.type.test(src)) {
            return amount * (1.0f - this.values.get(rarity).get(0.0f));
        }
        return super.onHurt(gem, rarity, src, user, amount);
    }

    @Override
    public class_2561 getSocketBonusTooltip(class_1799 gem, LootRarity rarity) {
        float level = this.values.get(rarity).get(0.0f);
        return class_2561.method_43469((String)"affix.zenith:damage_reduction.desc", (Object[])new Object[]{class_2561.method_43471((String)("misc.zenith." + this.type.getId())), Affix.fmt(100.0f * level)}).method_27692(class_124.field_1054);
    }

    @Override
    public GemBonus validate() {
        Preconditions.checkNotNull((Object)this.type, (Object)"Invalid DamageReductionBonus with null type");
        Preconditions.checkNotNull(this.values, (Object)"Invalid DamageReductionBonus with null values");
        Preconditions.checkArgument((boolean)this.values.entrySet().stream().mapMulti((entry, consumer) -> {
            consumer.accept(entry.getKey());
            consumer.accept(entry.getValue());
        }).allMatch(Objects::nonNull), (Object)"Invalid DamageReductionBonus with invalid values");
        return this;
    }

    @Override
    public boolean supports(LootRarity rarity) {
        return this.values.containsKey(rarity);
    }

    @Override
    public int getNumberOfUUIDs() {
        return 0;
    }

    public Codec<? extends GemBonus> getCodec() {
        return CODEC;
    }
}

