/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.socket.gem;

import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.Gem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.GemItem;
import dev.shadowsoffire.apotheosis.adventure.affix.socket.gem.bonus.GemBonus;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.placebo.reload.DynamicHolder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1887;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_47;
import net.spell_engine.api.spell.SpellEvents;

public record GemInstance(DynamicHolder<Gem> gem, LootCategory cat, class_1799 gemStack, DynamicHolder<LootRarity> rarity) {
    public static GemInstance socketed(class_1799 socketed, class_1799 gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        DynamicHolder rarity = AffixHelper.getRarity(gemStack);
        if (gem.isBound() && rarity.isBound()) {
            rarity = RarityRegistry.INSTANCE.holder(((Gem)gem.get()).clamp((LootRarity)rarity.get()));
        }
        return new GemInstance(gem, LootCategory.forItem(socketed), gemStack, rarity);
    }

    public static GemInstance unsocketed(class_1799 gemStack) {
        DynamicHolder<Gem> gem = GemItem.getGem(gemStack);
        DynamicHolder rarity = AffixHelper.getRarity(gemStack);
        if (gem.isBound() && rarity.isBound()) {
            rarity = RarityRegistry.INSTANCE.holder(((Gem)gem.get()).clamp((LootRarity)rarity.get()));
        }
        return new GemInstance(gem, LootCategory.NONE, gemStack, rarity);
    }

    public boolean isValidUnsocketed() {
        return this.gem.isBound() && this.rarity.isBound();
    }

    public boolean isValid() {
        return this.isValidUnsocketed() && ((Gem)this.gem.get()).getBonus(this.cat).isPresent();
    }

    public boolean isMaxRarity() {
        return this.rarity().get() == ((Gem)this.gem.get()).getMaxRarity();
    }

    public boolean canApplyTo(class_1799 stack) {
        return ((Gem)this.gem.get()).canApplyTo(stack, this.gemStack, (LootRarity)this.rarity.get());
    }

    public void addModifiers(class_1304 slot, BiConsumer<class_1320, class_1322> map) {
        for (class_1304 itemSlot : this.cat.getSlots()) {
            if (itemSlot != slot) continue;
            this.ifPresent(b -> b.addModifiers(this.gemStack, (LootRarity)this.rarity.get(), map));
        }
    }

    public class_2561 getSocketBonusTooltip() {
        return this.map(b -> b.getSocketBonusTooltip(this.gemStack, (LootRarity)this.rarity.get())).orElse((class_2561)class_2561.method_43470((String)"Invalid Gem Category"));
    }

    public int getDamageProtection(class_1282 source) {
        return this.map(b -> b.getDamageProtection(this.gemStack, (LootRarity)this.rarity.get(), source)).orElse(0);
    }

    public float getDamageBonus(class_1310 creatureType) {
        return this.map(b -> Float.valueOf(b.getDamageBonus(this.gemStack, (LootRarity)this.rarity.get(), creatureType))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public void doPostAttack(class_1309 user, @Nullable class_1297 target) {
        this.ifPresent(b -> b.doPostAttack(this.gemStack, (LootRarity)this.rarity.get(), user, target));
    }

    public void doPostHurt(class_1309 user, @Nullable class_1297 attacker) {
        this.ifPresent(b -> b.doPostHurt(this.gemStack, (LootRarity)this.rarity.get(), user, attacker));
    }

    public void onArrowFired(class_1309 user, class_1665 arrow) {
        this.ifPresent(b -> b.onArrowFired(this.gemStack, (LootRarity)this.rarity.get(), user, arrow));
    }

    @Nullable
    public class_1269 onItemUse(class_1838 ctx) {
        return this.map(b -> b.onItemUse(this.gemStack, (LootRarity)this.rarity.get(), ctx)).orElse(null);
    }

    public void onArrowImpact(class_1665 arrow, class_239 res, class_239.class_240 type) {
    }

    public float onShieldBlock(class_1309 entity, class_1282 source, float amount) {
        return this.map(b -> Float.valueOf(b.onShieldBlock(this.gemStack, (LootRarity)this.rarity.get(), entity, source, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void onBlockBreak(class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        this.ifPresent(b -> b.onBlockBreak(this.gemStack, (LootRarity)this.rarity.get(), player, world, pos, state));
    }

    public float getDurabilityBonusPercentage(class_3222 user) {
        return this.map(b -> Float.valueOf(b.getDurabilityBonusPercentage(this.gemStack, (LootRarity)this.rarity.get(), user))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    public float onHurt(class_1282 src, class_1309 ent, float amount) {
        return this.map(b -> Float.valueOf(b.onHurt(this.gemStack, (LootRarity)this.rarity.get(), src, ent, amount))).orElse(Float.valueOf(amount)).floatValue();
    }

    public void getEnchantmentLevels(Map<class_1887, Integer> enchantments) {
        this.ifPresent(b -> b.getEnchantmentLevels(this.gemStack, (LootRarity)this.rarity.get(), enchantments));
    }

    public void modifyLoot(ObjectArrayList<class_1799> loot, class_47 ctx) {
        this.ifPresent(b -> b.modifyLoot(this.gemStack, (LootRarity)this.rarity.get(), loot, ctx));
    }

    private <T> Optional<T> map(Function<GemBonus, T> function) {
        return ((Gem)this.gem.get()).getBonus(this.cat).map(function);
    }

    public void onCast(SpellEvents.ProjectileLaunchEvent event) {
        this.ifPresent(b -> b.onCast(this.gemStack, (LootRarity)this.rarity.get(), event));
    }

    private void ifPresent(Consumer<GemBonus> function) {
        ((Gem)this.gem.get()).getBonus(this.cat).ifPresent(function);
    }
}

