/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.salvaging;

import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.salvaging.SalvagingTableTile;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;

public class SalvagingMenu
extends PlaceboContainerMenu {
    protected final class_1657 player;
    protected final class_2338 pos;
    protected final SalvagingTableTile tile;
    protected final class_1277 inputInventory = new class_1277(15){

        public int method_5444() {
            return 1;
        }

        public void method_5431() {
            SalvagingMenu.this.tile.method_5431();
        }
    };

    public SalvagingMenu(int id, class_1661 inv, class_2540 buf) {
        this(id, inv, buf.method_10811());
    }

    public SalvagingMenu(int id, class_1661 inv, class_2338 pos) {
        super(Adventure.Menus.SALVAGE, id, inv);
        int i;
        this.player = inv.field_7546;
        this.pos = pos;
        this.tile = (SalvagingTableTile)this.level.method_8321(pos);
        for (i = 0; i < 15; ++i) {
            this.method_7621(new class_1735((class_1263)this.inputInventory, i, 8 + i % 5 * 18, 17 + i / 5 * 18){

                public boolean method_7680(class_1799 stack) {
                    return SalvagingMenu.findMatch(SalvagingMenu.this.level, stack) != null;
                }

                public void method_7668() {
                    SalvagingMenu.this.method_7609((class_1263)SalvagingMenu.this.inputInventory);
                    super.method_7668();
                }
            });
        }
        for (i = 0; i < 6; ++i) {
            this.method_7621(new class_1735((class_1263)this.tile.container, i, 134 + i % 2 * 18, 17 + i / 2 * 18){

                public boolean method_7680(class_1799 stack) {
                    return false;
                }
            });
        }
        this.addPlayerSlots(inv, 8, 84);
        for (i = 0; i < 15; ++i) {
            int finalI = i;
            this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.inputInventory.method_5438(finalI).method_7960() && SalvagingMenu.findMatch(this.level, stack) != null, i, i + 1);
        }
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
    }

    public boolean method_7597(class_1657 player) {
        if (this.level.field_9236) {
            return true;
        }
        return this.level.method_8320(this.pos).method_26204() == Adventure.Blocks.SALVAGING_TABLE;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!this.level.field_9236) {
            this.method_7607(player, (class_1263)this.inputInventory);
        }
    }

    public boolean method_7604(class_1657 player, int id) {
        if (id == 0) {
            this.salvageAll();
            this.level.method_8396(null, player.method_24515(), class_3417.field_14858, class_3419.field_15245, 0.99f, this.level.field_9229.method_43057() * 0.25f + 1.0f);
            this.level.method_8396(null, player.method_24515(), class_3417.field_26946, class_3419.field_15245, 0.34f, this.level.field_9229.method_43057() * 0.2f + 0.8f);
            this.level.method_8396(null, player.method_24515(), class_3417.field_22463, class_3419.field_15245, 0.45f, this.level.field_9229.method_43057() * 0.5f + 0.75f);
            return true;
        }
        return super.method_7604(player, id);
    }

    protected void giveItem(class_1657 player, class_1799 stack) {
        if (!player.method_5805() || player instanceof class_3222 && ((class_3222)player).method_14239()) {
            player.method_7328(stack, false);
        } else {
            class_1661 inventory = player.method_31548();
            if (inventory.field_7546 instanceof class_3222) {
                inventory.method_7398(stack);
            }
        }
    }

    protected void salvageAll() {
        for (int inSlot = 0; inSlot < 15; ++inSlot) {
            class_1735 s = this.method_7611(inSlot);
            class_1799 stack = s.method_7677();
            List<class_1799> outputs = SalvagingMenu.salvageItem(this.level, stack);
            s.method_7673(class_1799.field_8037);
            for (class_1799 out : outputs) {
                for (int outSlot = 0; outSlot < 6 && !out.method_7960(); ++outSlot) {
                    out = this.tile.container.method_5491(out);
                }
                if (out.method_7960()) continue;
                this.giveItem(this.player, out);
            }
        }
    }

    public static int getSalvageCount(SalvagingRecipe.OutputData output, class_1799 stack, class_5819 rand) {
        int[] counts = SalvagingMenu.getSalvageCounts(output, stack);
        return rand.method_43051(counts[0], counts[1] + 1);
    }

    public static int[] getSalvageCounts(SalvagingRecipe.OutputData output, class_1799 stack) {
        int[] out = new int[]{output.min, output.max};
        if (stack.method_7963()) {
            out[1] = Math.max(out[0], Math.round((float)(out[1] * (stack.method_7936() - stack.method_7919())) / (float)stack.method_7936()));
        }
        return out;
    }

    public static List<class_1799> salvageItem(class_1937 level, class_1799 stack) {
        SalvagingRecipe recipe = SalvagingMenu.findMatch(level, stack);
        if (recipe == null) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (SalvagingRecipe.OutputData d : recipe.getOutputs()) {
            class_1799 out = d.stack.method_7972();
            out.method_7939(SalvagingMenu.getSalvageCount(d, stack, level.field_9229));
            outputs.add(out);
        }
        return outputs;
    }

    public static List<class_1799> getBestPossibleSalvageResults(class_1937 level, class_1799 stack) {
        SalvagingRecipe recipe = SalvagingMenu.findMatch(level, stack);
        if (recipe == null) {
            return Collections.emptyList();
        }
        ArrayList<class_1799> outputs = new ArrayList<class_1799>();
        for (SalvagingRecipe.OutputData d : recipe.getOutputs()) {
            class_1799 out = d.stack.method_7972();
            out.method_7939(SalvagingMenu.getSalvageCounts(d, stack)[1]);
            outputs.add(out);
        }
        return outputs;
    }

    @Nullable
    public static SalvagingRecipe findMatch(class_1937 level, class_1799 stack) {
        for (SalvagingRecipe recipe : level.method_8433().method_30027(Adventure.RecipeTypes.SALVAGING)) {
            if (!recipe.matches(stack)) continue;
            return recipe;
        }
        return null;
    }
}

