/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.reforging;

import blue.endless.jankson.annotation.Nullable;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingRecipe;
import dev.shadowsoffire.apotheosis.adventure.affix.reforging.ReforgingTableTile;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootController;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.adventure.loot.RarityRegistry;
import dev.shadowsoffire.apotheosis.cca.IntComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.apotheosis.util.ApothMiscUtil;
import dev.shadowsoffire.placebo.menu.MenuUtil;
import dev.shadowsoffire.placebo.menu.PlaceboContainerMenu;
import dev.shadowsoffire.placebo.util.EnchantmentUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_3417;
import net.minecraft.class_3915;
import net.minecraft.class_5819;
import net.minecraft.class_6677;
import net.minecraft.class_7923;

public class ReforgingMenu
extends PlaceboContainerMenu {
    public static final String REFORGE_SEED = "apoth_reforge_seed";
    protected final class_2338 pos;
    protected final ReforgingTableTile tile;
    protected final class_1657 player;
    protected class_1277 itemInventory = new class_1277(1);
    protected final class_5819 random = new class_6677(0L);
    protected final int[] seed = new int[2];
    protected final int[] costs = new int[3];
    protected class_3915 needsReset = class_3915.method_17403();

    public ReforgingMenu(int id, class_1661 inv, class_2540 buf) {
        this(id, inv, buf.method_10811());
    }

    public ReforgingMenu(int id, class_1661 inv, class_2338 pos) {
        super(Adventure.Menus.REFORGING, id, inv);
        this.player = inv.field_7546;
        this.pos = pos;
        this.tile = (ReforgingTableTile)this.level.method_8321(pos);
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((class_1263)this.itemInventory, 0, 25, 24, stack -> !LootCategory.forItem(stack).isNone()){

            public int method_7675() {
                return 1;
            }

            public int method_7676(class_1799 stack) {
                return 1;
            }
        });
        this.method_7621(new class_1735((class_1263)this.tile.inventory, 0, 15, 45){

            public boolean method_7680(class_1799 stack) {
                return ReforgingMenu.this.tile.isValidRarityMat(stack);
            }
        });
        this.method_7621(new class_1735((class_1263)this.tile.inventory, 1, 35, 45){

            public boolean method_7680(class_1799 stack) {
                return stack.method_31574(Adventure.Items.GEM_DUST);
            }
        });
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, (class_1263)this.tile.inventory, 0, 15, 45, this.tile::isValidRarityMat));
        this.method_7621((class_1735)new PlaceboContainerMenu.UpdatingSlot((PlaceboContainerMenu)this, (class_1263)this.tile.inventory, 1, 35, 45, stack -> stack.method_31574(Adventure.Items.GEM_DUST)));
        this.addPlayerSlots(inv, 8, 84);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && !LootCategory.forItem(stack).isNone(), 0, 1);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && this.tile.isValidRarityMat((class_1799)stack), 1, 2);
        this.mover.registerRule((stack, slot) -> slot >= this.playerInvStart && stack.method_7909() == Adventure.Items.GEM_DUST, 2, 3);
        this.mover.registerRule((stack, slot) -> slot < this.playerInvStart, this.playerInvStart, this.hotbarStart + 9);
        this.registerInvShuffleRules();
        this.updateSeed();
        this.method_17362(this.needsReset);
        this.method_17362(class_3915.method_17406((int[])this.seed, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.seed, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)0));
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)1));
        this.method_17362(class_3915.method_17406((int[])this.costs, (int)2));
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.method_7607(player, (class_1263)this.itemInventory);
    }

    protected void updateSeed() {
        int seed;
        if (this.player.getCustomData().method_10545(REFORGE_SEED)) {
            this.player.getCustomData().method_10551(REFORGE_SEED);
        }
        if ((seed = ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)this.player)).getValue()) == 0) {
            seed = this.player.method_6051().method_43054();
            ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)this.player)).setValue(seed);
        }
        this.seed[0] = MenuUtil.split((int)seed, (boolean)false);
        this.seed[1] = MenuUtil.split((int)seed, (boolean)true);
    }

    public int getSeed() {
        return MenuUtil.merge((int)this.seed[0], (int)this.seed[1], (boolean)true);
    }

    public boolean method_7604(class_1657 player, int slot) {
        if (slot >= 0 && slot < 3) {
            class_1799 input = this.method_7611(0).method_7677();
            LootRarity rarity = this.getRarity();
            ReforgingRecipe recipe = this.tile.getRecipeFor(rarity);
            if (recipe == null || input.method_7960() || this.needsReset()) {
                return false;
            }
            int dust = this.getDustCount();
            int dustCost = this.getDustCost(slot);
            int mats = this.getMatCount();
            int matCost = this.getMatCost(slot);
            int levels = this.player.field_7520;
            int levelCost = this.getLevelCost(slot);
            if (!(dust >= dustCost && mats >= matCost && levels >= levelCost || player.method_7337())) {
                return false;
            }
            if (!player.method_37908().field_9236) {
                class_5819 rand = this.random;
                rand.method_43052((long)(this.getSeed() ^ class_7923.field_41178.method_10221((Object)input.method_7909()).hashCode() + slot));
                class_1799 output = LootController.createLootItem(input.method_7972(), rarity, rand);
                this.method_7611(0).method_7673(output);
                if (!player.method_7337()) {
                    this.method_7611(1).method_7677().method_7934(matCost);
                    this.method_7611(2).method_7677().method_7934(dustCost);
                }
                EnchantmentUtils.chargeExperience((class_1657)player, (int)ApothMiscUtil.getExpCostForSlot(levelCost, slot));
                ((IntComponent)ZenithComponents.REFORGING_SEED.get((Object)this.player)).setValue(player.method_6051().method_43054());
                this.updateSeed();
                this.needsReset.method_17404(1);
            }
            player.method_5783(class_3417.field_14858, 0.99f, this.level.field_9229.method_43057() * 0.25f + 1.0f);
            player.method_5783(class_3417.field_26946, 0.34f, this.level.field_9229.method_43057() * 0.2f + 0.8f);
            player.method_5783(class_3417.field_22463, 0.45f, this.level.field_9229.method_43057() * 0.5f + 0.75f);
            return true;
        }
        return super.method_7604(player, slot);
    }

    public int getMatCount() {
        return this.method_7611(1).method_7677().method_7947();
    }

    public int getDustCount() {
        return this.method_7611(2).method_7677().method_7947();
    }

    @Nullable
    public LootRarity getRarity() {
        class_1799 s = this.method_7611(1).method_7677();
        if (s.method_7960()) {
            return null;
        }
        return RarityRegistry.getMaterialRarity(s.method_7909()).getOptional().orElse(null);
    }

    public int getDustCost(int slot) {
        return this.costs[0] * ++slot;
    }

    public int getMatCost(int slot) {
        return this.costs[1] * ++slot;
    }

    public int getLevelCost(int slot) {
        return this.costs[2] * ++slot;
    }

    public boolean needsReset() {
        return this.needsReset.method_17407() != 0;
    }

    public void method_7609(class_1263 pContainer) {
        ReforgingRecipe recipe;
        LootRarity rarity = this.getRarity();
        if (rarity != null && (recipe = this.tile.getRecipeFor(rarity)) != null) {
            this.costs[0] = recipe.dustCost();
            this.costs[1] = recipe.matCost();
            this.costs[2] = recipe.levelCost();
        }
        if (this.needsReset()) {
            this.needsReset.method_17404(0);
        }
        super.method_7609(pContainer);
        this.tile.method_5431();
    }

    public boolean method_7597(class_1657 player) {
        if (this.level.field_9236) {
            return true;
        }
        return this.level.method_8320(this.pos).method_26204() == Adventure.Blocks.REFORGING_TABLE || this.level.method_8320(this.pos).method_26204() == Adventure.Blocks.SIMPLE_REFORGING_TABLE;
    }
}

