/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;

public class TelepathicAffix
extends Affix {
    public static final Codec<TelepathicAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.CODEC.fieldOf("min_rarity").forGetter(a -> a.minRarity)).apply((Applicative)inst, TelepathicAffix::new));
    public static class_243 blockDropTargetPos = null;
    protected LootRarity minRarity;

    public TelepathicAffix(LootRarity minRarity) {
        super(AffixType.ABILITY);
        this.minRarity = minRarity;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return (cat.isRanged() || cat.isLightWeapon() || cat.isBreaker()) && rarity.isAtLeast(this.minRarity);
    }

    @Override
    public void addInformation(class_1799 stack, LootRarity rarity, float level, Consumer<class_2561> list) {
        LootCategory cat = LootCategory.forItem(stack);
        String type = cat.isRanged() || cat.isWeapon() ? "weapon" : "tool";
        list.accept((class_2561)class_2561.method_43471((String)("affix." + this.getId() + ".desc." + type)));
    }

    @Override
    public boolean enablesTelepathy() {
        return true;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static void drops(class_1282 source, Collection<class_1542> drops) {
        class_1665 arrow;
        boolean canTeleport = false;
        class_243 targetPos = null;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1665 && (arrow = (class_1665)class_12972).method_24921() != null) {
            canTeleport = AffixHelper.streamAffixes((class_1297)arrow).anyMatch(AffixInstance::enablesTelepathy);
            targetPos = arrow.method_24921().method_19538();
        } else {
            class_12972 = source.method_5526();
            if (class_12972 instanceof class_1309) {
                class_1309 living = (class_1309)class_12972;
                class_1799 weapon = living.method_6047();
                canTeleport = AffixHelper.streamAffixes(weapon).anyMatch(AffixInstance::enablesTelepathy);
                targetPos = living.method_19538();
            }
        }
        if (canTeleport) {
            for (class_1542 item : drops) {
                item.method_5814(targetPos.field_1352, targetPos.field_1351, targetPos.field_1350);
                item.method_6982(0);
            }
        }
    }
}

