/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.jamieswhiteshirt.reachentityattributes.ReachEntityAttributes;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.Adventure;
import dev.shadowsoffire.apotheosis.adventure.AdventureModule;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.cca.StringComponent;
import dev.shadowsoffire.apotheosis.cca.ZenithComponents;
import dev.shadowsoffire.placebo.util.PlaceboUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;

public class RadialAffix
extends Affix {
    public static final Codec<RadialAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(Codec.list(RadialData.CODEC)).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, RadialAffix::new));
    private static Set<UUID> breakers = new HashSet<UUID>();
    protected final Map<LootRarity, List<RadialData>> values;

    public RadialAffix(Map<LootRarity, List<RadialData>> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return cat.isBreaker() && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(class_1799 stack, LootRarity rarity, float level, Consumer<class_2561> list) {
        RadialData data = this.getTrueLevel(rarity, level);
        list.accept((class_2561)class_2561.method_43469((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{data.x, data.y}));
    }

    public void onBreak(class_1937 world, class_1657 player, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity) {
        AffixInstance inst;
        class_1799 tool = player.method_6047();
        if (!world.field_9236 && tool.method_7985() && (inst = AffixHelper.getAffixes(tool).get(Adventure.Affixes.RADIAL)) != null && inst.isValid() && RadialState.getState(player).isRadialMiningEnabled(player)) {
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("Affix instance is valid");
            }
            float hardness = state.method_26214((class_1922)world, pos);
            RadialAffix.breakExtraBlocks((class_3222)player, pos, tool, this.getTrueLevel((LootRarity)inst.rarity().get(), inst.level()), hardness);
        }
    }

    private RadialData getTrueLevel(LootRarity rarity, float level) {
        List<RadialData> list = this.values.get(rarity);
        return list.get(Math.min(list.size() - 1, (int)class_3532.method_16439((float)level, (float)0.0f, (float)list.size())));
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static void toggleRadialState(class_1657 player) {
        RadialState state = RadialState.getState(player);
        RadialState next = state.next();
        RadialState.setState(player, next);
        player.method_43496((class_2561)Apotheosis.sysMessageHeader().method_10852((class_2561)class_2561.method_43469((String)"misc.zenith.radial_state_updated", (Object[])new Object[]{next.toComponent(), state.toComponent()}).method_27692(class_124.field_1054)));
    }

    public static void breakExtraBlocks(class_3222 player, class_2338 pos, class_1799 tool, RadialData level, float hardness) {
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("BreakExtraBlocks initialised");
        }
        if (!breakers.add(player.method_5667())) {
            return;
        }
        try {
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.info("Shift key is not down, attempting to break in a radius");
            }
            RadialAffix.breakBlockRadius(player, pos, level.x, level.y, level.xOff, level.yOff, hardness);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Removing player {} from break list", (Object)player);
        }
        breakers.remove(player.method_5667());
    }

    public static void breakBlockRadius(class_3222 player, class_2338 pos, int x, int y, int xOff, int yOff, float hardness) {
        class_243 target;
        class_3965 trace;
        class_1937 world = player.method_37908();
        if (x < 2 && y < 2) {
            return;
        }
        int lowerY = (int)Math.ceil((double)(-y) / 2.0);
        int upperY = (int)Math.round((double)y / 2.0);
        int lowerX = (int)Math.ceil((double)(-x) / 2.0);
        int upperX = (int)Math.round((double)x / 2.0);
        class_243 base = player.method_5836(0.0f);
        class_243 look = player.method_5720();
        double reach = player.method_26825(ReachEntityAttributes.REACH);
        double d = reach = player.method_7337() ? reach + 5.0 : reach + 4.5;
        if (Apotheosis.enableDebug) {
            AdventureModule.LOGGER.info("Reach distance: {}", (Object)reach);
        }
        if ((trace = world.method_17742(new class_3959(base, target = base.method_1031(look.field_1352 * reach, look.field_1351 * reach, look.field_1350 * reach), class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)player))) == null || trace.method_17783() != class_239.class_240.field_1332) {
            if (Apotheosis.enableDebug) {
                AdventureModule.LOGGER.warn("Hit result is null, or Hit result type isn't block!");
            }
            return;
        }
        class_3965 res = trace;
        class_2350 face = res.method_17780();
        for (int iy = lowerY; iy < upperY; ++iy) {
            for (int ix = lowerX; ix < upperX; ++ix) {
                class_2338 genPos = new class_2338(pos.method_10263() + ix + xOff, pos.method_10264() + iy + yOff, pos.method_10260());
                if (player.method_5735().method_10166() == class_2350.class_2351.field_11048) {
                    genPos = new class_2338(genPos.method_10263() - (ix + xOff), genPos.method_10264(), genPos.method_10260() + ix + xOff);
                }
                if (face.method_10166().method_10178()) {
                    genPos = RadialAffix.rotateDown(genPos, iy + yOff, player.method_5735());
                }
                if (genPos.equals((Object)pos)) continue;
                class_2680 state = world.method_8320(genPos);
                float stateHardness = state.method_26214((class_1922)world, genPos);
                if (state.method_26215() || stateHardness == -1.0f || !(stateHardness <= hardness * 3.0f) || !RadialAffix.isEffective(state, (class_1657)player)) continue;
                PlaceboUtil.tryHarvestBlock((class_3222)player, (class_2338)genPos);
            }
        }
    }

    static class_2338 rotateDown(class_2338 pos, int y, class_2350 horizontal) {
        class_2382 vec = horizontal.method_10163();
        return new class_2338(pos.method_10263() + vec.method_10263() * y, pos.method_10264() - y, pos.method_10260() + vec.method_10260() * y);
    }

    static boolean isEffective(class_2680 state, class_1657 player) {
        return player.method_7305(state);
    }

    record RadialData(int x, int y, int xOff, int yOff) {
        public static Codec<RadialData> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.fieldOf("x").forGetter(RadialData::x), (App)Codec.INT.fieldOf("y").forGetter(RadialData::y), (App)Codec.INT.fieldOf("xOff").forGetter(RadialData::xOff), (App)Codec.INT.fieldOf("yOff").forGetter(RadialData::yOff)).apply((Applicative)inst, RadialData::new));
    }

    static enum RadialState {
        REQUIRE_NOT_SNEAKING((Predicate<class_1657>)((Predicate)p -> !p.method_5715())),
        REQUIRE_SNEAKING((Predicate<class_1657>)((Predicate)class_1297::method_5715)),
        ENABLED((Predicate<class_1657>)((Predicate)p -> true)),
        DISABLED((Predicate<class_1657>)((Predicate)p -> false));

        private Predicate<class_1657> condition;

        private RadialState(Predicate<class_1657> condition) {
            this.condition = condition;
        }

        public boolean isRadialMiningEnabled(class_1657 input) {
            return this.condition.apply((Object)input);
        }

        public RadialState next() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case REQUIRE_NOT_SNEAKING -> REQUIRE_SNEAKING;
                case REQUIRE_SNEAKING -> ENABLED;
                case ENABLED -> DISABLED;
                case DISABLED -> REQUIRE_NOT_SNEAKING;
            };
        }

        public class_2561 toComponent() {
            return class_2561.method_43471((String)("misc.zenith.radial_state." + this.name().toLowerCase(Locale.ROOT)));
        }

        public static RadialState getState(class_1657 player) {
            String str = ((StringComponent)ZenithComponents.RADIAL_STATE.get((Object)player)).getValue();
            try {
                return RadialState.valueOf(str);
            }
            catch (Exception ex) {
                return REQUIRE_SNEAKING;
            }
        }

        public static void setState(class_1657 player, RadialState state) {
            ((StringComponent)ZenithComponents.RADIAL_STATE.get((Object)player)).setValue(state.name());
        }
    }
}

