/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.apotheosis.adventure.affix.effect;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.Apotheosis;
import dev.shadowsoffire.apotheosis.adventure.AdventureConfig;
import dev.shadowsoffire.apotheosis.adventure.affix.Affix;
import dev.shadowsoffire.apotheosis.adventure.affix.AffixType;
import dev.shadowsoffire.apotheosis.adventure.loot.LootCategory;
import dev.shadowsoffire.apotheosis.adventure.loot.LootRarity;
import dev.shadowsoffire.apotheosis.mixin.accessors.LivingEntityInvoker;
import dev.shadowsoffire.placebo.util.StepFunction;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3988;

public class CleavingAffix
extends Affix {
    public static final Codec<CleavingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LootRarity.mapCodec(CleaveValues.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, CleavingAffix::new));
    protected final Map<LootRarity, CleaveValues> values;
    private static boolean cleaving = false;

    public CleavingAffix(Map<LootRarity, CleaveValues> values) {
        super(AffixType.ABILITY);
        this.values = values;
    }

    @Override
    public boolean canApplyTo(class_1799 stack, LootCategory cat, LootRarity rarity) {
        return cat == LootCategory.HEAVY_WEAPON && this.values.containsKey(rarity);
    }

    @Override
    public void addInformation(class_1799 stack, LootRarity rarity, float level, Consumer<class_2561> list) {
        list.accept((class_2561)class_2561.method_43469((String)("affix." + this.getId() + ".desc"), (Object[])new Object[]{class_1799.field_8029.format(100.0f * this.getChance(rarity, level)), this.getTargets(rarity, level)}).method_27692(class_124.field_1054));
    }

    private float getChance(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).chance.get(level);
    }

    private int getTargets(LootRarity rarity, float level) {
        level %= 0.5f;
        return (int)this.values.get((Object)rarity).targets.get(level *= 2.0f);
    }

    @Override
    public void doPostAttack(class_1799 stack, LootRarity rarity, float level, class_1309 user, class_1297 target) {
        if ((double)Apotheosis.getLocalAtkStrength((class_1297)user) >= 0.98 && !cleaving && !user.method_37908().field_9236) {
            cleaving = true;
            float chance = this.getChance(rarity, level);
            int targets = this.getTargets(rarity, level);
            if (user.method_37908().field_9229.method_43057() < chance && user instanceof class_1657) {
                class_1657 player = (class_1657)user;
                List nearby = target.method_37908().method_8333(target, new class_238(target.method_24515()).method_1014(6.0), CleavingAffix.cleavePredicate((class_1297)user, target));
                for (class_1297 e : nearby) {
                    if (targets <= 0) continue;
                    ((LivingEntityInvoker)user).setAttackStrengthTicker(300);
                    player.method_7324(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Predicate<class_1297> cleavePredicate(class_1297 user, class_1297 target) {
        return e -> {
            class_1309 le;
            if (e instanceof class_1429 && !(target instanceof class_1429) || e instanceof class_3988 && !(target instanceof class_3988)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof class_1657) {
                return false;
            }
            if (target instanceof class_1569 && !(e instanceof class_1569)) {
                return false;
            }
            return e != user && e instanceof class_1309 && (le = (class_1309)e).method_5805();
        };
    }

    record CleaveValues(StepFunction chance, StepFunction targets) {
        public static final Codec<CleaveValues> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("chance").forGetter(c -> c.chance), (App)StepFunction.CODEC.fieldOf("targets").forGetter(c -> c.targets)).apply((Applicative)inst, CleaveValues::new));
    }
}

