/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public class YuushyaModelUtils {
    public static final Splitter COMMA_SPLITTER = Splitter.on((char)',');
    public static final Splitter EQUAL_SPLITTER = Splitter.on((char)'=').limit(2);

    public static List<class_2680> getBlockStateFromVariantString(class_2248 block, String variantKey) {
        class_2689 stateDefinition = block.method_9595();
        return stateDefinition.method_11662().stream().filter(YuushyaModelUtils.predicate((class_2689<class_2248, class_2680>)stateDefinition, variantKey)).toList();
    }

    public static Predicate<class_2680> predicate(class_2689<class_2248, class_2680> stateDefinition, String string) {
        if (string.equals("empty")) {
            return blockState -> blockState != null && blockState.method_27852((class_2248)stateDefinition.method_11660());
        }
        HashMap map = Maps.newHashMap();
        for (String s : COMMA_SPLITTER.split((CharSequence)string)) {
            Iterator iterator = EQUAL_SPLITTER.split((CharSequence)s).iterator();
            if (!iterator.hasNext()) continue;
            String key = (String)iterator.next();
            class_2769 property = stateDefinition.method_11663(key);
            if (property != null && iterator.hasNext()) {
                String value = (String)iterator.next();
                Object comparable = YuushyaModelUtils.getValueHelper(property, value);
                if (comparable == null) {
                    throw new RuntimeException("Unknown value: '" + value + "' for blockstate property: '" + key + "' " + property.method_11898());
                }
                map.put(property, comparable);
                continue;
            }
            if (key.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + key + "'");
        }
        class_2248 block = (class_2248)stateDefinition.method_11660();
        return blockState -> {
            if (blockState != null && blockState.method_27852(block)) {
                for (Map.Entry entry : map.entrySet()) {
                    if (Objects.equals(blockState.method_11654((class_2769)entry.getKey()), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    @Nullable
    private static <T extends Comparable<T>> T getValueHelper(class_2769<T> property, String name) {
        return (T)((Comparable)property.method_11900(name).orElse(null));
    }
}

