/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistryConfig;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.GsonTools;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3294;
import net.minecraft.class_3298;

public class AddonLoader {
    private static final Predicate<Path> ADDON_FILTER = path -> !Files.isDirectory(path, new LinkOption[0]) && path.getFileName().toString().endsWith(".yuushya.jar");
    private static final Predicate<class_2960> JSON_FILTER = resourceLocation -> resourceLocation.method_12832().endsWith(".json");
    private static final class_3294 YUUSHYA_MANAGER = new class_3294(class_3264.field_14190, "yuushya");

    public static void loadPackResource(Path folder) {
        try (Stream<Path> files = Files.list(folder).filter(ADDON_FILTER).sorted(Comparator.comparing(Path::toString));){
            List<Path> fileList = files.toList();
            for (Path path : fileList) {
                try (class_3258 packResource = new class_3258(path.getFileName().toString(), path.toFile(), false);){
                    YUUSHYA_MANAGER.method_24233((class_3262)packResource);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void getRegister() {
        for (Map.Entry entry : YUUSHYA_MANAGER.method_14488("register", JSON_FILTER).entrySet()) {
            try {
                class_3298 resource = (class_3298)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.method_43039());){
                    JsonElement innerJson = JsonParser.parseReader((Reader)reader);
                    YuushyaRegistryConfig.mergeYuushyaRegistryBlockJson(innerJson.getAsJsonObject().getAsJsonArray("block"));
                    YuushyaRegistryData YuushyaData = (YuushyaRegistryData)GsonTools.NormalGSON.fromJson(innerJson, YuushyaRegistryData.class);
                    YuushyaRegistryConfig.addResultToRawMap(YuushyaData);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void getCollision() {
        for (Map.Entry entry : YUUSHYA_MANAGER.method_14488("collision", JSON_FILTER).entrySet()) {
            try {
                class_2960 file = (class_2960)entry.getKey();
                class_2960 namespaceId1 = new class_2960("yuushya", file.method_12832().substring("collision/".length(), file.method_12832().length() - ".json".length()));
                class_3298 resource = (class_3298)entry.getValue();
                try (BufferedReader reader = new BufferedReader(resource.method_43039());){
                    JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    CollisionFileReader.getCollisionMap().put(namespaceId1.toString(), collision);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

