/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.collision;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.yuushya.block.YuushyaBlockFactory;
import com.yuushya.collision.data.CollisionItem;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.utils.GsonTools;
import com.yuushya.utils.YuushyaModelUtils;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2189;
import net.minecraft.class_2248;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CollisionFileReader {
    private static Map<String, CollisionItem> collisionMap = new HashMap<String, CollisionItem>();
    public static Path COLLISION_FILES = Platform.getConfigFolder().resolve("./com.yuushya/");

    public static void readAllFileSelf() {
        Set<String> set = YuushyaRegistries.BlockALL.keySet();
        for (String name : set) {
            try {
                InputStream inputStream = CollisionFileReader.class.getResourceAsStream("/data/yuushya/collision/" + name + ".json");
                try {
                    if (inputStream == null) continue;
                    JsonElement jsonElement = JsonParser.parseReader((Reader)new BufferedReader(new InputStreamReader(inputStream)));
                    CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(jsonElement, CollisionItem.class);
                    CollisionFileReader.getCollisionMap().put(new class_2960("yuushya", name).toString(), collision);
                    if (collision.children == null) continue;
                    for (String namespaceId : collision.children) {
                        CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                    }
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllFileFromConfig() {
        if (Files.exists(COLLISION_FILES, new LinkOption[0])) {
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(COLLISION_FILES);){
                for (Path path : paths) {
                    String namespace = path.getFileName().toString();
                    Path newPath = path.resolve("./data/" + namespace + "/collision/");
                    DirectoryStream<Path> collisionFiles = Files.newDirectoryStream(newPath);
                    try {
                        for (Path collisionFile : collisionFiles) {
                            String id = collisionFile.getFileName().toString().replace(".json", "");
                            if (!Files.exists(collisionFile, new LinkOption[0])) continue;
                            try (JsonReader reader = new JsonReader((Reader)new BufferedReader(new FileReader(collisionFile.toFile(), StandardCharsets.UTF_8)));){
                                CollisionItem collision = (CollisionItem)GsonTools.NormalGSON.fromJson(JsonParser.parseReader((JsonReader)reader), CollisionItem.class);
                                CollisionFileReader.getCollisionMap().put(new class_2960(namespace, id).toString(), collision);
                                if (collision.children == null) continue;
                                for (String namespaceId : collision.children) {
                                    CollisionFileReader.getCollisionMap().put(namespaceId, collision);
                                }
                            }
                        }
                    }
                    finally {
                        if (collisionFiles == null) continue;
                        collisionFiles.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void readAllCollision() {
        CollisionFileReader.getCollisionMap().forEach((key, value) -> CollisionFileReader.readCollisionToVoxelShape(key));
    }

    public static void readCollisionToVoxelShape(Map<class_2680, class_265> cache, class_2248 block, String namespaceid) {
        CollisionItem collision;
        if (!(block instanceof class_2189) && (collision = CollisionFileReader.getCollisionMap().get(namespaceid)) != null && collision.blockstates != null) {
            for (CollisionItem.Model variant : collision.blockstates) {
                List<class_2680> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant.variant);
                class_265 shape = CollisionFileReader.getVoxelShape(variant);
                for (class_2680 blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(class_2248.method_9507((class_2680)blockstate), shape);
                    cache.put(blockstate, shape);
                }
            }
        }
    }

    public static void readCollisionToVoxelShape(String namespaceid) {
        class_2248 block;
        CollisionItem collision = CollisionFileReader.getCollisionMap().get(namespaceid);
        if (collision != null && collision.blockstates != null && !((block = (class_2248)class_7923.field_41175.method_10223(new class_2960(namespaceid))) instanceof class_2189)) {
            for (CollisionItem.Model variant : collision.blockstates) {
                List<class_2680> blockstates = YuushyaModelUtils.getBlockStateFromVariantString(block, variant.variant);
                class_265 shape = CollisionFileReader.getVoxelShape(variant);
                for (class_2680 blockstate : blockstates) {
                    YuushyaBlockFactory.getYuushyaVoxelShapes().put(class_2248.method_9507((class_2680)blockstate), shape);
                }
            }
        }
    }

    public static class_265 getVoxelShape(CollisionItem.Model model) {
        class_265 shape = class_259.method_1073();
        if (model.collision == null) {
            return class_259.method_1077();
        }
        for (CollisionItem.Model.Element cube : model.collision) {
            shape = class_259.method_1084((class_265)shape, (class_265)class_2248.method_9541((double)cube.from.get(0), (double)cube.from.get(1), (double)cube.from.get(2), (double)cube.to.get(0), (double)cube.to.get(1), (double)cube.to.get(2)));
        }
        if ((shape = shape.method_1097()).method_1110()) {
            return class_259.method_1077();
        }
        return shape;
    }

    public static Map<String, CollisionItem> getCollisionMap() {
        return collisionMap;
    }

    public static void setCollisionMap(Map<String, CollisionItem> collisionMap) {
        CollisionFileReader.collisionMap = collisionMap;
    }
}

