/*
 * Decompiled with CFR 0.152.
 */
package com.yuushya.block;

import com.yuushya.block.AbstractYuushyaBlock;
import com.yuushya.block.AttachmentBlock;
import com.yuushya.block.CableBlock;
import com.yuushya.block.CompactBlock;
import com.yuushya.block.FaceBlock;
import com.yuushya.block.LineBlock;
import com.yuushya.block.NormalBlock;
import com.yuushya.block.PoleBlock;
import com.yuushya.block.RepeatBlock;
import com.yuushya.block.TriPartBlock;
import com.yuushya.block.TubeBlock;
import com.yuushya.block.blockstate.YuushyaBlockStates;
import com.yuushya.collision.CollisionFileReader;
import com.yuushya.entity.ChairEntityUtils;
import com.yuushya.registries.YuushyaRegistries;
import com.yuushya.registries.YuushyaRegistryData;
import com.yuushya.utils.YuushyaUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YuushyaBlockFactory {
    private static final Map<Integer, class_265> yuushyaVoxelShapes = new HashMap<Integer, class_265>();

    public static Map<Integer, class_265> getYuushyaVoxelShapes() {
        return yuushyaVoxelShapes;
    }

    public static class_4970.class_2251 getBlockProperties(class_4970.class_2251 blockProperties, YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        blockProperties = blockProperties.method_9629(yuushyaBlockProperties.hardness, yuushyaBlockProperties.resistance);
        if (yuushyaBlockProperties.sound != null && !yuushyaBlockProperties.sound.isEmpty()) {
            blockProperties = blockProperties.method_9626(YuushyaUtils.toSound(yuushyaBlockProperties.sound));
        }
        if (yuushyaBlockProperties.lightLevel != 0) {
            blockProperties = blockProperties.method_9631(state -> yuushyaBlockProperties.lightLevel);
        }
        if (!yuushyaBlockProperties.hasCollision) {
            blockProperties = blockProperties.method_9634();
        }
        if (yuushyaBlockProperties.isDelicate) {
            blockProperties = blockProperties.method_9618();
        }
        if (!yuushyaBlockProperties.isSolid) {
            blockProperties = blockProperties.method_22488();
        }
        if (yuushyaBlockProperties.offset != null) {
            blockProperties = blockProperties.method_49229(YuushyaUtils.toOffsetType(yuushyaBlockProperties.offset));
        }
        return blockProperties;
    }

    public static class_4970.class_2251 getBlockProperties(YuushyaRegistryData.Block.Properties yuushyaBlockProperties) {
        if (yuushyaBlockProperties == null) {
            return class_4970.class_2251.method_9637();
        }
        class_4970.class_2251 blockProperties = class_4970.class_2251.method_9637().method_9626(YuushyaUtils.toSound(yuushyaBlockProperties.material));
        return YuushyaBlockFactory.getBlockProperties(blockProperties, yuushyaBlockProperties);
    }

    private static List<? extends class_2769<?>> getBlockStateProperties(YuushyaRegistryData.Block.BlockState yuushyaBlockState) {
        if (yuushyaBlockState == null || yuushyaBlockState.states == null) {
            return List.of();
        }
        return yuushyaBlockState.states.stream().map(YuushyaBlockStates::toBlockStateProperty).toList();
    }

    public static class_2248 create(YuushyaRegistryData.Block yuushyaBlock) {
        return YuushyaBlockFactory.create(YuushyaBlockFactory.getBlockProperties(yuushyaBlock.properties), yuushyaBlock);
    }

    public static class_2248 create(class_4970.class_2251 properties, final YuushyaRegistryData.Block yuushyaBlock) {
        if (yuushyaBlock.autoGenerated == null) {
            yuushyaBlock.autoGenerated = new YuushyaRegistryData.Block.AutoGenerated();
            yuushyaBlock.autoGenerated.collision = "block";
        }
        if (yuushyaBlock.blockstate.kit != null && !yuushyaBlock.blockstate.kit.isEmpty()) {
            switch (yuushyaBlock.blockstate.kit) {
                case "normal": {
                    return new NormalBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "attachment": {
                    return new AttachmentBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "line": {
                    return new LineBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "face": {
                    return new FaceBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "pole": {
                    return new PoleBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "tri_part": {
                    return new TriPartBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "tube": {
                    return new TubeBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "compact": {
                    return new CompactBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "repeat": {
                    return new RepeatBlock(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
                }
                case "block": {
                    break;
                }
                case "VanillaSlabBlock": {
                    return new class_2482(properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaDoorBlock": {
                    return new class_2323(properties, YuushyaUtils.toBlockSetType(yuushyaBlock.properties)){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
                case "VanillaStairBlock": {
                    class_2680 blockState = class_2246.field_10161.method_9564();
                    if (yuushyaBlock.properties.parent != null) {
                        blockState = yuushyaBlock.properties.parent.contains(":") ? ((class_2248)class_7923.field_41175.method_10223(new class_2960(yuushyaBlock.properties.parent))).method_9564() : ((class_2248)YuushyaRegistries.BLOCKS.get(yuushyaBlock.properties.parent).get()).method_9564();
                    }
                    return new class_2510(blockState, properties){

                        public void method_9568(@NotNull class_1799 itemStack, @Nullable class_1922 blockGetter, @NotNull List<class_2561> tooltips, @NotNull class_1836 tooltipFlag) {
                            for (int i = 1; i <= yuushyaBlock.properties.lines; ++i) {
                                tooltips.add((class_2561)class_2561.method_43471((String)(this.method_9539() + ".line" + i)));
                            }
                        }
                    };
                }
            }
        }
        final List<? extends class_2769<?>> blockStateProperties = YuushyaBlockFactory.getBlockStateProperties(yuushyaBlock.blockstate);
        switch (yuushyaBlock.classType) {
            case "CableBlock": {
                return new CableBlock(properties, yuushyaBlock.properties.lines, "CableBlock", yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage);
            }
            case "": {
                return new class_2248(properties);
            }
        }
        return new BlockWithClassType(properties, yuushyaBlock.properties.lines, yuushyaBlock.classType, yuushyaBlock.autoGenerated.collision, yuushyaBlock.usage){
            {
                super(properties, tipLines, classType, autoCollision, usage);
                this.method_9590(YuushyaBlockStates.getDefaultBlockState((class_2680)this.field_10647.method_11664()));
            }

            protected void method_9515(class_2689.class_2690<class_2248, class_2680> stateBuilder) {
                stateBuilder.method_11667((class_2769[])blockStateProperties.toArray(class_2769[]::new));
            }

            @Nullable
            public class_2680 method_9605(class_1750 blockPlaceContext) {
                class_2680 res = this.method_9564();
                if (blockStateProperties.contains(class_2741.field_12555) && blockStateProperties.contains(class_2741.field_12481)) {
                    class_2350 direction = blockPlaceContext.method_7715();
                    res = direction.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)res.method_11657((class_2769)class_2741.field_12555, (Comparable)(direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)class_2741.field_12481, (Comparable)blockPlaceContext.method_8042()) : (class_2680)((class_2680)res.method_11657((class_2769)class_2741.field_12555, (Comparable)class_2738.field_12471)).method_11657((class_2769)class_2741.field_12481, (Comparable)direction.method_10153());
                }
                return res;
            }

            public class_2680 method_9559(class_2680 blockState, class_2350 direction, class_2680 blockState2, class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
                return blockState;
            }
        };
    }

    public static boolean isTheSameBlock(class_2680 state1, class_2680 state2) {
        return state2.method_26204() == state1.method_26204();
    }

    public static boolean isTheSameFacing(class_2680 blockState1, class_2680 blockState2) {
        return blockState1.method_11654((class_2769)class_2741.field_12481) == blockState2.method_11654((class_2769)class_2741.field_12481);
    }

    public static boolean isTheSameLine(class_2680 blockState1, class_2680 blockState2) {
        return blockState1.method_11654((class_2769)class_2741.field_12481) == blockState2.method_11654((class_2769)class_2741.field_12481) || blockState1.method_11654((class_2769)class_2741.field_12481) == ((class_2350)blockState2.method_11654((class_2769)class_2741.field_12481)).method_10153();
    }

    public static class BlockWithClassType
    extends AbstractYuushyaBlock {
        public String classType;
        public String autoCollision;
        public YuushyaRegistryData.Block.Usage usage;
        private final Map<class_2680, class_265> voxelShapeCache = new HashMap<class_2680, class_265>();

        public BlockWithClassType(class_4970.class_2251 properties, Integer tipLines, String classType, String autoCollision, YuushyaRegistryData.Block.Usage usage) {
            super(properties, tipLines);
            this.classType = classType;
            this.autoCollision = autoCollision;
            this.usage = usage;
        }

        public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
            if (this.usage != null) {
                if (!level.field_9236 && this.usage.sound != null && !this.usage.sound.isBlank() && player.method_5998(hand).method_7960()) {
                    class_3414 soundEvent = (class_3414)class_7923.field_41172.method_10223(new class_2960(this.usage.sound));
                    level.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 0.2f);
                }
                if (this.usage.sitPos != null && this.usage.sitPos.size() == 3 && player.method_5998(hand).method_7960()) {
                    return ChairEntityUtils.use(new class_243((double)this.usage.sitPos.get(0).floatValue(), (double)this.usage.sitPos.get(1).floatValue(), (double)this.usage.sitPos.get(2).floatValue()), state, level, pos, player, hand, hit);
                }
                if (this.usage.cycleForms != null && !this.usage.cycleForms.isEmpty() && player.method_5998(hand).method_7960()) {
                    while (!this.usage.cycleForms.contains((state = (class_2680)state.method_28493((class_2769)YuushyaBlockStates.FORM)).method_11654((class_2769)YuushyaBlockStates.FORM))) {
                    }
                    level.method_8652(pos, state, 2);
                    return class_1269.method_29236((boolean)level.field_9236);
                }
            }
            return super.method_9534(state, level, pos, player, hand, hit);
        }

        public boolean isTheSameType(BlockWithClassType block) {
            return this.classType.equals(block.classType);
        }

        public class_265 method_9530(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
            if (!this.voxelShapeCache.containsKey(blockState)) {
                if (!YuushyaBlockFactory.getYuushyaVoxelShapes().containsKey(class_2248.method_9507((class_2680)blockState))) {
                    CollisionFileReader.readCollisionToVoxelShape(this.voxelShapeCache, blockState.method_26204(), class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString());
                }
                class_265 shape = YuushyaBlockFactory.getYuushyaVoxelShapes().getOrDefault(class_2248.method_9507((class_2680)blockState), class_259.method_1073());
                this.voxelShapeCache.put(blockState, shape);
                return shape;
            }
            return this.voxelShapeCache.get(blockState);
        }

        public class_2680 method_9598(class_2680 state, class_2470 rotation) {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
            }
            if (state.method_28498((class_2769)class_2741.field_12481)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
            }
            return super.method_9598(state, rotation);
        }

        public class_2680 method_9569(class_2680 state, class_2415 mirror) {
            if (state.method_28498((class_2769)class_2741.field_12525)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12525, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)class_2741.field_12525)));
            }
            if (state.method_28498((class_2769)class_2741.field_12481)) {
                return (class_2680)state.method_11657((class_2769)class_2741.field_12481, (Comparable)mirror.method_10343((class_2350)state.method_11654((class_2769)class_2741.field_12481)));
            }
            return super.method_9569(state, mirror);
        }
    }
}

