/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.packets;

import java.util.Arrays;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import xerca.xercapaint.CanvasType;
import xerca.xercapaint.entity.EntityEasel;

public class CanvasMiniUpdatePacket {
    private int[] pixels;
    private CanvasType canvasType;
    private String name;
    private int version;
    private int easelId;
    private boolean messageIsValid;

    public CanvasMiniUpdatePacket(int[] pixels, String name, int version, EntityEasel easel, CanvasType canvasType) {
        this.name = name;
        this.version = version;
        this.canvasType = canvasType;
        int area = CanvasType.getHeight(canvasType) * CanvasType.getWidth(canvasType);
        this.pixels = Arrays.copyOfRange(pixels, 0, area);
        this.easelId = easel == null ? -1 : easel.method_5628();
    }

    public CanvasMiniUpdatePacket() {
        this.messageIsValid = false;
    }

    public class_2540 encode() {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(this.easelId);
        buf.writeByte(this.canvasType.ordinal());
        buf.writeInt(this.version);
        buf.method_10814(this.name);
        buf.method_10806(this.pixels);
        return buf;
    }

    public static CanvasMiniUpdatePacket decode(class_2540 buf) {
        CanvasMiniUpdatePacket result = new CanvasMiniUpdatePacket();
        try {
            result.easelId = buf.readInt();
            result.canvasType = CanvasType.fromByte(buf.readByte());
            result.version = buf.readInt();
            result.name = buf.method_10800(64);
            int area = CanvasType.getHeight(result.canvasType) * CanvasType.getWidth(result.canvasType);
            result.pixels = buf.method_10799(area);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading CanvasUpdatePacket: " + ioe);
            return null;
        }
        result.messageIsValid = true;
        return result;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }

    public int getVersion() {
        return this.version;
    }

    public int getEaselId() {
        return this.easelId;
    }

    public CanvasType getCanvasType() {
        return this.canvasType;
    }
}

