/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.item.crafting;

import java.util.ArrayList;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_6328;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.item.ItemPalette;
import xerca.xercapaint.item.Items;

@ParametersAreNonnullByDefault
@class_6328
public class RecipeFillPalette
extends class_1852 {
    public RecipeFillPalette(class_2960 resourceLocation, class_7710 craftingBookCategory) {
        super(resourceLocation, craftingBookCategory);
    }

    private boolean isPalette(class_1799 stack) {
        return stack.method_7909() instanceof ItemPalette;
    }

    private boolean isDye(class_1799 stack) {
        return stack.method_7909() instanceof class_1769;
    }

    private int findPalette(class_8566 inv) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (!this.isPalette(stack)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    private ArrayList<class_1799> findDyes(class_8566 inv, int paletteId) {
        ArrayList<class_1799> dyes = new ArrayList<class_1799>();
        for (int i = 0; i < inv.method_5439(); ++i) {
            if (i == paletteId) continue;
            class_1799 stack = inv.method_5438(i);
            if (this.isDye(stack)) {
                dyes.add(stack);
                continue;
            }
            if (stack.method_7960()) continue;
            return null;
        }
        return dyes;
    }

    public boolean matches(class_8566 inv, class_1937 worldIn) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return false;
        }
        ArrayList<class_1799> dyes = this.findDyes(inv, paletteId);
        return dyes != null && !dyes.isEmpty();
    }

    public class_1799 assemble(class_8566 inv, @NotNull class_5455 access) {
        int paletteId = this.findPalette(inv);
        if (paletteId < 0) {
            return class_1799.field_8037;
        }
        ArrayList<class_1799> dyes = this.findDyes(inv, paletteId);
        if (dyes == null || dyes.isEmpty()) {
            return class_1799.field_8037;
        }
        class_1799 inputPalette = inv.method_5438(paletteId);
        class_2487 orgTag = inputPalette.method_7948().method_10553();
        byte[] basicColors = orgTag.method_10545("basic") ? orgTag.method_10547("basic") : new byte[16];
        for (class_1799 dye : dyes) {
            class_1767 color = ((class_1769)dye.method_7909()).method_7802();
            int realColorId = 15 - color.method_7789();
            if (basicColors[realColorId] > 0) {
                return class_1799.field_8037;
            }
            basicColors[realColorId] = 1;
        }
        orgTag.method_10570("basic", basicColors);
        class_1799 result = new class_1799((class_1935)Items.ITEM_PALETTE);
        result.method_7980(orgTag);
        return result;
    }

    public class_2371<class_1799> getRemainingItems(class_8566 inv) {
        return class_2371.method_10213((int)inv.method_5439(), (Object)class_1799.field_8037);
    }

    public class_1865<?> method_8119() {
        return Items.CRAFTING_SPECIAL_PALETTE_FILLING;
    }

    public boolean method_8113(int width, int height) {
        return width >= 2 && height >= 2;
    }
}

