/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.class_1074;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.minimap.highlight.DimensionHighlighterHandler;
import xaero.common.minimap.render.radar.element.RadarRenderer;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.mods.SupportXaeroWorldmap;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.element.HoveredMapElementHolder;
import xaero.map.gui.GuiMap;
import xaero.map.misc.KeySortableByOther;
import xaero.map.mods.SupportBetterPVP;
import xaero.map.mods.SupportMinimap;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuRenderContext;
import xaero.map.mods.gui.WaypointMenuRenderProvider;
import xaero.map.mods.gui.WaypointMenuRenderer;
import xaero.map.mods.gui.WaypointRenderer;
import xaero.map.mods.minimap.element.RadarRendererWrapperHelper;
import xaero.map.mods.minimap.tracker.system.MinimapSyncedPlayerTrackerSystem;
import xaero.map.radar.tracker.system.IPlayerTrackerSystem;

public class SupportXaeroMinimap {
    AXaeroMinimap modMain;
    public int compatibilityVersion;
    private boolean deathpoints = true;
    private boolean refreshWaypoints = true;
    private WaypointWorld waypointWorld;
    private WaypointWorld mapWaypointWorld;
    private double dimDiv;
    private WaypointSet waypointSet;
    private boolean allSets;
    private ArrayList<Waypoint> waypoints;
    private ArrayList<Waypoint> waypointsSorted;
    private WaypointMenuRenderer waypointMenuRenderer;
    private final WaypointRenderer waypointRenderer;
    private IPlayerTrackerSystem<?> minimapSyncedPlayerTrackerSystem;

    public SupportXaeroMinimap() {
        try {
            Class<?> mmClassTest = Class.forName("xaero.pvp.BetterPVP");
            this.modMain = SupportBetterPVP.getMain();
            WorldMap.LOGGER.info("Xaero's WorldMap Mod: Better PVP found!");
        }
        catch (ClassNotFoundException e) {
            try {
                Class<?> mmClassTest = Class.forName("xaero.minimap.XaeroMinimap");
                this.modMain = SupportMinimap.getMain();
                WorldMap.LOGGER.info("Xaero's WorldMap Mod: Xaero's minimap found!");
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.modMain != null) {
            try {
                this.compatibilityVersion = SupportXaeroWorldmap.WORLDMAP_COMPATIBILITY_VERSION;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            if (this.compatibilityVersion < 3) {
                throw new RuntimeException("Xaero's Minimap 20.23.0 or newer required!");
            }
        }
        this.waypointRenderer = WaypointRenderer.Builder.begin().setMinimap(this).setSymbolCreator(WorldMap.waypointSymbolCreator).build();
    }

    public void register() {
        if (this.hasTrackedPlayerSystemSupport()) {
            WorldMap.playerTrackerSystemManager.register("minimap_synced", this.getMinimapSyncedPlayerTrackerSystem());
        }
    }

    public ArrayList<Waypoint> convertWaypoints(double dimDiv) {
        if (this.waypointSet == null) {
            return null;
        }
        ArrayList<Waypoint> result = new ArrayList<Waypoint>();
        if (!this.allSets) {
            this.convertSet(this.waypointSet, result, dimDiv);
        } else {
            HashMap sets = this.waypointWorld.getSets();
            for (WaypointSet set : sets.values()) {
                this.convertSet(set, result, dimDiv);
            }
        }
        this.deathpoints = this.modMain.getSettings().getDeathpoints();
        return result;
    }

    private void convertSet(WaypointSet set, ArrayList<Waypoint> result, double dimDiv) {
        ArrayList list = set.getList();
        String setName = set.getName();
        boolean showingDisabled = WorldMap.settings.showDisabledWaypoints;
        for (int i = 0; i < list.size(); ++i) {
            xaero.common.minimap.waypoints.Waypoint w = (xaero.common.minimap.waypoints.Waypoint)list.get(i);
            if (!showingDisabled && w.isDisabled()) continue;
            result.add(this.convertWaypoint(w, true, setName, dimDiv));
        }
    }

    public Waypoint convertWaypoint(xaero.common.minimap.waypoints.Waypoint w, boolean editable, String setName, double dimDiv) {
        int waypointType = w.getWaypointType();
        Waypoint converted = new Waypoint(w, w.getX(), w.getY(), w.getZ(), w.getName(), w.getSymbol(), ModSettings.COLORS[w.getColor()], waypointType, editable, setName, w.isYIncluded(), dimDiv);
        converted.setDisabled(w.isDisabled());
        converted.setYaw(w.getYaw());
        converted.setRotation(w.isRotation());
        converted.setTemporary(w.isTemporary());
        converted.setGlobal(w.isGlobal());
        return converted;
    }

    public void openWaypoint(GuiMap parent, Waypoint waypoint) {
        if (!waypoint.isEditable()) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, waypoint.getSetName());
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public void createWaypoint(GuiMap parent, int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        GuiAddWaypoint addScreen = new GuiAddWaypoint(this.modMain, minimapSession.getWaypointsManager(), (class_437)parent, (class_437)parent, null, this.waypointWorld.getContainer().getRootContainer().getKey(), this.waypointWorld, this.waypointWorld.getCurrent(), true, x, y, z);
        class_310.method_1551().method_1507((class_437)addScreen);
    }

    public void createTempWaypoint(int x, int y, int z) {
        if (this.waypointWorld == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        if (y == Short.MAX_VALUE) {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z, false);
        } else {
            waypointsManager.createTemporaryWaypoints(this.waypointWorld, x, y, z);
        }
        this.requestWaypointsRefresh();
    }

    public boolean canTeleport(WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        return world != null && waypointsManager.canTeleport(waypointsManager.isWorldTeleportable(world), world);
    }

    public void teleportToWaypoint(class_437 screen, Waypoint w) {
        this.teleportToWaypoint(screen, w, this.waypointWorld);
    }

    public void teleportToWaypoint(class_437 screen, Waypoint w, WaypointWorld world) {
        if (world == null) {
            return;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        waypointsManager.teleportToWaypoint((xaero.common.minimap.waypoints.Waypoint)w.getOriginal(), world, screen);
    }

    public void disableWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setDisabled(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void deleteWaypoint(Waypoint waypoint) {
        if (!this.allSets) {
            this.waypointSet.getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal());
        } else {
            WaypointSet set;
            HashMap sets = this.waypointWorld.getSets();
            Iterator iterator = sets.values().iterator();
            while (iterator.hasNext() && !(set = (WaypointSet)iterator.next()).getList().remove((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal())) {
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        this.waypoints.remove(waypoint);
        this.waypointsSorted.remove(waypoint);
        this.waypointMenuRenderer.updateFilteredList();
    }

    public void checkWaypoints(boolean multiplayer, class_5321<class_1937> dimId, String multiworldId, int width, int height, GuiMap screen) {
        WaypointSet checkingSet;
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID() + "/" + waypointsManager.getDimensionDirectoryName(dimId));
        this.mapWaypointWorld = container == null ? null : (WaypointWorld)container.worlds.get(!multiplayer ? "waypoints" : multiworldId);
        WaypointWorld checkingWaypointWorld = WorldMap.settings.onlyCurrentMapWaypoints ? this.mapWaypointWorld : waypointsManager.getCurrentWorld();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724.method_6059(Effects.NO_WAYPOINTS) || mc.field_1724.method_6059(Effects.NO_WAYPOINTS_HARMFUL)) {
            checkingWaypointWorld = null;
        }
        boolean shouldRefresh = this.refreshWaypoints;
        if (checkingWaypointWorld != this.waypointWorld) {
            this.waypointWorld = checkingWaypointWorld;
            screen.closeRightClick();
            if (screen.waypointMenu) {
                screen.method_25423(class_310.method_1551(), width, height);
            }
            shouldRefresh = true;
        }
        WaypointSet waypointSet = checkingSet = checkingWaypointWorld == null ? null : checkingWaypointWorld.getCurrentSet();
        if (checkingSet != this.waypointSet) {
            this.waypointSet = checkingSet;
            shouldRefresh = true;
        }
        if (this.allSets != this.modMain.getSettings().renderAllSets) {
            this.allSets = this.modMain.getSettings().renderAllSets;
            shouldRefresh = true;
        }
        if (shouldRefresh) {
            this.dimDiv = this.waypointWorld == null ? 1.0 : waypointsManager.getDimensionDivision(this.waypointWorld.getContainer().getKey());
            this.waypoints = this.convertWaypoints(this.dimDiv);
            if (this.waypoints != null) {
                Collections.sort(this.waypoints);
                this.waypointsSorted = new ArrayList();
                ArrayList<KeySortableByOther<Waypoint>> sortingList = new ArrayList<KeySortableByOther<Waypoint>>();
                for (Waypoint waypoint : this.waypoints) {
                    sortingList.add(new KeySortableByOther<Waypoint>(waypoint, new Comparable[]{waypoint.getComparisonName(), waypoint.getName()}));
                }
                Collections.sort(sortingList);
                for (KeySortableByOther keySortableByOther : sortingList) {
                    this.waypointsSorted.add((Waypoint)keySortableByOther.getKey());
                }
            } else {
                this.waypointsSorted = null;
            }
            this.waypointMenuRenderer.updateFilteredList();
        }
        this.refreshWaypoints = false;
    }

    public HoveredMapElementHolder<?, ?> renderWaypointsMenu(class_332 guiGraphics, GuiMap gui, double scale, int width, int height, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, HoveredMapElementHolder<?, ?> hovered, class_310 mc) {
        return this.waypointMenuRenderer.renderMenu(guiGraphics, gui, scale, width, height, mouseX, mouseY, leftMousePressed, leftMouseClicked, hovered, mc);
    }

    public void requestWaypointsRefresh() {
        this.refreshWaypoints = true;
    }

    public class_304 getWaypointKeyBinding() {
        return ModSettings.newWaypoint;
    }

    public class_304 getTempWaypointKeyBinding() {
        return ModSettings.keyInstantWaypoint;
    }

    public class_304 getTempWaypointsMenuKeyBinding() {
        return ModSettings.keyWaypoints;
    }

    public void onMapKeyPressed(class_3675.class_307 type, int code, GuiMap screen) {
        class_304 listPlayerAlternative;
        class_304 minimapSettingsKB;
        class_304 kb = null;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, this.getToggleRadarKey())) {
            screen.onRadarButton(screen.getRadarButton());
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyToggleMapWaypoints)) {
            this.getWaypointMenuRenderer().onRenderWaypointsButton(screen, screen.field_22789, screen.field_22790);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar)) {
            ModSettings.keyReverseEntityRadar.method_23481(true);
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keySwitchSet)) {
            kb = ModSettings.keySwitchSet;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyAllSets)) {
            kb = ModSettings.keyAllSets;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyWaypoints)) {
            kb = ModSettings.keyWaypoints;
        }
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, minimapSettingsKB = (class_304)this.modMain.getSettingsKey())) {
            kb = minimapSettingsKB;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, listPlayerAlternative)) {
            listPlayerAlternative.method_23481(true);
        }
        class_310 mc = class_310.method_1551();
        if (kb != null) {
            if (kb == ModSettings.keyWaypoints) {
                this.openWaypointsMenu(mc, screen);
                return;
            }
            if (minimapSettingsKB != null && kb == minimapSettingsKB) {
                this.openSettingsScreen(mc, screen, screen);
                return;
            }
            this.handleMinimapKeyBinding(kb, screen);
        }
    }

    public boolean onMapKeyReleased(class_3675.class_307 type, int code, GuiMap screen) {
        class_304 listPlayerAlternative;
        boolean result = false;
        if (xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, ModSettings.keyReverseEntityRadar)) {
            ModSettings.keyReverseEntityRadar.method_23481(false);
            result = true;
        }
        if ((listPlayerAlternative = this.getMinimapListPlayersAlternative()) != null && xaero.map.misc.Misc.inputMatchesKeyBinding(type, code, listPlayerAlternative)) {
            listPlayerAlternative.method_23481(false);
            result = true;
        }
        return result;
    }

    public void handleMinimapKeyBinding(class_304 kb, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getControls().keyDown(kb, false, false);
        if ((kb == ModSettings.keySwitchSet || kb == ModSettings.keyAllSets) && screen.waypointMenu) {
            screen.method_25423(class_310.method_1551(), screen.field_22789, screen.field_22790);
        }
    }

    public void drawSetChange(class_332 guiGraphics) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawSetChange(minimapSession.getWaypointsManager(), guiGraphics, class_310.method_1551().method_22683());
    }

    public float getMinimapBrightnessOldCompatibility() {
        return this.modMain.getSupportMods().worldmapSupport.getMinimapBrightness();
    }

    public class_437 openSettingsScreen(class_310 mc, class_437 current, class_437 escape) {
        this.modMain.getGuiHelper().openMinimapSettingsFromScreen(current, escape);
        return class_310.method_1551().field_1755;
    }

    public String getControlsTooltip() {
        return class_1074.method_4662((String)"gui.xaero_box_controls_minimap", (Object[])new Object[]{xaero.map.misc.Misc.getKeyName(ModSettings.newWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keyInstantWaypoint), xaero.map.misc.Misc.getKeyName(ModSettings.keySwitchSet), xaero.map.misc.Misc.getKeyName(ModSettings.keyAllSets), xaero.map.misc.Misc.getKeyName(ModSettings.keyWaypoints)});
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.waypointMenuRenderer.onMapMouseRelease(par1, par2, par3);
    }

    public void onMapConstruct() {
        this.waypointMenuRenderer = new WaypointMenuRenderer(new WaypointMenuRenderContext(), new WaypointMenuRenderProvider(this), this.waypointRenderer);
    }

    public void onMapInit(GuiMap mapScreen, class_310 mc, int width, int height) {
        this.waypointMenuRenderer.onMapInit(mapScreen, mc, width, height, this.waypointWorld, this.modMain, XaeroMinimapSession.getCurrentSession());
    }

    public ArrayList<Waypoint> getWaypointsSorted() {
        return this.waypointsSorted;
    }

    public boolean waypointExists(Waypoint w) {
        return this.waypoints != null && this.waypoints.contains(w);
    }

    public void toggleTemporaryWaypoint(Waypoint waypoint) {
        ((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).setTemporary(!((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
        try {
            this.modMain.getSettings().saveWaypoints(this.waypointWorld);
        }
        catch (IOException e) {
            WorldMap.LOGGER.error("suppressed exception", (Throwable)e);
        }
        waypoint.setDisabled(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isDisabled());
        waypoint.setTemporary(((xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal()).isTemporary());
    }

    public void openWaypointsMenu(class_310 mc, GuiMap screen) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        mc.method_1507((class_437)new GuiWaypoints(this.modMain, minimapSession, (class_437)screen, (class_437)screen));
    }

    public boolean screenShouldSkipWorldRender(class_437 currentScreen) {
        return Misc.screenShouldSkipWorldRender((AXaeroMinimap)this.modMain, (class_437)currentScreen, (boolean)false);
    }

    public boolean hidingWaypointCoordinates() {
        return this.modMain.getSettings().hideWaypointCoordinates;
    }

    public void shareWaypoint(Waypoint waypoint, GuiMap screen, WaypointWorld world) {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        minimapSession.getWaypointSharing().shareWaypoint((class_437)screen, (xaero.common.minimap.waypoints.Waypoint)waypoint.getOriginal(), world);
    }

    public void shareLocation(GuiMap guiMap, int rightClickX, int rightClickY, int rightClickZ) {
        int wpColor = (int)((double)ModSettings.COLORS.length * Math.random());
        xaero.common.minimap.waypoints.Waypoint minimapLocationWaypoint = new xaero.common.minimap.waypoints.Waypoint(rightClickX, rightClickY == Short.MAX_VALUE ? 0 : rightClickY, rightClickZ, "Shared Location", "S", wpColor, 0, false, rightClickY != Short.MAX_VALUE);
        Waypoint locationWaypoint = this.convertWaypoint(minimapLocationWaypoint, false, "", 1.0);
        this.shareWaypoint(locationWaypoint, guiMap, this.mapWaypointWorld);
    }

    public WaypointWorld getMapWaypointWorld() {
        return this.mapWaypointWorld;
    }

    public WaypointWorld getWaypointWorld() {
        return this.waypointWorld;
    }

    public double getDimDiv() {
        return this.dimDiv;
    }

    public int getArrowColorIndex() {
        return this.modMain.getSettings().arrowColour;
    }

    public float[] getArrowColor() {
        block3: {
            block2: {
                if (this.modMain.getSettings().arrowColour < 0) break block2;
                int n = this.modMain.getSettings().arrowColour;
                this.modMain.getSettings();
                if (n < ModSettings.arrowColours.length) break block3;
            }
            return null;
        }
        this.modMain.getSettings();
        return ModSettings.arrowColours[this.modMain.getSettings().arrowColour];
    }

    public String getSubWorldNameToRender() {
        if (WorldMap.settings.onlyCurrentMapWaypoints || this.waypointWorld == null) {
            return null;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        if (this.waypointWorld != waypointsManager.getAutoWorld()) {
            return class_1074.method_4662((String)"gui.xaero_wm_using_custom_subworld", (Object[])new Object[]{this.waypointWorld.getContainer().getSubName()});
        }
        return null;
    }

    public void registerMinimapHighlighters(Object highlighterRegistry) {
    }

    public ArrayList<Waypoint> getWaypoints() {
        return this.waypoints;
    }

    public boolean getDeathpoints() {
        return this.deathpoints;
    }

    public WaypointRenderer getWaypointRenderer() {
        return this.waypointRenderer;
    }

    public WaypointMenuRenderer getWaypointMenuRenderer() {
        return this.waypointMenuRenderer;
    }

    public void onClearHighlightHash(int regionX, int regionZ) {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh(regionX, regionZ);
        }
    }

    public void createRadarRendererWrapper(Object radarRenderer) {
        new RadarRendererWrapperHelper().createWrapper(this.modMain, (RadarRenderer)radarRenderer);
    }

    public class_304 getToggleRadarKey() {
        return ModSettings.keyToggleRadar;
    }

    public void onClearHighlightHashes() {
        DimensionHighlighterHandler highlightHandler;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null && (highlightHandler = minimapSession.getMinimapProcessor().getMinimapWriter().getDimensionHighlightHandler()) != null) {
            highlightHandler.requestRefresh();
        }
    }

    public class_304 getToggleAllyPlayersKey() {
        if (this.hasTrackedPlayerSystemSupport()) {
            return ModSettings.keyToggleTrackedPlayers;
        }
        return ModSettings.keyTogglePacPlayers;
    }

    public class_304 getToggleClaimsKey() {
        return ModSettings.keyTogglePacChunkClaims;
    }

    public void onSessionFinalized() {
        this.waypointWorld = null;
        this.mapWaypointWorld = null;
    }

    public void openWaypointWorldTeleportCommandScreen(class_437 parent, class_437 escape) {
        String containerId;
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return;
        }
        WaypointsManager waypointsManager = minimapSession.getWaypointsManager();
        WaypointWorldRootContainer container = waypointsManager.getWorldContainerNullable(containerId = waypointsManager.getAutoRootContainerID()).getRootContainer();
        if (container != null) {
            class_310.method_1551().method_1507((class_437)new GuiWorldTpCommand(this.modMain, parent, escape, container));
        }
    }

    public class_304 getMinimapListPlayersAlternative() {
        return ModSettings.keyAlternativeListPlayers;
    }

    public int getCaveStart(int defaultWorldMapStart, boolean isMapScreen) {
        if (!this.modMain.getSettings().getMinimap() || this.isFairPlay()) {
            return defaultWorldMapStart;
        }
        if (class_310.method_1551().field_1724.method_6059(Effects.NO_CAVE_MAPS) || class_310.method_1551().field_1724.method_6059(Effects.NO_CAVE_MAPS_HARMFUL)) {
            return isMapScreen ? defaultWorldMapStart : Integer.MAX_VALUE;
        }
        int usedCaving = this.getUsedCaving();
        if (usedCaving == Integer.MAX_VALUE) {
            return WorldMap.settings.caveModeStart;
        }
        return usedCaving;
    }

    public int getUsedCaving() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            return minimapSession.getMinimapProcessor().getMinimapWriter().getLoadedCaving();
        }
        return Integer.MAX_VALUE;
    }

    public boolean isFairPlay() {
        return this.modMain.isFairPlay();
    }

    public boolean hasTrackedPlayerSystemSupport() {
        return this.compatibilityVersion >= 17;
    }

    public boolean shouldUseMinimapTrackedPlayers() {
        if (!this.hasTrackedPlayerSystemSupport()) {
            return false;
        }
        XaeroMinimapSession session = XaeroMinimapSession.getCurrentSession();
        if (session == null) {
            return false;
        }
        return session.getMinimapProcessor().getServerModNetworkVersion() >= 1;
    }

    public IPlayerTrackerSystem<?> getMinimapSyncedPlayerTrackerSystem() {
        if (this.minimapSyncedPlayerTrackerSystem == null) {
            this.minimapSyncedPlayerTrackerSystem = new MinimapSyncedPlayerTrackerSystem();
        }
        return this.minimapSyncedPlayerTrackerSystem;
    }
}

