/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.util;

import com.google.common.net.InternetDomainName;
import java.util.Objects;
import net.minecraft.class_310;
import net.minecraft.class_634;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSettingRegistry;

public class DataFolderResolveUtil {
    public static void resolveDataFolder(class_634 connection, CallbackInfoReturnable<String> cir) {
        XaeroPlusSettingRegistry.DataFolderResolutionMode dataFolderResolutionMode = Globals.dataFolderResolutionMode;
        if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.SERVER_NAME) {
            String serverName;
            if (Objects.nonNull(connection.method_45734()) && (serverName = connection.method_45734().field_3752).length() > 0) {
                cir.setReturnValue((Object)("Multiplayer_" + serverName.replace(":", "_")));
                cir.cancel();
                return;
            }
            if (!class_310.method_1551().method_1496()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid MC Server Name. Falling back to default Xaero data folder resolution");
            }
        } else if (dataFolderResolutionMode == XaeroPlusSettingRegistry.DataFolderResolutionMode.BASE_DOMAIN && Objects.nonNull(connection.method_45734())) {
            Object id;
            try {
                id = InternetDomainName.from((String)connection.method_45734().field_3761).topPrivateDomain().toString();
            }
            catch (IllegalArgumentException ex) {
                XaeroPlus.LOGGER.error("Error resolving BASE_DOMAIN data folder. Falling back to default Xaero resolution.", (Throwable)ex);
                return;
            }
            id = ((String)id).replace(":", "_");
            while (((String)id).endsWith(".")) {
                id = ((String)id).substring(0, ((String)id).length() - 1);
            }
            if (((String)id).length() > 0) {
                id = "Multiplayer_" + (String)id;
                cir.setReturnValue(id);
                cir.cancel();
                return;
            }
            if (!class_310.method_1551().method_1496()) {
                XaeroPlus.LOGGER.error("Unable to resolve valid Base domain. Falling back to default Xaero data folder resolution");
            }
        }
    }
}

