/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_304;
import net.minecraft.class_310;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.ConfigSettingEntry;
import xaero.common.settings.ModOptions;
import xaero.map.WorldMapSession;
import xaeroplus.mixin.client.MixinMinimapModOptionsAccessor;
import xaeroplus.mixin.client.MixinWorldMapModOptionsAccessor;
import xaeroplus.settings.XaeroPlusBooleanSetting;
import xaeroplus.settings.XaeroPlusEnumSetting;
import xaeroplus.settings.XaeroPlusFloatSetting;
import xaeroplus.settings.XaeroPlusSetting;

public class XaeroPlusSettingsReflectionHax {
    public static final List<XaeroPlusSetting> XAERO_PLUS_WORLDMAP_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final List<XaeroPlusSetting> XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final List<XaeroPlusSetting> XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final List<XaeroPlusSetting> XAERO_PLUS_MINIMAP_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final List<XaeroPlusSetting> XAERO_PLUS_WAYPOINT_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final Supplier<List<XaeroPlusSetting>> ALL_MINIMAP_SETTINGS = Suppliers.memoize(() -> Stream.of(XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS.stream(), XAERO_PLUS_MINIMAP_SETTINGS.stream(), XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS.stream(), XAERO_PLUS_WAYPOINT_SETTINGS.stream()).flatMap(x -> x).collect(Collectors.toList()));
    public static final List<XaeroPlusSetting> XAERO_PLUS_KEYBIND_SETTINGS = new ArrayList<XaeroPlusSetting>();
    public static final Supplier<List<XaeroPlusSetting>> ALL_SETTINGS = Suppliers.memoize(() -> Stream.of(XAERO_PLUS_WORLDMAP_SETTINGS.stream(), XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS.stream(), XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS.stream(), XAERO_PLUS_MINIMAP_SETTINGS.stream(), XAERO_PLUS_KEYBIND_SETTINGS.stream()).flatMap(x -> x).collect(Collectors.toList()));
    private static final Supplier<List<XaeroPlusBooleanSetting>> memoizingKeybindsList = Suppliers.memoize(() -> Stream.of(XAERO_PLUS_WORLDMAP_SETTINGS.stream(), XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS.stream(), XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS.stream(), XAERO_PLUS_MINIMAP_SETTINGS.stream(), XAERO_PLUS_KEYBIND_SETTINGS.stream(), XAERO_PLUS_WAYPOINT_SETTINGS.stream()).flatMap(x -> x).filter(setting -> setting instanceof XaeroPlusBooleanSetting).map(setting -> (XaeroPlusBooleanSetting)setting).filter(setting -> setting.getKeyBinding() != null).collect(Collectors.toList()));
    private static List<xaero.map.settings.ModOptions> WORLDMAP_MOD_OPTIONS_LIST = null;
    private static List<ModOptions> MINIMAP_OVERLAY_MOD_OPTIONS_LIST = null;
    private static List<ModOptions> MINIMAP_MOD_OPTIONS_LIST = null;
    private static List<ModOptions> MINIMAP_ENTITY_RADAR_MOD_OPTIONS_LIST = null;
    private static List<ModOptions> WAYPOINTS_MOD_OPTIONS_LIST = null;
    public static Supplier<Map<class_304, XaeroPlusBooleanSetting>> keybindingMapSupplier = Suppliers.memoize(() -> memoizingKeybindsList.get().stream().collect(Collectors.toMap(XaeroPlusSetting::getKeyBinding, s -> s)));
    public static Supplier<List<class_304>> keybindsSupplier = Suppliers.memoize(() -> new ArrayList<class_304>(keybindingMapSupplier.get().keySet()));

    private static List<ModOptions> constructXaeroPlusMinimapModOptions(List<XaeroPlusSetting> settings) {
        return settings.stream().map(XaeroPlusSettingsReflectionHax::buildMinimapModOptions).collect(Collectors.toList());
    }

    private static List<xaero.map.settings.ModOptions> constructXaeroPlusWorldMapModOptions(List<XaeroPlusSetting> settings) {
        return settings.stream().map(XaeroPlusSettingsReflectionHax::buildWorldMapModOptions).collect(Collectors.toList());
    }

    public static List<xaero.map.gui.ConfigSettingEntry> getWorldMapConfigSettingEntries() {
        if (WORLDMAP_MOD_OPTIONS_LIST == null) {
            WORLDMAP_MOD_OPTIONS_LIST = XaeroPlusSettingsReflectionHax.constructXaeroPlusWorldMapModOptions(XAERO_PLUS_WORLDMAP_SETTINGS);
        }
        return WORLDMAP_MOD_OPTIONS_LIST.stream().map(xaero.map.gui.ConfigSettingEntry::new).collect(Collectors.toList());
    }

    public static List<ConfigSettingEntry> getMiniMapOverlayConfigSettingEntries() {
        if (MINIMAP_OVERLAY_MOD_OPTIONS_LIST == null) {
            MINIMAP_OVERLAY_MOD_OPTIONS_LIST = XaeroPlusSettingsReflectionHax.constructXaeroPlusMinimapModOptions(XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS);
        }
        return MINIMAP_OVERLAY_MOD_OPTIONS_LIST.stream().map(ConfigSettingEntry::new).collect(Collectors.toList());
    }

    public static List<ConfigSettingEntry> getMiniMapEntityRadarSettingEntries() {
        if (MINIMAP_ENTITY_RADAR_MOD_OPTIONS_LIST == null) {
            MINIMAP_ENTITY_RADAR_MOD_OPTIONS_LIST = XaeroPlusSettingsReflectionHax.constructXaeroPlusMinimapModOptions(XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS);
        }
        return MINIMAP_ENTITY_RADAR_MOD_OPTIONS_LIST.stream().map(ConfigSettingEntry::new).collect(Collectors.toList());
    }

    public static List<ConfigSettingEntry> getMiniMapConfigSettingEntries() {
        if (MINIMAP_MOD_OPTIONS_LIST == null) {
            MINIMAP_MOD_OPTIONS_LIST = XaeroPlusSettingsReflectionHax.constructXaeroPlusMinimapModOptions(XAERO_PLUS_MINIMAP_SETTINGS);
        }
        return MINIMAP_MOD_OPTIONS_LIST.stream().map(ConfigSettingEntry::new).collect(Collectors.toList());
    }

    public static List<ConfigSettingEntry> getWaypointConfigSettingEntries() {
        if (WAYPOINTS_MOD_OPTIONS_LIST == null) {
            WAYPOINTS_MOD_OPTIONS_LIST = XaeroPlusSettingsReflectionHax.constructXaeroPlusMinimapModOptions(XAERO_PLUS_WAYPOINT_SETTINGS);
        }
        return WAYPOINTS_MOD_OPTIONS_LIST.stream().map(ConfigSettingEntry::new).collect(Collectors.toList());
    }

    private static xaero.map.settings.ModOptions buildWorldMapModOptions(XaeroPlusSetting xaeroPlusSetting) {
        try {
            if (xaeroPlusSetting instanceof XaeroPlusBooleanSetting) {
                return MixinWorldMapModOptionsAccessor.createBooleanSetting(xaeroPlusSetting.getSettingName(), new xaero.map.gui.CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly(), xaeroPlusSetting.isRequiresMinimap(), false);
            }
            if (xaeroPlusSetting instanceof XaeroPlusFloatSetting) {
                return MixinWorldMapModOptionsAccessor.createDoubleSetting(xaeroPlusSetting.getSettingName(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueMin(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueMax(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueStep(), new xaero.map.gui.CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly(), xaeroPlusSetting.isRequiresMinimap(), false);
            }
            if (xaeroPlusSetting instanceof XaeroPlusEnumSetting) {
                return MixinWorldMapModOptionsAccessor.createEnumSetting(xaeroPlusSetting.getSettingName(), ((XaeroPlusEnumSetting)xaeroPlusSetting).getIndexMax() + 1, new xaero.map.gui.CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly(), xaeroPlusSetting.isRequiresMinimap(), false);
            }
            throw new RuntimeException("Unknown XaeroPlusSetting type: " + xaeroPlusSetting.getClass().getName());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static ModOptions buildMinimapModOptions(XaeroPlusSetting xaeroPlusSetting) {
        try {
            if (xaeroPlusSetting instanceof XaeroPlusBooleanSetting) {
                return MixinMinimapModOptionsAccessor.createBooleanSetting(xaeroPlusSetting.getSettingName(), new CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly());
            }
            if (xaeroPlusSetting instanceof XaeroPlusFloatSetting) {
                return MixinMinimapModOptionsAccessor.createDoubleSetting(xaeroPlusSetting.getSettingName(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueMin(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueMax(), ((XaeroPlusFloatSetting)xaeroPlusSetting).getValueStep(), new CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly());
            }
            if (xaeroPlusSetting instanceof XaeroPlusEnumSetting) {
                return MixinMinimapModOptionsAccessor.createEnumSetting(xaeroPlusSetting.getSettingName(), 0, ((XaeroPlusEnumSetting)xaeroPlusSetting).getIndexMax(), new CursorBox(xaeroPlusSetting.getTooltipTranslationKey()), xaeroPlusSetting.isIngameOnly());
            }
            throw new RuntimeException("Unknown XaeroPlusSetting type: " + xaeroPlusSetting.getClass().getName());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    static void markChunksDirtyInWriteDistance() {
        WorldMapSession session;
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null && (session = WorldMapSession.getCurrentSession()) != null) {
            session.getMapProcessor().getMapWriter().setDirtyInWriteDistance((class_1657)mc.field_1724, (class_1937)mc.field_1687);
            session.getMapProcessor().getMapWriter().requestCachedColoursClear();
        }
    }

    public static enum SettingLocation {
        WORLD_MAP_MAIN(XAERO_PLUS_WORLDMAP_SETTINGS),
        MINIMAP_OVERLAYS(XAERO_PLUS_MINIMAP_OVERLAY_SETTINGS),
        MINIMAP(XAERO_PLUS_MINIMAP_SETTINGS),
        KEYBINDS(XAERO_PLUS_KEYBIND_SETTINGS),
        MINIMAP_ENTITY_RADAR(XAERO_PLUS_MINIMAP_ENTITY_RADAR_SETTINGS),
        WAYPOINTS(XAERO_PLUS_WAYPOINT_SETTINGS);

        private final List<XaeroPlusSetting> settingsList;

        private SettingLocation(List<XaeroPlusSetting> settingsList) {
            this.settingsList = settingsList;
        }

        public List<XaeroPlusSetting> getSettingsList() {
            return this.settingsList;
        }
    }
}

