/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaeroplus.Globals;
import xaeroplus.settings.TranslatableSettingEnum;
import xaeroplus.settings.XaeroPlusBooleanSetting;
import xaeroplus.settings.XaeroPlusEnumSetting;
import xaeroplus.settings.XaeroPlusFloatSetting;
import xaeroplus.settings.XaeroPlusSetting;

public class XaeroPlusModSettingsHooks {
    private static int loadCount = 0;

    public static void saveSettings(File configFile, List<XaeroPlusSetting> settings) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(configFile, true));){
            settings.forEach(k -> writer.println(k.getSettingName() + ":" + (Serializable)(k instanceof XaeroPlusBooleanSetting ? Boolean.valueOf(((XaeroPlusBooleanSetting)k).getValue()) : (k instanceof XaeroPlusFloatSetting ? Float.valueOf(((XaeroPlusFloatSetting)k).getValue()) : (k instanceof XaeroPlusEnumSetting ? Integer.valueOf(((XaeroPlusEnumSetting)k).getValueIndex()) : "")))));
        }
    }

    public static void loadSettings(File file, List<XaeroPlusSetting> settings) throws IOException {
        ++loadCount;
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String s;
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(setting -> setting.getSettingName().equalsIgnoreCase(args[0])).findFirst();
                if (!settingOptional.isPresent()) continue;
                XaeroPlusSetting setting2 = settingOptional.get();
                if (setting2 instanceof XaeroPlusBooleanSetting) {
                    ((XaeroPlusBooleanSetting)setting2).setValue(Boolean.parseBoolean(args[1]));
                    continue;
                }
                if (setting2 instanceof XaeroPlusFloatSetting) {
                    ((XaeroPlusFloatSetting)setting2).setValue(Float.parseFloat(args[1]));
                    continue;
                }
                if (!(setting2 instanceof XaeroPlusEnumSetting)) continue;
                ((XaeroPlusEnumSetting)setting2).setValueIndex((int)Float.parseFloat(args[1]));
            }
        }
        if (loadCount == 2) {
            Globals.onAllSettingsLoaded();
        }
    }

    public static void getClientBooleanValue(String enumString, List<XaeroPlusSetting> settings, CallbackInfoReturnable<Boolean> cir) {
        Optional<XaeroPlusBooleanSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString) && xaeroPlusSetting instanceof XaeroPlusBooleanSetting).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).findFirst();
        if (settingOptional.isPresent()) {
            cir.setReturnValue((Object)settingOptional.get().getValue());
            cir.cancel();
        }
    }

    public static void setOptionValue(String enumString, Object value, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusBooleanSetting && value instanceof Boolean).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).ifPresent(xaeroPlusBooleanSetting -> xaeroPlusBooleanSetting.setValue((Boolean)value));
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting && value instanceof Integer && (Integer)value <= ((XaeroPlusEnumSetting)xaeroPlusSetting).getIndexMax() && (Integer)value >= 0).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> xaeroPlusEnumSetting.setValueIndex((Integer)value));
    }

    public static void getOptionValue(String enumString, CallbackInfoReturnable<Object> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusBooleanSetting).map(xaeroPlusSetting -> (XaeroPlusBooleanSetting)xaeroPlusSetting).ifPresent(xaeroPlusBooleanSetting -> cir.setReturnValue((Object)xaeroPlusBooleanSetting.getValue()));
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> cir.setReturnValue((Object)xaeroPlusEnumSetting.getValueIndex()));
    }

    public static void setOptionDoubleValue(String enumString, double f, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> foundSetting = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        foundSetting.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusFloatSetting).map(xaeroPlusSetting -> (XaeroPlusFloatSetting)xaeroPlusSetting).ifPresent(xaeroPlusSetting -> xaeroPlusSetting.setValue((float)f));
    }

    public static void getOptionDoubleValue(String enumString, CallbackInfoReturnable<Double> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        settingOptional.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusFloatSetting).map(xaeroPlusSetting -> (XaeroPlusFloatSetting)xaeroPlusSetting).ifPresent(xaeroPlusSetting -> {
            cir.setReturnValue((Object)xaeroPlusSetting.getValue());
            cir.cancel();
        });
    }

    public static void getOptionValueName(String enumString, CallbackInfoReturnable<String> cir, List<XaeroPlusSetting> settings) {
        Optional<XaeroPlusSetting> settingOptional = settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst();
        settingOptional.filter(xaeroPlusSetting -> xaeroPlusSetting instanceof XaeroPlusEnumSetting).map(xaeroPlusSetting -> (XaeroPlusEnumSetting)xaeroPlusSetting).ifPresent(xaeroPlusEnumSetting -> cir.setReturnValue((Object)(xaeroPlusEnumSetting.getValue() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)xaeroPlusEnumSetting.getValue()).getTranslatedName() : ((Enum)xaeroPlusEnumSetting.getValue()).toString())));
    }

    public static void getSliderOptionText(String enumString, CallbackInfoReturnable<String> cir, List<XaeroPlusSetting> settings) {
        settings.stream().filter(xaeroPlusSetting -> xaeroPlusSetting.getSettingName().equals(enumString)).findFirst().ifPresent(xaeroPlusSetting -> {
            String s = xaeroPlusSetting.getTranslatedName() + ": ";
            if (xaeroPlusSetting instanceof XaeroPlusFloatSetting) {
                s = s + String.format("%.2f", Float.valueOf(((XaeroPlusFloatSetting)xaeroPlusSetting).getValue()));
            } else if (xaeroPlusSetting instanceof XaeroPlusEnumSetting) {
                XaeroPlusEnumSetting xaeroPlusEnumSetting = (XaeroPlusEnumSetting)xaeroPlusSetting;
                s = s + (xaeroPlusEnumSetting.getValue() instanceof TranslatableSettingEnum ? ((TranslatableSettingEnum)xaeroPlusEnumSetting.getValue()).getTranslatedName() : ((Enum)xaeroPlusEnumSetting.getValue()).toString());
            }
            cir.setReturnValue((Object)s);
        });
    }
}

