/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.settings;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_304;
import xaeroplus.XaeroPlus;
import xaeroplus.settings.XaeroPlusSetting;
import xaeroplus.settings.XaeroPlusSettingsReflectionHax;

public class XaeroPlusFloatSetting
extends XaeroPlusSetting {
    private final float valueMin;
    private final float valueMax;
    private final float valueStep;
    private float value;
    private Consumer<Float> settingChangeConsumer;

    private XaeroPlusFloatSetting(String settingName, String settingNameTranslationKey, String tooltipTranslationKey, class_304 keyBinding, Supplier<Boolean> visibilitySupplier, float valueMin, float valueStep, float valueMax, Consumer<Float> settingChangeConsumer, float defaultValue) {
        super(settingName, settingNameTranslationKey, tooltipTranslationKey, keyBinding, visibilitySupplier);
        this.valueMin = valueMin;
        this.valueMax = valueMax;
        this.valueStep = valueStep;
        this.value = defaultValue;
        this.settingChangeConsumer = settingChangeConsumer;
    }

    public static XaeroPlusFloatSetting create(String settingName, String settingNameTranslationKey, float valueMin, float valueMax, float valueStep, String tooltipTranslationKey, float defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusFloatSetting setting = new XaeroPlusFloatSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, null, valueMin, valueStep, valueMax, null, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static XaeroPlusFloatSetting create(String settingName, String settingNameTranslationKey, float valueMin, float valueMax, float valueStep, String tooltipTranslationKey, Consumer<Float> changeConsumer, float defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusFloatSetting setting = new XaeroPlusFloatSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, null, valueMin, valueStep, valueMax, changeConsumer, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public static XaeroPlusFloatSetting create(String settingName, String settingNameTranslationKey, float valueMin, float valueMax, float valueStep, String tooltipTranslationKey, Supplier<Boolean> visibilitySupplier, Consumer<Float> changeConsumer, float defaultValue, XaeroPlusSettingsReflectionHax.SettingLocation settingLocation) {
        XaeroPlusFloatSetting setting = new XaeroPlusFloatSetting("[XP] " + settingName, settingNameTranslationKey, tooltipTranslationKey, null, visibilitySupplier, valueMin, valueStep, valueMax, changeConsumer, defaultValue);
        settingLocation.getSettingsList().add(setting);
        return setting;
    }

    public float getValueMin() {
        return this.valueMin;
    }

    public float getValueMax() {
        return this.valueMax;
    }

    public float getValueStep() {
        return this.valueStep;
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
        if (Objects.nonNull(this.getSettingChangeConsumer())) {
            try {
                this.getSettingChangeConsumer().accept(Float.valueOf(value));
            }
            catch (Exception e) {
                XaeroPlus.LOGGER.warn("Error applying setting change consumer for {}", (Object)this.getSettingName(), (Object)e);
            }
        }
    }

    public Consumer<Float> getSettingChangeConsumer() {
        return this.settingChangeConsumer;
    }

    public void setSettingChangeConsumer(Consumer<Float> settingChangeConsumer) {
        this.settingChangeConsumer = settingChangeConsumer;
    }

    @Override
    public void init() {
        if (Objects.nonNull(this.settingChangeConsumer)) {
            this.settingChangeConsumer.accept(Float.valueOf(this.value));
        }
    }
}

