/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2791;
import net.minecraft.class_2812;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ChunkDataEvent;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkScanner;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class OldChunks
extends Module {
    private ChunkHighlightCache oldChunksCache = new ChunkHighlightLocalCache();
    private ChunkHighlightCache modernChunksCache = new ChunkHighlightLocalCache();
    private static final String OLD_CHUNKS_DATABASE_NAME = "XaeroPlusOldChunks";
    private static final String MODERN_CHUNKS_DATABASE_NAME = "XaeroPlusModernChunks";
    private int oldChunksColor = ColorHelper.getColor(0, 0, 255, 100);
    private final class_310 mc = class_310.method_1551();
    private final ExecutorService searchExecutor = Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setNameFormat("XaeroPlus-OldChunks-Search-%d").build());
    private boolean inverse = false;
    private static final ReferenceSet<class_2248> OVERWORLD_BLOCKS = new ReferenceOpenHashSet();
    private static final ReferenceSet<class_2248> NETHER_BLOCKS = new ReferenceOpenHashSet();

    public void setOldChunksCache(boolean disk) {
        Long2LongMap map;
        try {
            map = this.oldChunksCache.getHighlightsState();
            this.oldChunksCache.onDisable();
            this.oldChunksCache = disk ? new ChunkHighlightSavingCache(OLD_CHUNKS_DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.oldChunksCache.onEnable();
                if (map != null) {
                    this.oldChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing old chunks cache", (Throwable)e);
        }
        try {
            map = this.modernChunksCache.getHighlightsState();
            this.modernChunksCache.onDisable();
            this.modernChunksCache = disk ? new ChunkHighlightSavingCache(MODERN_CHUNKS_DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.modernChunksCache.onEnable();
                if (map != null) {
                    this.modernChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing modern chunks cache", (Throwable)e);
        }
    }

    @EventHandler
    public void onChunkData(ChunkDataEvent event) {
        this.searchChunkAsync((class_2791)event.chunk());
    }

    private void searchChunkAsync(class_2791 chunk) {
        this.searchExecutor.submit(() -> {
            try {
                int iterations = 0;
                while (iterations++ < 3 && !this.searchChunk(chunk)) {
                    Thread.sleep(500L);
                }
            }
            catch (Throwable e) {
                XaeroPlus.LOGGER.error("Error searching for OldChunk in chunk: {}, {}", new Object[]{chunk.method_12004().field_9181, chunk.method_12004().field_9180, e});
            }
        });
    }

    private boolean searchChunk(class_2791 chunk) {
        class_5321<class_1937> actualDimension = ChunkUtils.getActualDimension();
        if (actualDimension != class_1937.field_25179 && actualDimension != class_1937.field_25180) {
            return true;
        }
        if (ChunkScanner.chunkContainsBlocks(chunk, actualDimension == class_1937.field_25179 ? OVERWORLD_BLOCKS : NETHER_BLOCKS, 5)) {
            return this.modernChunksCache.addHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
        }
        return this.oldChunksCache.addHighlight(chunk.method_12004().field_9181, chunk.method_12004().field_9180);
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.oldChunksSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.oldChunksCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.oldChunksSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.oldChunksCache.handleWorldChange();
        this.modernChunksCache.handleWorldChange();
    }

    public boolean inUnknownDimension() {
        class_5321<class_1937> dim = ChunkUtils.getActualDimension();
        return dim != class_1937.field_25179 && dim != class_1937.field_25180 && dim != class_1937.field_25181;
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.oldChunksCache.handleTick();
        this.modernChunksCache.handleTick();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isHighlighted, this::getOldChunksColor));
        this.oldChunksCache.onEnable();
        this.modernChunksCache.onEnable();
        this.searchAllLoadedChunks();
    }

    private void searchAllLoadedChunks() {
        if (this.mc.field_1687 == null || this.inUnknownDimension()) {
            return;
        }
        int renderDist = (Integer)this.mc.field_1690.method_42503().method_41753();
        int xMin = ChunkUtils.getPlayerChunkX() - renderDist;
        int xMax = ChunkUtils.getPlayerChunkX() + renderDist;
        int zMin = ChunkUtils.getPlayerChunkZ() - renderDist;
        int zMax = ChunkUtils.getPlayerChunkZ() + renderDist;
        for (int x = xMin; x <= xMax; ++x) {
            for (int z = zMin; z <= zMax; ++z) {
                class_2818 chunk = this.mc.field_1687.method_2935().method_12126(x, z, false);
                if (chunk instanceof class_2812) continue;
                this.searchChunkAsync((class_2791)chunk);
            }
        }
    }

    @Override
    public void onDisable() {
        this.oldChunksCache.onDisable();
        this.modernChunksCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public int getOldChunksColor() {
        return this.oldChunksColor;
    }

    public void setRgbColor(int color) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.oldChunksAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.oldChunksColor = ColorHelper.getColorWithAlpha(this.oldChunksColor, (int)a);
    }

    public boolean isHighlighted(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        if (this.inverse) {
            return this.isOldChunkInverse(chunkPosX, chunkPosZ, dimensionId);
        }
        return this.isOldChunk(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isOldChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.oldChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public boolean isOldChunkInverse(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.modernChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }

    public void setInverse(Boolean b) {
        this.inverse = b;
    }

    static {
        OVERWORLD_BLOCKS.addAll(Arrays.asList(class_2246.field_27120, class_2246.field_29221, class_2246.field_27159, class_2246.field_29032, class_2246.field_27165, class_2246.field_9993, class_2246.field_10463, class_2246.field_28048, class_2246.field_28049, class_2246.field_28888, class_2246.field_28678, class_2246.field_28682, class_2246.field_28683, class_2246.field_28684, class_2246.field_28681, class_2246.field_28675, class_2246.field_28676));
        NETHER_BLOCKS.addAll(Arrays.asList(class_2246.field_22109, class_2246.field_23869, class_2246.field_22091, class_2246.field_22120, class_2246.field_22113, class_2246.field_23077, class_2246.field_23985));
    }
}

