/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.module.impl;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import it.unimi.dsi.fastutil.longs.Long2LongMap;
import java.util.concurrent.TimeUnit;
import net.lenni0451.lambdaevents.EventHandler;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3610;
import net.minecraft.class_5321;
import xaeroplus.Globals;
import xaeroplus.XaeroPlus;
import xaeroplus.event.ClientTickEvent;
import xaeroplus.event.PacketReceivedEvent;
import xaeroplus.event.XaeroWorldChangeEvent;
import xaeroplus.feature.render.ChunkHighlightProvider;
import xaeroplus.feature.render.ColorHelper;
import xaeroplus.feature.render.highlights.ChunkHighlightCache;
import xaeroplus.feature.render.highlights.ChunkHighlightLocalCache;
import xaeroplus.feature.render.highlights.ChunkHighlightSavingCache;
import xaeroplus.mixin.client.mc.AccessorWorldRenderer;
import xaeroplus.module.Module;
import xaeroplus.settings.XaeroPlusSettingRegistry;
import xaeroplus.util.ChunkUtils;

@Module.ModuleInfo
public class NewChunks
extends Module {
    private ChunkHighlightCache newChunksCache = new ChunkHighlightLocalCache();
    private final Cache<Long, Byte> oldChunksCache = Caffeine.newBuilder().maximumSize(50L).expireAfterWrite(10L, TimeUnit.SECONDS).build();
    private int newChunksColor = ColorHelper.getColor(255, 0, 0, 100);
    private final class_310 mc = class_310.method_1551();
    private static final class_2350[] searchDirs = new class_2350[]{class_2350.field_11034, class_2350.field_11043, class_2350.field_11039, class_2350.field_11035, class_2350.field_11036};
    private static final String DATABASE_NAME = "XaeroPlusNewChunks";

    public void setNewChunksCache(boolean disk) {
        try {
            Long2LongMap map = this.newChunksCache.getHighlightsState();
            this.newChunksCache.onDisable();
            this.newChunksCache = disk ? new ChunkHighlightSavingCache(DATABASE_NAME) : new ChunkHighlightLocalCache();
            if (this.isEnabled()) {
                this.newChunksCache.onEnable();
                if (map != null) {
                    this.newChunksCache.loadPreviousState(map);
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error closing new chunks cache", (Throwable)e);
        }
    }

    @EventHandler
    public void onPacketReceivedEvent(PacketReceivedEvent event) {
        block10: {
            class_1923 chunkPos;
            block11: {
                class_2596<?> class_25962;
                block9: {
                    if (this.mc.field_1687 == null || ((AccessorWorldRenderer)this.mc.field_1769).getChunks() == null) {
                        return;
                    }
                    class_25962 = event.packet();
                    if (!(class_25962 instanceof class_2637)) break block9;
                    class_2637 packet = (class_2637)class_25962;
                    packet.method_30621((pos, state) -> {
                        if (!state.method_26227().method_15769() && !state.method_26227().method_15771()) {
                            class_1923 chunkPos = new class_1923(pos);
                            for (class_2350 dir : searchDirs) {
                                if (!this.mc.field_1687.method_8320(pos.method_10093(dir)).method_26227().method_15771() || this.oldChunksCache.getIfPresent((Object)ChunkUtils.chunkPosToLong(chunkPos)) != null) continue;
                                this.newChunksCache.addHighlight(chunkPos.field_9181, chunkPos.field_9180);
                                return;
                            }
                        }
                    });
                    break block10;
                }
                class_25962 = event.packet();
                if (!(class_25962 instanceof class_2626)) break block11;
                class_2626 packet = (class_2626)class_25962;
                if (packet.method_11308().method_26227().method_15769() || packet.method_11308().method_26227().method_15771()) break block10;
                chunkPos = new class_1923(packet.method_11309());
                for (class_2350 dir : searchDirs) {
                    if (!this.mc.field_1687.method_8320(packet.method_11309().method_10093(dir)).method_26227().method_15771() || this.oldChunksCache.getIfPresent((Object)ChunkUtils.chunkPosToLong(chunkPos)) != null) continue;
                    this.newChunksCache.addHighlight(chunkPos.field_9181, chunkPos.field_9180);
                    return;
                }
                break block10;
            }
            chunkPos = event.packet();
            if (chunkPos instanceof class_2672) {
                class_2672 packet = (class_2672)chunkPos;
                class_1923 pos2 = new class_1923(packet.method_11523(), packet.method_11524());
                if (!this.newChunksCache.isHighlighted(pos2.field_9181, pos2.field_9180, ChunkUtils.getActualDimension()) && this.mc.field_1687.method_2935().method_12246(packet.method_11523(), packet.method_11524()) == null) {
                    class_2818 chunk = new class_2818((class_1937)this.mc.field_1687, pos2);
                    try {
                        chunk.method_12224(packet.method_38598().method_38586(), new class_2487(), packet.method_38598().method_38587(packet.method_11523(), packet.method_11524()));
                    }
                    catch (Throwable e) {
                        return;
                    }
                    for (int x = 0; x < 16; ++x) {
                        for (int y = this.mc.field_1687.method_31607(); y < this.mc.field_1687.method_31600(); ++y) {
                            for (int z = 0; z < 16; ++z) {
                                class_3610 fluid = chunk.method_12234(x, y, z);
                                if (fluid.method_15769() || fluid.method_15771()) continue;
                                this.oldChunksCache.put((Object)ChunkUtils.chunkPosToLong(pos2), (Object)0);
                                return;
                            }
                        }
                    }
                }
            }
        }
    }

    @EventHandler
    public void onXaeroWorldChangeEvent(XaeroWorldChangeEvent event) {
        if (XaeroPlusSettingRegistry.newChunksSaveLoadToDisk.getValue() && this.inUnknownDimension() && this.newChunksCache instanceof ChunkHighlightSavingCache) {
            XaeroPlusSettingRegistry.newChunksSaveLoadToDisk.setValue(false);
            XaeroPlus.LOGGER.warn("Entered unknown dimension with saving cache on, disabling disk saving");
        }
        this.newChunksCache.handleWorldChange();
    }

    public boolean inUnknownDimension() {
        class_5321<class_1937> dim = ChunkUtils.getActualDimension();
        return dim != class_1937.field_25179 && dim != class_1937.field_25180 && dim != class_1937.field_25181;
    }

    @EventHandler
    public void onClientTickEvent(ClientTickEvent.Post event) {
        this.newChunksCache.handleTick();
    }

    @Override
    public void onEnable() {
        Globals.drawManager.registerChunkHighlightProvider(this.getClass(), new ChunkHighlightProvider(this::isNewChunk, this::getNewChunksColor));
        this.newChunksCache.onEnable();
    }

    @Override
    public void onDisable() {
        this.newChunksCache.onDisable();
        Globals.drawManager.unregister(this.getClass());
    }

    public int getNewChunksColor() {
        return this.newChunksColor;
    }

    public void setRgbColor(int color) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(color, (int)XaeroPlusSettingRegistry.newChunksAlphaSetting.getValue());
    }

    public void setAlpha(float a) {
        this.newChunksColor = ColorHelper.getColorWithAlpha(this.newChunksColor, (int)a);
    }

    public boolean isNewChunk(int chunkPosX, int chunkPosZ, class_5321<class_1937> dimensionId) {
        return this.newChunksCache.isHighlighted(chunkPosX, chunkPosZ, dimensionId);
    }
}

