/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.mixin.client;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.misc.KeySortableByOther;
import xaero.map.misc.Misc;
import xaeroplus.Globals;
import xaeroplus.settings.XaeroPlusSettingRegistry;

@Mixin(value={GuiWaypoints.class}, remap=false)
public abstract class MixinGuiWaypoints
extends ScreenBase {
    private final int TOGGLE_ALL_ID = 69;
    @Shadow
    private WaypointWorld displayedWorld;
    @Shadow
    private ArrayList<Waypoint> waypointsSorted;
    @Shadow
    private WaypointsManager waypointsManager;
    private class_342 searchField;
    private MySmallButton toggleAllButton;

    protected MixinGuiWaypoints(IXaeroMinimap modMain, class_437 parent, class_437 escape, class_2561 titleIn) {
        super(modMain, parent, escape, titleIn);
    }

    public void method_25393() {
        super.method_25393();
        this.searchField.method_1865();
    }

    @Inject(method={"init"}, at={@At(value="RETURN")}, remap=true)
    public void initGui(CallbackInfo ci) {
        this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - 297, 32, 80, 20, (class_2561)class_2561.method_43470((String)"Search"));
        this.searchField.method_1852("");
        this.searchField.method_25365(true);
        this.searchField.method_1883(0);
        this.searchField.method_1875(0);
        this.method_25429((class_364)this.searchField);
        this.method_25395((class_364)this.searchField);
        Globals.waypointsSearchFilter = "";
        this.toggleAllButton = new MySmallButton(69, this.field_22789 / 2 + 213, this.field_22790 - 53, (class_2561)class_2561.method_43471((String)"gui.waypoints.toggle_enable_all"), b -> this.waypointsSorted.stream().findFirst().ifPresent(firstWaypoint -> {
            boolean firstIsEnabled = firstWaypoint.isDisabled();
            this.waypointsSorted.forEach(waypoint -> waypoint.setDisabled(!firstIsEnabled));
        }));
        this.method_37063((class_364)this.toggleAllButton);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;mouseClicked(DDI)Z", shift=At.Shift.AFTER)}, remap=true)
    public void mouseClickedInject(double x, double y, int button, CallbackInfoReturnable<Boolean> cir) {
        boolean dropDownClosed;
        boolean bl = dropDownClosed = this.openDropdown == null;
        if (dropDownClosed) {
            if (this.searchField.method_25402(x, y, button)) {
                this.searchField.method_25365(true);
                this.searchField.method_1872();
                this.searchField.method_1888(true);
            } else {
                this.searchField.method_25365(false);
            }
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;keyPressed(III)Z", shift=At.Shift.AFTER)}, remap=true, cancellable=true)
    public void keyTypedInject(int keycode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (this.searchField.method_25370()) {
            this.updateSearch();
            cir.setReturnValue((Object)true);
        }
    }

    public boolean method_25400(char c, int i) {
        boolean result = super.method_25400(c, i);
        this.updateSearch();
        return result;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lxaero/common/gui/ScreenBase;render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V", shift=At.Shift.AFTER)}, remap=true)
    public void drawScreenInject(class_332 guiGraphics, int mouseX, int mouseY, float partial, CallbackInfo ci) {
        if (!this.searchField.method_25370() && this.searchField.method_1882().isEmpty()) {
            Misc.setFieldText((class_342)this.searchField, (String)class_1074.method_4662((String)"gui.xaero_settings_search_placeholder", (Object[])new Object[0]), (int)-11184811);
            this.searchField.method_1870();
        }
        this.searchField.method_25394(guiGraphics, mouseX, mouseY, partial);
        if (!this.searchField.method_25370()) {
            Misc.setFieldText((class_342)this.searchField, (String)Globals.waypointsSearchFilter);
        }
    }

    @Shadow
    protected abstract boolean isOneSelected();

    @Redirect(method={"updateButtons"}, at=@At(value="INVOKE", target="Lxaero/common/gui/GuiWaypoints;isOneSelected()Z"))
    public boolean shareButtonRedirect(GuiWaypoints instance) {
        if (XaeroPlusSettingRegistry.disableWaypointSharing.getValue()) {
            return false;
        }
        return this.isOneSelected();
    }

    private void updateSearch() {
        String newValue;
        if (this.searchField.method_25370() && !Objects.equal((Object)Globals.waypointsSearchFilter, (Object)(newValue = this.searchField.method_1882()))) {
            Globals.waypointsSearchFilter = this.searchField.method_1882();
            this.updateSortedList();
        }
    }

    @Overwrite
    private void updateSortedList() {
        WaypointsSort sortType = this.displayedWorld.getContainer().getRootContainer().getSortType();
        ArrayList waypointsList = this.displayedWorld.getCurrentSet().getList();
        GuiWaypoints.distanceDivided = this.waypointsManager.getDimensionDivision(this.displayedWorld);
        class_4184 camera = this.field_22787.field_1773.method_19418();
        ArrayList<Waypoint> disabledWaypoints = new ArrayList<Waypoint>();
        ArrayList<Waypoint> enabledWaypoints = new ArrayList<Waypoint>();
        for (Waypoint w : waypointsList) {
            if (w.isDisabled()) {
                disabledWaypoints.add(w);
                continue;
            }
            enabledWaypoints.add(w);
        }
        if (!Globals.waypointsSearchFilter.isEmpty()) {
            enabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(Globals.waypointsSearchFilter.toLowerCase()));
            disabledWaypoints.removeIf(waypoint -> !waypoint.getName().toLowerCase().contains(Globals.waypointsSearchFilter.toLowerCase()));
        }
        this.waypointsSorted = new ArrayList();
        this.waypointsSorted.addAll(this.sortWaypoints(enabledWaypoints, sortType, camera));
        this.waypointsSorted.addAll(this.sortWaypoints(disabledWaypoints, sortType, camera));
    }

    private List<Waypoint> sortWaypoints(List<Waypoint> waypointsList, WaypointsSort sortType, class_4184 camera) {
        ArrayList<Waypoint> waypointsSorted = new ArrayList<Waypoint>();
        ArrayList<KeySortableByOther> sortableKeys = new ArrayList<KeySortableByOther>();
        for (Waypoint w : waypointsList) {
            Object sortVal = 0;
            switch (sortType) {
                case NONE: {
                    break;
                }
                case ANGLE: {
                    sortVal = -w.getComparisonAngleCos(camera, GuiWaypoints.distanceDivided);
                    break;
                }
                case COLOR: {
                    sortVal = w.getColor();
                    break;
                }
                case NAME: {
                    sortVal = w.getComparisonName();
                    break;
                }
                case SYMBOL: {
                    sortVal = w.getSymbol();
                    break;
                }
                case DISTANCE: {
                    sortVal = w.getComparisonDistance(camera, GuiWaypoints.distanceDivided);
                }
            }
            sortableKeys.add(new KeySortableByOther((Object)w, new Comparable[]{sortVal}));
        }
        Collections.sort(sortableKeys);
        for (KeySortableByOther k : sortableKeys) {
            waypointsSorted.add((Waypoint)k.getKey());
        }
        if (this.displayedWorld.getContainer().getRootContainer().isSortReversed()) {
            Collections.reverse(waypointsSorted);
        }
        return waypointsSorted;
    }
}

