/*
 * Decompiled with CFR 0.152.
 */
package xaeroplus.feature.render.highlights;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import xaeroplus.XaeroPlus;
import xaeroplus.feature.render.highlights.ChunkHighlightBaseCacheHandler;

public class ChunkHighlightLocalCache
extends ChunkHighlightBaseCacheHandler {
    private static final int maxNumber = 5000;

    @Override
    public boolean addHighlight(int x, int z) {
        this.limitChunksSize();
        super.addHighlight(x, z);
        return true;
    }

    @Override
    public boolean addHighlight(int x, int z, long foundTime) {
        this.limitChunksSize();
        super.addHighlight(x, z, foundTime);
        return true;
    }

    private void limitChunksSize() {
        try {
            if (this.chunks.size() > 5000 && this.lock.readLock().tryLock(1L, TimeUnit.SECONDS)) {
                List<Long> toRemove = this.chunks.long2LongEntrySet().stream().sorted(Map.Entry.comparingByValue()).limit(500L).map(Map.Entry::getKey).collect(Collectors.toList());
                this.lock.readLock().unlock();
                if (this.lock.writeLock().tryLock(1L, TimeUnit.SECONDS)) {
                    toRemove.forEach(l -> this.chunks.remove(l.longValue()));
                    this.lock.writeLock().unlock();
                }
            }
        }
        catch (Exception e) {
            XaeroPlus.LOGGER.error("Error limiting local cache size", (Throwable)e);
        }
    }

    @Override
    public void handleWorldChange() {
    }

    @Override
    public void handleTick() {
    }

    @Override
    public void onEnable() {
    }

    @Override
    public void onDisable() {
    }
}

