/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.registry;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class RegistryFilter<T>
implements IRegistryFilter<T> {
    public static final ThreadLocal<@Nullable class_5455> REGISTRY = ThreadLocal.withInitial(() -> null);
    public static final Set<RegistryFilter<?>> INSTANCES = Collections.newSetFromMap(Collections.synchronizedMap(new WeakHashMap()));
    private static final Log LOG = Log.create();
    private final class_5321<? extends class_2378<T>> registryKey;
    private final Set<Rule<T>> rules;
    private final ThreadLocal<@Nullable class_2378<T>> registry = ThreadLocal.withInitial(() -> null);
    private final ThreadLocal<Set<T>> entries = ThreadLocal.withInitial(Set::of);
    private final ThreadLocal<Boolean> loaded = ThreadLocal.withInitial(() -> true);

    private RegistryFilter(class_5321<? extends class_2378<T>> registry, Set<Rule<T>> rules) {
        this.registryKey = registry;
        this.rules = rules;
        INSTANCES.add(this);
        this.attach();
    }

    public static void attach(@Nullable class_5455 registryAccess) {
        REGISTRY.set(registryAccess);
        INSTANCES.forEach(RegistryFilter::attach);
    }

    public void attach() {
        class_5455 access = REGISTRY.get();
        this.registry.set(access == null ? null : access.method_30530(this.registryKey));
        this.entries.set(Set.of());
        this.loaded.set(false);
    }

    private void load() {
        if (this.loaded.get().booleanValue()) {
            return;
        }
        class_2378 registry = this.registry.get();
        if (registry == null) {
            return;
        }
        Stopwatch stopwatch = null;
        if (LOG.isDebugEnabled()) {
            stopwatch = Stopwatch.createStarted();
            LOG.debug("Attaching registry to filter, id: {}", this.hashCode());
        }
        HashSet entries = new HashSet(this.entries.get().size());
        this.rules.forEach(rule -> registry.method_40270().forEach(holder -> {
            if (rule.matches(holder)) {
                entries.add(holder.comp_349());
            }
        }));
        this.entries.set(Collections.unmodifiableSet(entries));
        if (stopwatch != null) {
            LOG.debug("Finished in {}ms, {} entries matched", stopwatch.elapsed(TimeUnit.MILLISECONDS), entries.size());
            entries.stream().map(it -> Objects.requireNonNull(registry.method_10221(it)).toString()).sorted().forEach(it -> LOG.debug("\t{}", it));
        }
        this.loaded.set(true);
    }

    @Override
    public Collection<T> getMatches() {
        this.load();
        return this.entries.get();
    }

    @Override
    public boolean matches(T object) {
        this.load();
        return this.entries.get().contains(object);
    }

    private static interface Rule<T> {
        public boolean matches(class_6880.class_6883<T> var1);
    }

    public static class Builder<T>
    implements IRegistryFilter.Builder<T> {
        private final class_5321<? extends class_2378<T>> registryKey;
        private final Set<Rule<T>> rules;
        @Nullable
        private final Stopwatch stopwatch;

        public Builder(class_5321<? extends class_2378<T>> registryKey) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Start filter for {}", registryKey.method_29177());
                this.stopwatch = Stopwatch.createStarted();
            } else {
                this.stopwatch = null;
            }
            this.registryKey = registryKey;
            this.rules = new HashSet<Rule<T>>();
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String rule) {
            char prefix = rule.charAt(0);
            switch (prefix) {
                case '@': {
                    LOG.debug("\tNamespace: {}", rule);
                    String namespace = rule.substring(1);
                    this.rules.add(it -> it.method_40237().method_29177().method_12836().equals(namespace));
                    break;
                }
                case '#': {
                    LOG.debug("\tTag      : {}", rule);
                    class_2960 tagId = new class_2960(rule.substring(1));
                    class_6862 tag = class_6862.method_40092(this.registryKey, (class_2960)tagId);
                    this.rules.add(it -> it.method_40220(tag));
                    break;
                }
                case '/': {
                    LOG.debug("\tRegex    : {}", rule);
                    Preconditions.checkArgument((boolean)rule.endsWith("/"), (Object)"Regex filter must also ends with /");
                    Pattern pattern = Pattern.compile(rule.substring(1, rule.length() - 1));
                    this.rules.add(it -> pattern.matcher(it.method_40237().method_29177().toString()).matches());
                    break;
                }
                default: {
                    LOG.debug("\tID       : {}", rule);
                    this.rules.add(it -> it.method_40226(new class_2960(rule)));
                }
            }
            return this;
        }

        @Override
        public IRegistryFilter.Builder<T> parse(Iterable<String> rules) {
            rules.forEach(this::parse);
            return this;
        }

        @Override
        public IRegistryFilter.Builder<T> parse(String ... rules) {
            for (String filter : rules) {
                this.parse(filter);
            }
            return this;
        }

        @Override
        public IRegistryFilter<T> build() {
            RegistryFilter<T> res = new RegistryFilter<T>(this.registryKey, this.rules);
            if (this.stopwatch != null) {
                LOG.debug("Finished in {}ms, id: {}", this.stopwatch.elapsed(TimeUnit.MILLISECONDS), res.hashCode());
            }
            return res;
        }
    }
}

