/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.data.ItemData;
import mcp.mobius.waila.mixin.ChiseledBookShelfBlockAccess;
import mcp.mobius.waila.mixin.ChiseledBookShelfBlockEntityAccess;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import mcp.mobius.waila.plugin.vanilla.provider.ItemEntityProvider;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_241;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7716;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public enum ChiseledBookShelfProvider implements IBlockComponentProvider,
IDataProvider<class_7716>
{
    INSTANCE;

    public static final class_2960 DATA;
    private int lastUpdateId = 0;
    private class_1799 hitItem = class_1799.field_8037;

    private void init(IBlockAccessor accessor, IPluginConfig config) {
        if (this.lastUpdateId == accessor.getUpdateId()) {
            return;
        }
        this.lastUpdateId = accessor.getUpdateId();
        this.hitItem = class_1799.field_8037;
        if (!config.getBoolean(Options.BOOK_BOOKSHELF)) {
            return;
        }
        Data data = accessor.getData().get(Data.class);
        if (data == null) {
            return;
        }
        class_2680 blockstate = accessor.getBlockState();
        class_2350 facing = (class_2350)blockstate.method_11654((class_2769)class_2383.field_11177);
        Optional<class_241> relativeHit = ChiseledBookShelfBlockAccess.wthit_getRelativeHitCoordinatesForBlockFace(accessor.getBlockHitResult(), facing);
        if (relativeHit.isEmpty()) {
            return;
        }
        int hitSlot = ChiseledBookShelfBlockAccess.wthit_getHitSlot(relativeHit.get());
        this.hitItem = data.items.get(hitSlot);
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return null;
        }
        return new ItemComponent(this.hitItem);
    }

    @Override
    public void appendHead(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        IWailaConfig.Formatter formatter = IWailaConfig.get().getFormatter();
        tooltip.setLine(WailaConstants.OBJECT_NAME_TAG, formatter.entityName(this.hitItem.method_7964().getString()));
        if (config.getBoolean(WailaConstants.CONFIG_SHOW_REGISTRY)) {
            tooltip.setLine(WailaConstants.REGISTRY_NAME_TAG, formatter.registryName(class_7923.field_41178.method_10221((Object)this.hitItem.method_7909())));
        }
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        ItemEntityProvider.appendBookProperties(tooltip, this.hitItem, config);
    }

    @Override
    public void appendTail(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        this.init(accessor, config);
        if (this.hitItem.method_7960()) {
            return;
        }
        if (!config.getBoolean(WailaConstants.CONFIG_SHOW_MOD_NAME)) {
            return;
        }
        tooltip.setLine(WailaConstants.MOD_NAME_TAG, IWailaConfig.get().getFormatter().modName(IModInfo.get(this.hitItem).getName()));
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_7716> accessor, IPluginConfig config) {
        data.blockAll(ItemData.class);
        if (config.getBoolean(Options.BOOK_BOOKSHELF)) {
            data.add(Data.class, res -> {
                ChiseledBookShelfBlockEntityAccess bookshelf = (ChiseledBookShelfBlockEntityAccess)accessor.getTarget();
                res.add(new Data((List<class_1799>)bookshelf.wthit_items()));
            });
        }
    }

    static {
        DATA = new class_2960("chiseled_bookshelf");
    }

    public record Data(List<class_1799> items) implements IData
    {
        public Data(class_2540 buf) {
            this(buf.method_34066(class_2540::method_10819));
        }

        @Override
        public void write(class_2540 buf) {
            buf.method_34062(this.items, class_2540::method_10793);
        }
    }
}

