/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.reflect.TypeToken;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.config.ConfigEntry;
import mcp.mobius.waila.mcless.config.ConfigIo;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_2960;

public enum PluginConfig implements IPluginConfig
{
    CLIENT,
    SERVER;

    private static final Log LOG;
    private static final Path PATH;
    private static final ConfigIo<Map<String, Map<String, JsonPrimitive>>> IO;
    public static final Map<class_2960, ConfigEntry<?>> CONFIGS;

    public static <T> void addConfig(ConfigEntry<T> entry) {
        CONFIGS.put(entry.getId(), entry);
    }

    public static Set<class_2960> getAllKeys(String namespace) {
        return PluginConfig.getAllKeys().stream().filter(id -> id.method_12836().equals(namespace)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<class_2960> getAllKeys() {
        return CONFIGS.keySet();
    }

    public static Set<ConfigEntry<Object>> getSyncableConfigs() {
        return CONFIGS.values().stream().filter(ConfigEntry::isSynced).map(t -> t).collect(Collectors.toSet());
    }

    public static List<String> getNamespaces() {
        return CONFIGS.keySet().stream().map(class_2960::method_12836).distinct().sorted((o1, o2) -> o1.equals("waila") ? -1 : (o2.equals("waila") ? 1 : o1.compareToIgnoreCase((String)o2))).collect(Collectors.toList());
    }

    public static <T> ConfigEntry<T> getEntry(class_2960 key) {
        return CONFIGS.get(key);
    }

    public static <T> void set(class_2960 key, T value) {
        ConfigEntry<?> entry = CONFIGS.get(key);
        if (entry != null) {
            entry.setLocalValue(value);
        }
    }

    public static void reload() {
        if (!Files.exists(PATH, new LinkOption[0])) {
            PluginConfig.writeConfig();
        }
        Map<String, Map<String, JsonPrimitive>> config = IO.read(PATH);
        config.forEach((namespace, subMap) -> subMap.forEach((path, value) -> {
            ConfigEntry<?> entry = CONFIGS.get(new class_2960(namespace, path));
            if (entry != null) {
                entry.setLocalValue(entry.getType().parser.apply((JsonPrimitive)value, (JsonPrimitive)entry.getDefaultValue()));
            }
        }));
        LOG.info("Plugin config reloaded");
    }

    public static void save() {
        PluginConfig.writeConfig();
    }

    private static void writeConfig() {
        LinkedHashMap<String, Map> config = new LinkedHashMap<String, Map>();
        Iterator<ConfigEntry<?>> iterator = CONFIGS.values().iterator();
        while (iterator.hasNext()) {
            ConfigEntry<?> e;
            ConfigEntry<?> entry = e = iterator.next();
            class_2960 id = entry.getId();
            config.computeIfAbsent(id.method_12836(), k -> new LinkedHashMap()).put(id.method_12832(), entry.getType().serializer.apply(entry.getLocalValue()));
        }
        IO.write(PATH, config);
    }

    private <T> T getValue(class_2960 key, T defaultValue) {
        return (T)(CONFIGS.containsKey(key) ? CONFIGS.get(key).getValue(this == SERVER) : defaultValue);
    }

    @Override
    public Set<class_2960> getKeys() {
        return PluginConfig.getAllKeys();
    }

    @Override
    public Set<class_2960> getKeys(String namespace) {
        return PluginConfig.getAllKeys(namespace);
    }

    @Override
    public boolean getBoolean(class_2960 key) {
        return this.getValue(key, false);
    }

    @Override
    public int getInt(class_2960 key) {
        return this.getValue(key, 0);
    }

    @Override
    public double getDouble(class_2960 key) {
        return this.getValue(key, 0).intValue();
    }

    @Override
    public String getString(class_2960 key) {
        return this.getValue(key, "");
    }

    @Override
    public <T extends Enum<T>> T getEnum(class_2960 key) {
        return (T)((Enum)this.getValue(key, null));
    }

    static {
        LOG = Log.create();
        PATH = Waila.CONFIG_DIR.resolve("waila/waila_plugins.json");
        IO = new ConfigIo<Map>(LOG::warn, LOG::error, new GsonBuilder().setPrettyPrinting().create(), new TypeToken<Map<String, Map<String, JsonPrimitive>>>(){}.getType(), LinkedHashMap::new);
        CONFIGS = new LinkedHashMap();
    }
}

