/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.api.IBlacklistConfig;
import mcp.mobius.waila.api.IRegistryFilter;
import mcp.mobius.waila.util.Log;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class BlacklistConfig {
    private static final Log LOG = Log.create();
    private static final String BLACKLIST_TAG = "#" + Waila.id("blacklist");
    public static final int VERSION = 0;
    public final LinkedHashSet<String> blocks = new LinkedHashSet();
    public final LinkedHashSet<String> blockEntityTypes = new LinkedHashSet();
    public final LinkedHashSet<String> entityTypes = new LinkedHashSet();
    private int configVersion = 0;
    public int[] pluginHash = new int[]{0, 0, 0};
    @Nullable
    private transient View view;

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    public View getView() {
        if (this.view == null) {
            this.view = new View();
        }
        return this.view;
    }

    public class View
    implements IBlacklistConfig {
        public final IRegistryFilter<class_2248> blockFilter;
        public final IRegistryFilter<class_2591<?>> blockEntityFilter;
        public final IRegistryFilter<class_1299<?>> entityFilter;
        @Nullable
        private IRegistryFilter<class_2248> syncedBlockFilter = null;
        @Nullable
        private IRegistryFilter<class_2591<?>> syncedBlockEntityFilter = null;
        @Nullable
        private IRegistryFilter<class_1299<?>> syncedEntityFilter = null;

        private View() {
            this.blockFilter = IRegistryFilter.of(class_7924.field_41254).parse(BlacklistConfig.this.blocks).build();
            this.blockEntityFilter = IRegistryFilter.of(class_7924.field_41255).parse(BlacklistConfig.this.blockEntityTypes).build();
            this.entityFilter = IRegistryFilter.of(class_7924.field_41266).parse(BlacklistConfig.this.entityTypes).build();
        }

        public void sync(Set<String> blockRules, Set<String> blockEntityRules, Set<String> entityRules) {
            this.syncedBlockFilter = View.sync(class_7924.field_41254, BlacklistConfig.this.blocks, blockRules);
            this.syncedBlockEntityFilter = View.sync(class_7924.field_41255, BlacklistConfig.this.blockEntityTypes, blockEntityRules);
            this.syncedEntityFilter = View.sync(class_7924.field_41266, BlacklistConfig.this.entityTypes, entityRules);
        }

        private static <T> IRegistryFilter<T> sync(class_5321<? extends class_2378<T>> registryKey, Set<String> localRules, Set<String> syncedRules) {
            LOG.debug("Syncing blacklist {}", registryKey.method_29177());
            return IRegistryFilter.of(registryKey).parse((String[])syncedRules.stream().filter(it -> !localRules.contains(it)).toArray(String[]::new)).build();
        }

        @Override
        public boolean contains(class_2248 block) {
            return this.blockFilter.matches(block) || this.syncedBlockFilter != null && this.syncedBlockFilter.matches(block);
        }

        @Override
        public boolean contains(class_2586 blockEntity) {
            class_2591 type = blockEntity.method_11017();
            return this.blockEntityFilter.matches(type) || this.syncedBlockEntityFilter != null && this.syncedBlockEntityFilter.matches(type);
        }

        @Override
        public boolean contains(class_1297 entity) {
            class_1299 type = entity.method_5864();
            return this.entityFilter.matches(type) || this.syncedEntityFilter != null && this.syncedEntityFilter.matches(type);
        }
    }

    public static class Adapter
    implements JsonSerializer<BlacklistConfig>,
    JsonDeserializer<BlacklistConfig> {
        public JsonElement serialize(BlacklistConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            String[] comments = "On the SERVER, changes will be applied after the server is restarted\nOn the CLIENT, changes will be applied after player quit and rejoin a world\n\nRule Operators:\n@namespace - Filter objects based on their namespace location\n#tag       - Filter objects based on data pack tags\n/regex/    - Filter objects based on regular expression\ndefault    - Filter objects with specific ID\n\nThe %s tag rule can not be removed".formatted(BLACKLIST_TAG).split("\n");
            JsonArray commentArray = new JsonArray();
            for (String line : comments) {
                commentArray.add(line);
            }
            object.add("_comment", (JsonElement)commentArray);
            object.add("blocks", context.serialize(src.blocks));
            object.add("blockEntityTypes", context.serialize(src.blockEntityTypes));
            object.add("entityTypes", context.serialize(src.entityTypes));
            object.addProperty("configVersion", (Number)src.configVersion);
            object.add("pluginHash", context.serialize((Object)src.pluginHash));
            return object;
        }

        public BlacklistConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            BlacklistConfig res = new BlacklistConfig();
            res.blocks.add(BLACKLIST_TAG);
            res.blockEntityTypes.add(BLACKLIST_TAG);
            res.entityTypes.add(BLACKLIST_TAG);
            this.deserializeEntries(res.blocks, object.getAsJsonArray("blocks"));
            this.deserializeEntries(res.blockEntityTypes, object.getAsJsonArray("blockEntityTypes"));
            this.deserializeEntries(res.entityTypes, object.getAsJsonArray("entityTypes"));
            res.configVersion = object.get("configVersion").getAsInt();
            res.pluginHash = (int[])context.deserialize(object.get("pluginHash"), int[].class);
            return res;
        }

        private void deserializeEntries(LinkedHashSet<String> set, JsonArray array) {
            for (JsonElement entry : array) {
                set.add(entry.getAsString());
            }
        }
    }
}

