/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.IntFunction;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.data.BuiltinDataUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;

public final class ItemData
implements IData {
    public static final class_2960 ID = BuiltinDataUtil.rl("item");
    public static final class_2960 CONFIG_SYNC_NBT = BuiltinDataUtil.rl("item.nbt");
    public static final class_2960 CONFIG_MAX_HEIGHT = BuiltinDataUtil.rl("item.max_height");
    private final IPluginConfig config;
    private final ArrayList<class_1799> items = new ArrayList();
    private boolean syncNbt;

    public static ItemData of(IPluginConfig config) {
        return new ItemData(config);
    }

    public ItemData vanilla(class_1263 container) {
        int size = container.method_5439();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(container.method_5438(i));
        }
        return this;
    }

    public ItemData getter(IntFunction<class_1799> getter, int size) {
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(getter.apply(i));
        }
        return this;
    }

    public ItemData add(class_1799 stack) {
        this.items.add(stack);
        return this;
    }

    public ItemData add(class_1799 ... stacks) {
        this.ensureSpace(stacks.length);
        Collections.addAll(this.items, stacks);
        return this;
    }

    public ItemData add(Collection<class_1799> stacks) {
        this.items.addAll(stacks);
        return this;
    }

    public ItemData ensureSpace(int length) {
        this.items.ensureCapacity(this.items.size() + length);
        return this;
    }

    @ApiStatus.Internal
    private ItemData(IPluginConfig config) {
        this.config = config;
    }

    @ApiStatus.Internal
    public ItemData(class_2540 buf) {
        this.config = null;
        this.syncNbt = buf.readBoolean();
        int size = buf.method_10816();
        this.ensureSpace(size);
        for (int i = 0; i < size; ++i) {
            if (buf.readBoolean()) continue;
            class_1792 item = (class_1792)buf.method_42064((class_2359)class_7923.field_41178);
            int count = buf.method_10816();
            class_1799 stack = new class_1799((class_1935)item, count);
            if (this.syncNbt) {
                stack.method_7980(buf.method_10798());
            }
            this.add(stack);
        }
    }

    @Override
    @ApiStatus.Internal
    public void write(class_2540 buf) {
        boolean syncNbt = this.config.getBoolean(CONFIG_SYNC_NBT);
        buf.writeBoolean(syncNbt);
        buf.method_10804(this.items.size());
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) {
                buf.writeBoolean(true);
                continue;
            }
            buf.writeBoolean(false);
            buf.method_42065((class_2359)class_7923.field_41178, (Object)stack.method_7909());
            buf.method_10804(stack.method_7947());
            if (!syncNbt) continue;
            buf.method_10794(stack.method_7969());
        }
    }

    @ApiStatus.Internal
    public ArrayList<class_1799> items() {
        return this.items;
    }

    @ApiStatus.Internal
    public boolean syncNbt() {
        return this.syncNbt;
    }
}

