/*
 * Decompiled with CFR 0.152.
 */
package wraith.fwaystones.integration.journeymap;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import joptsimple.internal.Strings;
import journeymap.client.api.IClientAPI;
import journeymap.client.api.IClientPlugin;
import journeymap.client.api.display.DisplayType;
import journeymap.client.api.display.Displayable;
import journeymap.client.api.display.Waypoint;
import journeymap.client.api.event.ClientEvent;
import journeymap.client.api.event.RegistryEvent;
import journeymap.client.api.event.fabric.FabricEvents;
import journeymap.client.api.event.fabric.FullscreenDisplayEvent;
import journeymap.client.api.model.MapImage;
import journeymap.client.api.option.BooleanOption;
import journeymap.client.api.option.OptionCategory;
import org.jetbrains.annotations.NotNull;
import wraith.fwaystones.FabricWaystones;
import wraith.fwaystones.access.WaystoneValue;
import wraith.fwaystones.integration.event.WaystoneEvents;
import wraith.fwaystones.util.Utils;

public class JourneymapPlugin
implements IClientPlugin {
    private final List<String> queuedWaypoints = new ArrayList<String>();
    private IClientAPI api = null;
    private BooleanOption enabled;
    private BooleanOption displayWaypoints;
    private boolean mappingStarted = false;

    public void initialize(IClientAPI api) {
        this.api = api;
        api.subscribe(this.getModId(), EnumSet.of(ClientEvent.Type.REGISTRY, ClientEvent.Type.MAPPING_STOPPED, ClientEvent.Type.MAPPING_STARTED));
        WaystoneEvents.REMOVE_WAYSTONE_EVENT.register(this::onRemove);
        WaystoneEvents.DISCOVER_WAYSTONE_EVENT.register(this::onDiscover);
        WaystoneEvents.RENAME_WAYSTONE_EVENT.register(this::onRename);
        WaystoneEvents.FORGET_ALL_WAYSTONES_EVENT.register(player -> api.removeAll(this.getModId()));
        FabricEvents.ADDON_BUTTON_DISPLAY_EVENT.register(this::onFullscreenAddonButton);
    }

    private void onFullscreenAddonButton(FullscreenDisplayEvent.AddonButtonDisplayEvent addonButtonDisplayEvent) {
        addonButtonDisplayEvent.getThemeButtonDisplay().addThemeToggleButton("fwaystones.integration.journeymap.theme.on", "fwaystones.integration.journeymap.theme.off", "fabric_waystones_icon", ((Boolean)this.displayWaypoints.get()).booleanValue(), b -> {
            b.toggle();
            this.displayWaypoints.set((Object)b.getToggled());
            this.updateWaypointDisplay(b.getToggled());
        });
    }

    public String getModId() {
        return "fwaystones";
    }

    public void onEvent(@NotNull ClientEvent event) {
        try {
            switch (event.type) {
                case MAPPING_STARTED: {
                    this.mappingStarted = true;
                    this.buildQueuedWaypoints();
                    break;
                }
                case MAPPING_STOPPED: {
                    this.mappingStarted = false;
                    this.api.removeAll(this.getModId());
                    break;
                }
                case REGISTRY: {
                    RegistryEvent registryEvent = (RegistryEvent)event;
                    if (registryEvent.getRegistryType() != RegistryEvent.RegistryType.OPTIONS) break;
                    OptionCategory category = new OptionCategory(this.getModId(), "fwaystones.integration.journeymap.category");
                    this.enabled = new BooleanOption(category, "enabled", "fwaystones.integration.journeymap.enable", Boolean.valueOf(true));
                    this.displayWaypoints = new BooleanOption(new OptionCategory(this.getModId(), "Hidden"), "displayed", "fwaystones.integration.journeymap.enable", Boolean.valueOf(true));
                }
            }
        }
        catch (Throwable t) {
            FabricWaystones.LOGGER.error(t.getMessage(), t);
        }
    }

    private void updateWaypointDisplay(boolean display) {
        if (!display) {
            this.api.removeAll(this.getModId(), DisplayType.Waypoint);
        } else {
            FabricWaystones.WAYSTONE_STORAGE.getAllHashes().forEach(this::addWaypoint);
        }
    }

    private void buildQueuedWaypoints() {
        this.queuedWaypoints.forEach(this::addWaypoint);
        this.queuedWaypoints.clear();
    }

    private void onRemove(String hash) {
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        Waypoint waypoint = this.api.getWaypoint(this.getModId(), hash);
        if (waypoint != null) {
            this.api.remove((Displayable)waypoint);
        }
    }

    private void onDiscover(String hash) {
        if (FabricWaystones.WAYSTONE_STORAGE == null) {
            return;
        }
        if (!((Boolean)this.enabled.get()).booleanValue()) {
            return;
        }
        if (this.mappingStarted) {
            this.addWaypoint(hash);
        } else {
            this.queuedWaypoints.add(hash);
        }
    }

    private void onRename(String hash) {
        this.onRemove(hash);
        this.addWaypoint(hash);
    }

    private void addWaypoint(String hash) {
        if (FabricWaystones.WAYSTONE_STORAGE == null || this.api.getWaypoint(this.getModId(), hash) != null) {
            return;
        }
        WaystoneValue waystone = FabricWaystones.WAYSTONE_STORAGE.getWaystoneData(hash);
        if (waystone == null) {
            return;
        }
        MapImage icon = new MapImage(Utils.ID("images/fabric_waystones_icon.png"), 16, 16);
        Waypoint waypoint = ((Waypoint)new Waypoint(this.getModId(), waystone.getHash(), Strings.isNullOrEmpty((String)waystone.getWaystoneName()) ? "Unnamed Waystone" : waystone.getWaystoneName(), waystone.getWorldName(), waystone.way_getPos()).setIcon(icon)).setPersistent(false);
        try {
            waypoint.setColor(waystone.getColor());
            waypoint.setEnabled(((Boolean)this.displayWaypoints.get()).booleanValue());
            this.api.show((Displayable)waypoint);
        }
        catch (Throwable t) {
            FabricWaystones.LOGGER.error(t.getMessage(), t);
        }
    }
}

