/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.setup;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import ipsis.woot.Woot;
import ipsis.woot.commands.ModCommands;
import ipsis.woot.mod.ModFiles;
import ipsis.woot.modules.anvil.AnvilRecipes;
import ipsis.woot.modules.factory.items.MobShardItem;
import ipsis.woot.modules.factory.multiblock.MultiBlockTracker;
import ipsis.woot.modules.fluidconvertor.FluidConvertorRecipes;
import ipsis.woot.modules.infuser.InfuserRecipes;
import ipsis.woot.modules.squeezer.SqueezerRecipes;
import ipsis.woot.simulator.CustomDropsLoader;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.MobSimulatorSetup;
import ipsis.woot.simulator.spawning.FakePlayerPool;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.FakeMobKey;
import ipsis.woot.util.helper.ItemEntityHelper;
import ipsis.woot.util.helper.SerializationHelper;
import ipsis.woot.util.oss.WootFakePlayer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;

public class ForgeEventHandlers {
    private static final long MULTI_BLOCK_TRACKER_DELAY = 20L;
    private static List<TickTrack> tickTracks = new ArrayList<TickTrack>();
    private final int MAX_UUID_CACHE_SIZE = 10;
    private List<String> uuidList = new ArrayList<String>();

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDropsEvent(LivingDropsEvent event) {
        if (!(event.getEntity() instanceof MobEntity)) {
            return;
        }
        MobEntity mobEntity = (MobEntity)event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        if (damageSource == null) {
            return;
        }
        if (!FakePlayerPool.isFakePlayer(damageSource.func_76346_g())) {
            return;
        }
        event.setCanceled(true);
        List<ItemStack> drops = ItemEntityHelper.convertToItemStacks(event.getDrops());
        FakeMobKey fakeMobKey = new FakeMobKey(new FakeMob(mobEntity), event.getLootingLevel());
        if (fakeMobKey.getMob().isValid()) {
            MobSimulator.getInstance().learnSimulatedDrops(fakeMobKey, drops);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onLivingDeathEvent(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof PlayerEntity)) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        PlayerEntity killer = (PlayerEntity)event.getSource().func_76346_g();
        LivingEntity victim = event.getEntityLiving();
        if (this.ignoreDeathEvent(event.getEntity())) {
            Woot.setup.getLogger().debug("onLivingDeathEvent: duplicate {} {}", (Object)event.getEntity(), (Object)event.getEntity().func_189512_bd());
            return;
        }
        if (killer instanceof FakePlayer) {
            return;
        }
        if (victim instanceof PlayerEntity) {
            return;
        }
        if (!(victim instanceof MobEntity)) {
            return;
        }
        FakeMob fakeMob = new FakeMob((MobEntity)victim);
        if (!fakeMob.isValid()) {
            return;
        }
        MobShardItem.handleKill(killer, fakeMob);
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        TickTrack currTick = null;
        for (TickTrack tickTrack : tickTracks) {
            if (tickTrack.world != event.world) continue;
            currTick = tickTrack;
            break;
        }
        if (currTick == null) {
            currTick = new TickTrack(event.world);
            tickTracks.add(currTick);
        }
        if (event.world.func_234923_W_().equals(MobSimulatorSetup.TARTARUS)) {
            MobSimulator.getInstance().tick(event.world);
        } else if (currTick.tick(event.world.func_82737_E())) {
            MultiBlockTracker.get().run(event.world);
        }
    }

    @SubscribeEvent
    public static void onFileChange(ModConfig.Reloading configEvent) {
        Woot.setup.getLogger().info("onFileChange");
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerStartingEvent event) {
        Woot.setup.getLogger().info("onServerStarting");
        SqueezerRecipes.load(event.getServer().func_199529_aN());
        AnvilRecipes.load(event.getServer().func_199529_aN());
        InfuserRecipes.load(event.getServer().func_199529_aN());
        FluidConvertorRecipes.load(event.getServer().func_199529_aN());
        CustomDropsLoader.load(event.getServer().func_199529_aN());
        for (ServerWorld world : event.getServer().func_212370_w()) {
            Woot.setup.getLogger().debug("onServerStarting: world {}", (Object)world.func_234923_W_());
        }
        ServerWorld serverWorld = event.getServer().func_71218_a(MobSimulatorSetup.TARTARUS);
        if (serverWorld == null) {
            Woot.setup.getLogger().error("onServerStarting: tartarus not found");
        } else {
            Woot.setup.getLogger().info("onServerStarting: force load Tartarus Cells");
            serverWorld.func_217458_b(0, 0, true);
        }
    }

    @SubscribeEvent
    public void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        if (event.getAttackingPlayer() instanceof WootFakePlayer) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRecipesUpdatedEvent(RecipesUpdatedEvent event) {
        Woot.setup.getLogger().info("onRecipesUpdatedEvent");
        SqueezerRecipes.load(event.getRecipeManager());
        AnvilRecipes.load(event.getRecipeManager());
        InfuserRecipes.load(event.getRecipeManager());
        FluidConvertorRecipes.load(event.getRecipeManager());
    }

    @SubscribeEvent
    public void onRegisterCommandsEvent(RegisterCommandsEvent event) {
        Woot.setup.getLogger().info("onRegisterCommandsEvent");
        ModCommands.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onServerStop(FMLServerStoppingEvent event) {
        Woot.setup.getLogger().info("onServerStop");
        JsonObject jsonObject = MobSimulator.getInstance().toJson();
        File dropFile = ModFiles.INSTANCE.getLootFile();
        Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        SerializationHelper.writeJsonFile(dropFile, GSON.toJson((JsonElement)jsonObject));
    }

    private boolean ignoreDeathEvent(Entity entity) {
        String uuid = entity.func_189512_bd();
        if (this.uuidList.contains(uuid)) {
            return true;
        }
        this.uuidList.add(uuid);
        if (this.uuidList.size() > 10) {
            this.uuidList.remove(0);
        }
        return false;
    }

    private static class TickTrack {
        public World world;
        public long lastWorldTick;

        public TickTrack(World world) {
            this.world = world;
            this.lastWorldTick = 0L;
        }

        public boolean tick(long gameTime) {
            if (gameTime > this.lastWorldTick + 20L) {
                this.lastWorldTick = gameTime;
                return true;
            }
            return false;
        }
    }
}

